//priority 3
//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.ShinkenObject           = function () {
    this.__class_name__ = "SHINKEN.OBJECT.ShinkenObject";
};
SHINKEN.OBJECT.ShinkenObject.prototype = {
    //********************************************  DEBUG   **************************************************//
    setShinkenDebug : function ( to_set ) {
        this.is_shinken_debug = to_set;
        var _components       = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            if ( _components[ i ] ) {
                _components[ i ].setShinkenDebug( to_set );
            }
        }
    },
    isShinkenDebugOn: function () {
        return this.is_shinken_debug;
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
    },
    //********************************************  SETTER GETTER   **************************************************//
    getChildrenObject          : function () {
        return [];
    },
    getChildrenObjectDict      : function () {
        return {};
    },
    initMessages               : function () {
        this.messages = new SHINKEN.OBJECT.Messages();
    },
    setMessages                : function ( to_set ) {
        this.initMessages();
        if ( !to_set ) {
            this.doActionAfterAddMessages();
            return;
        }
        if ( to_set.__class_name__ === "SHINKEN.OBJECT.Messages" ) {
            this.messages = to_set;
            this.doActionAfterAddMessages();
            return;
        }
        var _keys = Object.keys( to_set );
        
        var _current_key;
        var _current_status;
        for ( var i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            _current_key    = _keys[ i ];
            _current_status = SHINKEN.OBJECT.Messageservice.parseBackendStatus( _current_key );
            for ( var j = 0, _size_j = to_set[ _current_key ].length; j < _size_j; j++ ) {
                this.messages.addMessage( _current_status, to_set[ _current_key ][ j ] );
            }
        }
        this.doActionAfterAddMessages();
    },
    addMessages                : function ( shinken_messages ) {
        this.messages.addMessages( shinken_messages.getAllMessages() );
    },
    addMessage                 : function ( status, text ) {
        if ( !this.messages ) {
            this.messages = new SHINKEN.OBJECT.Messages();
        }
        this.messages.addMessage( status, text );
    },
    doActionAfterAddMessages   : function () {
    },
    getMessages                : function () {
        return this.messages;
    },
    canBeDeleted               : function () {
        return true;
    },
    setDefaultKeyAndValue      : function ( default_key, default_value ) {
        this.setDefaultKeyAndValueCommon( default_key, default_value );
    },
    setDefaultKeyAndValueCommon: function ( default_key, default_value ) {
        this.default_key   = default_key;
        this.default_value = default_value;
    },
    getDefaultValue            : function () {
        return this.default_value;
    },
    getDefaultKey              : function () {
        return this.default_key;
    },
    //********************************************  VALIDATION   **************************************************//
    setNeedValidation: function ( to_set ) {
        this.need_validation = to_set;
        var _components      = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setNeedValidation( to_set );
        }
    },
    //********************************************  PARAMS FOR EVENTS   **************************************************//
    addParamsForEvents     : function ( param_events ) {
        if ( !param_events ) {
            return;
        }
        var _keys = Object.keys( param_events );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            this.addParamForEvents( _keys[ i ], param_events[ _keys[ i ] ] );
        }
    },
    addParamForEvents      : function ( key, value ) {
        this.addParamForEventsCommon( key, value );
    },
    addParamForEventsCommon: function ( key, value ) {
        this._param_for_events        = this._param_for_events || {};
        this._param_for_events[ key ] = value;
    },
    getParamForEvents      : function ( key ) {
        let to_return = this._param_for_events || {};
        if ( key ) {
            return to_return[ key ];
        }
        return to_return;
    },
    //********************************************  OTHER   **************************************************//
    getObjectClassName: function () {
        return this.__class_name__;
    },
    isObjectClassName : function ( to_test ) {
        return to_test === this.__class_name__;
    }
};

SHINKEN.OBJECT.ShinkenObjectForContainer           = function ( uuid ) {
    this.__class_name__ = "SHINKEN.OBJECT.ShinkenObjectForContainer";
    this.uuid           = uuid;
    this.data_to_save   = {};
};
SHINKEN.OBJECT.ShinkenObjectForContainer.prototype = {
    //********************************************  DEBUG   **************************************************//
    getUUID           : function () {
        return this.uuid;
    },
    getDataToSave     : function () {
        return this.data_to_save;
    },
    getDataToSaveByKey: function ( key ) {
        return this.data_to_save[ key ];
    },
    setDataToSaveByKey: function ( key, value ) {
        this.data_to_save[ key ] = value;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectForContainer, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.InterfaceHtml           = function () {
};
SHINKEN.OBJECT.InterfaceHtml.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    addClass   : function ( to_add ) {
        if ( !this.class ) {
            this.class = to_add;
        }
        else {
            this.class = this.class + " " + to_add;
        }
    },
    removeClass: function ( to_remove ) {
        this.class = SHINKEN.TOOLS.STRING.replaceAll( this.class, to_remove, "" );
    },
    hasClass   : function ( to_find ) {
        return SHINKEN.TOOLS.STRING.contains( this.class, to_find );
    },
    getClass   : function ( to_add ) {
        return this.class || "";
    }
};

SHINKEN.OBJECT.ShinkenObjectHtml           = function () {
};
SHINKEN.OBJECT.ShinkenObjectHtml.prototype = {
    //********************************************  SETTER GETTER   **************************************************//
    addClass                  : function ( to_add ) {
        if ( !this.class ) {
            this.class = to_add;
        }
        else {
            this.class = this.class + " " + to_add;
        }
        if ( this.getDomElement() ) {
            this.getDomElement().classList.add( to_add );
        }
    },
    removeClass               : function ( to_remove ) {
        this.class = SHINKEN.TOOLS.STRING.replaceAll( this.class, to_remove, "" );
        if ( this.getDomElement() ) {
            this.getDomElement().classList.remove( to_remove );
        }
    },
    setDomElement             : function ( to_set ) {
        this.dom_element = to_set;
        this.doActionAfterSetDomElement();
    },
    setLabel                  : function ( to_set ) {
        this.label = to_set;
    },
    getLabel                  : function () {
        return this.label;
    },
    getName                   : function () {
        return this.name;
    },
    doActionAfterSetDomElement: function () {
    },
    getDomElement             : function () {
        return this.dom_element;
    },
    getDomElementForTooltip   : function () {
        return this.getDomElement();
    },
    setDomElementStyle        : function ( style_param, style_value ) {
        DOM.Service.setStyle( this.getDomElement(), style_param, style_value );
    },
    addDomElement             : function ( to_add ) {
        return DOM.Service.addElementTo( to_add, this.getDomElement() );
    },
    changeContentDomElement   : function ( new_content ) {
        DOM.Service.empty( this.getDomElement() );
        this.addDomElement( new_content );
    },
    askUpdateHtml             : function () {
        if ( this.timeout_ask_compute_html ) {
            clearTimeout( this.timeout_ask_compute_html );
        }
        this.timeout_ask_compute_html = setTimeout( () => {
            this.updateHtml();
            this.timeout_ask_compute_html = null;
        }, 200 );
    },
    updateHtml                : function () {
    },
    resetHTML                 : function () {
        this.resetHTMLCommon();
    },
    resetHTMLCommon           : function () {
        DOM.Service.removeElement( this.getDomElement() );
        this.setDomElement();
    },
    computeHtml               : function () {
        this.computeHtmlExtra();
    },
    computeHtmlExtra          : function () {
    },
    getObjectType             : function () {
        return "";
    },
    computeHtml_setEventName  : function ( to_set ) {
        this.event_name = to_set;
    },
    setVisibilityState        : function ( to_set ) {
        this.visibility_state = to_set;
        if ( this.getDomElement() ) {
            DOM.Service.setDataSet( this.getDomElement(), "visibilityState", this.getVisibilityState() );
        }
    },
    getVisibilityState        : function () {
        return this.visibility_state || "";
    },
    isVisible                 : function () {
        switch ( this.visibility_state ) {
            case SHINKEN.CONST.VISIBILITY_STATE.HIDDEN:
            case SHINKEN.CONST.VISIBILITY_STATE.TOTALLY_FORM_EXCLUDE:
                return false;
        }
        return true;
    },
    //********************************************  PARAMS FOR EVENTS   **************************************************//
    parseParamForEventsToHtml: function () {
        return SHINKEN.TOOLS.DICT.parseToHTMLParam( this.getParamForEvents() );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    onClick     : function ( event ) {
    },
    hidePopup   : function ( event ) {
    },
    askHidePopup: function ( dom_element ) {
        if ( dom_element === this.getDomElement() ) {
            return false;
        }
        this.hidePopup( dom_element );
        return true;
    },
    askAddClass : function ( to_add, time_out ) {
        //if ( !time_out ) {
        //    return;
        //}
        //if ( !this.getDomElement() ) {
        //    setTimeout( () => {
        //        this.askAddClass( to_add, time_out - 100 );
        //    }, 100 );
        //    return;
        //}
        DOM.Service.askAddClass( this.getDomElement(), to_add, time_out );
    },
    //********************************************  UPDATE HTML  **************************************************//
    askComputeSizes    : function ( param ) {
        if ( this.timeout_ask_compute_size ) {
            clearTimeout( this.timeout_ask_compute_size );
        }
        this.timeout_ask_compute_size = setTimeout( () => {
            this.computeSizes( param );
        }, 200 );
    },
    setTooltipHtml     : function ( to_set, tooltip_type ) {
        this.tooltip_html = to_set;
        this.tooltip_type = tooltip_type;
        this.computeHtml_tooltip();
    },
    removeTooltipHtml  : function () {
        this.tooltip_html = null;
        this.tooltip_type = null;
        this.computeHtml_tooltip();
    },
    computeHtml_tooltip: function () {
        var _dom = this.getDomElementForTooltip();
        if ( !_dom ) {
            return;
        }
        if ( this.tooltip_html ) {
            _dom.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            _dom.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            if ( this.tooltip_type ) {
                _dom.setAttribute( "shi-tip-type", this.tooltip_type );
            }
            _dom.setAttribute( "shi-tip-html", this.tooltip_html );
        }
        else {
            _dom.setAttribute( "shi-tip-html", "" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectHtml, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectHtml, SHINKEN.OBJECT.InterfaceHtml );


SHINKEN.OBJECT.ShinkenObjectContainer           = function () {
    this.initContents();
};
SHINKEN.OBJECT.ShinkenObjectContainer.prototype = {
    initContents: function () {
        this.contents = [];
        this.mapping  = {};
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    doActionAfterCommon: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            default:
                for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[ i ].doActionAfter( event_name, param_1, param_2, param_3 );
                }
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    getSize            : function () {
        return this.contents.length;
    },
    getContents        : function () {
        return this.contents;
    },
    getContent         : function ( index ) {
        return this.contents[ index ];
    },
    getContentByUUID   : function ( uuid ) {
        var _index = this.mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.contents[ _index ];
    },
    getMappingIndex    : function ( uuid ) {
        return this.mapping[ uuid ];
    },
    getNextLoopingIndex: function ( current_index ) {
        if ( this.getSize() > current_index + 1 ) {
            return current_index + 1;
        }
        return 0;
    },
    getObjectsType     : function () {
        return "";
    },
    isEmpty            : function () {
        return this.getSize() === 0;
    },
    //********************************************  ACTIONS  **************************************************//
    doActionAfterContentChildren  : function ( event_name, param_1, param_2, param_3 ) {
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( !this.contents[i] ){
                console.warn("[ShinkenObjectContainer - doActionAfterContentChildren]", "[Missing element]", "OUT OF INDEX" );
                return;
            }
            this.contents[ i ].doActionAfter( event_name, param_1, param_2, param_3 );
        }
    },
    containsUUID                  : function ( uuid ) {
        return uuid in this.mapping;
    },
    sortContentByClassName        : function () {
        var to_return = this.contents.sort( ( a, b ) => (a.content.getObjectClassName() > b.content.getObjectClassName()) ? -1 : ((b.content.getObjectClassName() > a.content.getObjectClassName()) ? 1 : 0) );
        this.computeMapping();
        return to_return;
    },
    add                           : function ( to_add ) {
        return this.addCommon( to_add );
    },
    addCommon                     : function ( to_add ) {
        if ( this.mapping[ to_add.getUUID() ] !== undefined ) {
            this.contents[ this.mapping[ to_add.getUUID() ] ] = to_add;
        }
        else {
            this.mapping[ to_add.getUUID() ] = this.contents.push( to_add ) - 1;
        }
        return to_add;
    },
    insertAtIndex                 : function ( to_add, index ) {
        SHINKEN.TOOLS.ARRAY.insert( this.contents, to_add, index );
        this.computeMapping();
    },
    removeContent                 : function ( uuid_to_remove, params, avoid_revert_content ) {
        var _to_remove = this.getContentByUUID( uuid_to_remove );
        if ( !_to_remove ) {
            return;
        }
        if ( !avoid_revert_content ) {
            _to_remove.remove( params );
        }
        SHINKEN.TOOLS.ARRAY.removeElementByIndex( this.contents, this.mapping[ uuid_to_remove ] );
        this.computeMapping();
    },
    removeContentByIndex          : function ( index_to_remove, avoid_revert_content ) {
        if ( !avoid_revert_content ) {
            this.getContent( index_to_remove ).remove();
        }
        SHINKEN.TOOLS.ARRAY.removeElementByIndex( this.contents, index_to_remove );
        this.computeMapping();
    },
    removeAllContentFromIndex     : function ( index_to_remove ) {
        SHINKEN.TOOLS.ARRAY.removeAllElementsFromIndex( this.contents, index_to_remove );
        this.computeMapping();
    },
    removeFirstXContent           : function ( nb_to_remove ) {
        SHINKEN.TOOLS.ARRAY.removeXElementsFromIndex( this.contents, 0, nb_to_remove );
        this.computeMapping();
    },
    resetContents                 : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].remove();
        }
        this.initContents();
    },
    resetContentsCounters         : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].resetCounters ) {
                this.contents[ i ].resetCounters();
            }
        }
    },
    computeMapping                : function () {
        this.computeMappingCommon();
    },
    computeMappingCommon          : function () {
        this.mapping = {};
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.mapping[ this.contents[ i ].getUUID() ] = i;
        }
    },
    extractContentUuidIfHasCounter: function ( counter_type ) {
        let to_return = [];
        let current;
        for ( let i = this.getSize() - 1; i >= 0; i-- ) {
            current = this.getContent( i );
            if ( current.hasCounter( counter_type ) ) {
                to_return.push( current.getUUID() );
                this.removeContentByIndex( i, true );
            }
        }
        return to_return;
    },
    getContentUuidIfHasCounter    : function ( counter_type ) {
        let to_return = [];
        let current;
        for ( let i = this.getSize() - 1; i >= 0; i-- ) {
            current = this.getContent( i );
            if ( current.hasCounter( counter_type ) ) {
                to_return.push( current.getUUID() );
            }
        }
        return to_return;
    },
    //********************************************  SAVE   **************************************************//
    getDataToSave: function () {
        let to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            to_return.push( this.contents[ i ].getDataToSave() );
        }
        return to_return;
    },
    //********************************************  PARAMS FOR EVENTS   **************************************************//
    addParamForEvents           : function ( key, value ) {
        this.addParamForEventsCommonChild( key, value );
    },
    addParamForEventsCommonChild: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        this.addChildrenParamForEvents( key, value );
    },
    addChildrenParamForEvents   : function ( key, value ) {
        if ( !this.contents ) {
            return;
        }
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].addParamForEvents( key, value );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainer, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.ShinkenObjectContainerHtml           = function () {
};
SHINKEN.OBJECT.ShinkenObjectContainerHtml.prototype = {
    //********************************************  EVENT LISTENER   **************************************************//
    onClick     : function ( event ) {
        this.askHidePopup( this.getDomByEvent( event ) );
    },
    askHidePopup: function ( dom_element ) {
        if ( dom_element === this.getDomElement() ) {
            return false;
        }
        this.hidePopup();
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.contents[ _keys[ i ] ].askHidePopup( dom_element );
        }
        return true;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getContentByEvent: function ( event ) {
        if ( !event ) {
            return null;
        }
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, "name", 10 );
        if ( !_parent_dom_element ) {
            return null;
        }
        var _type = _parent_dom_element.dataset.objectType;
        if ( _type === this.getObjectsType() ) {
            return this.getContentByUUID( _parent_dom_element.dataset.name );
        }
    },
    getDomByEvent    : function ( event ) {
        if ( !event ) {
            return null;
        }
        return DOM.Service.findParentElementWithDataSet( event.target, "name", 10 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainerHtml, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainerHtml, SHINKEN.OBJECT.ShinkenObjectHtml );

SHINKEN.OBJECT.ConfirmationPopupInterface           = function () {
};
SHINKEN.OBJECT.ConfirmationPopupInterface.prototype = {
    computeConfirmationPopup                 : function ( name, event_name_validation_popup ) {
        const instance = SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance();
        instance.reset( name, event_name_validation_popup );
        this.updateComputeConfirmationPopupValidButton();
        instance.setTitle( this.buildHtmlTitleDeletePopup() );
        instance.setContent( this.buildHtmlDeleteConfirmationPopup() );
        instance.setController( this.getController() );
        instance.computeHtml();
        instance.show();
    },
    updateComputeConfirmationPopupValidButton: function () {
    },
    buildHtmlTitleDeletePopup                : function () {
        return _( "confirmation_popup.deletable_content.title", [DICTIONARY_COMMON_UI] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ConfirmationPopupInterface, SHINKEN.OBJECT.ShinkenObjectHtml );