//__lib__ lib_common
"use strict";

SHINKEN.ELEMENT.UiUserPrefs = function () {
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME ]           = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ]         = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME ]     = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ]           = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH ]     = 200;
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME ]        = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ]                 = {};
    this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ] = new SHINKEN.OBJECT.NotificationsOfChangeUser();
};

SHINKEN.ELEMENT.UiUserPrefs.prototype = {
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "change_value_notification_of_change_sound":
            case "change_value_notification_of_change_visual_blink":
                this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ].doActionAfter( event_name, param );
                break;
        }
    },
    //********************************************  OTHERS  *****************************************************//
    updateData             : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData                : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME:
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME:
                this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ].updateData( value );
                
                break;
            case SHINKEN.ELEMENT.USER.PARAM.PREFS.PANELS.NAME:
                break;
            default:
                this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ][ key ] = value;
                break;
        }
    },
    getDataToSave          : function () {
        var to_return                                                             = {};
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME ]           = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_LIST.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ]         = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_SCREEN.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME ]     = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DEFAULT_EVENTS_TUB.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ]           = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.HISTORIC_TAB.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME ]        = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.WEATHER_SERVICE.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ]                 = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.OTHERS.NAME ];
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ] = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ].getDataToSave();
        to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.PANELS.NAME ]                 = this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.PANELS.NAME ].getDataToSave();
        if ( EXTERNAL.COMMUNICATION.NEW_DETAIL_WIDTH ) {
            to_return[ SHINKEN.ELEMENT.USER.PARAM.PREFS.DETAIL_GRAPH_HOST_WIDTH ] = EXTERNAL.COMMUNICATION.NEW_DETAIL_WIDTH;
        }
        return to_return;
    },
    getNotificationOfChange: function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NOTIFICATION_OF_CHANGE.NAME ];
    }
};

SHINKEN.USER_PREFS = {
    PARAM_EVENT: {
        DATA: "user_prefs__data"
    },
    KEY        : "key",
    VALUE      : "value"
};

SHINKEN.UserPrefs_V3 = function ( data ) {
    this.init( data );
};

SHINKEN.UserPrefs_V3.prototype = {
    init: function ( data ) {
        this.initContents();
        if ( data ) {
            this.updateData( data );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getValueByKey: function ( array_keys ) {
        let current = this.getContentByUUID( array_keys[ 0 ] );
        if ( !current ) {
            return null;
        }
        return current.getValueByKey( array_keys.slice( 1 ) );
    },
    //********************************************  DATA  *****************************************************//
    updateData   : function ( data ) {
        var _keys = Object.keys( data );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.addPref( { [ SHINKEN.USER_PREFS.KEY ]: _current_key, [ SHINKEN.USER_PREFS.VALUE ]: data[ _current_key ] } );
        }
    },
    addPref      : function ( data ) {
        this.add( new SHINKEN.UserPref_V3( data ) );
    },
    getDataToSave: function () {
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UserPrefs_V3, SHINKEN.OBJECT.ShinkenObjectContainer );

SHINKEN.UserPref_V3           = function ( data ) {
    this.init( data );
};
SHINKEN.UserPref_V3.prototype = {
    init: function ( data ) {
        this[ SHINKEN.USER_PREFS.KEY ]   = data[ SHINKEN.USER_PREFS.KEY ];
        this[ SHINKEN.USER_PREFS.VALUE ] = SHINKEN.USER_PREFS.factory( data[ SHINKEN.USER_PREFS.VALUE ] );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID      : function () {
        return this[ SHINKEN.USER_PREFS.KEY ];
    },
    getValueByKey: function ( array_keys ) {
        if ( array_keys.length > 0 && typeof this[ SHINKEN.USER_PREFS.VALUE ] === "object" ) {
            return this[ SHINKEN.USER_PREFS.VALUE ].getValueByKey( array_keys );
        }
        return this[ SHINKEN.USER_PREFS.VALUE ];
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.UserPrefs_V3, SHINKEN.OBJECT.ShinkenObjectContainer );

SHINKEN.USER_PREFS.factory = function ( data ) {
    if ( typeof data === "object" ) {
        var _keys = Object.keys( data );
        if ( SHINKEN.TOOLS.ARRAY.areEqual( _keys, [SHINKEN.USER_PREFS.KEY, SHINKEN.USER_PREFS.VALUE] ) ) {
            return new SHINKEN.UserPref_V3( data );
        }
        return new SHINKEN.UserPrefs_V3( data );
    }
    return data;
};