//__lib__ lib_common_V02_01
"use strict";

PROPERTY.RadioListAbstract           = function () {
};
PROPERTY.RadioListAbstract.prototype = {
    init: function ( property_name ) {
        this.state = null;
        this.name  = property_name;
        this.addParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME, this.name );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___clickOnRadioBtn : function ( value ) {
        this.component_radio_list.clickOnRadioBtn( value );
        this.updateView();
    },
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                break;
            case "change_radio_mode_done":
                let is_default_key = this.getValue() === this.getDefaultKey();
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, this.property_name, is_default_key ? 0 : 1 );
                if ( is_default_key ) {
                    this.component_radio_list.doActionAfter( "clean_validation_error", param );
                }
                break;
            case "property_value__set__by_data":
                this.component_radio_list.doActionAfter( event_name, param );
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER, this.property_name, this.getValue() === this.getDefaultKey() ? 0 : 1 );
                break;
            case "onchange_in_input_V3":
            case "click_on_selector_V3":
            case "click_on_button_V3":
            case "click_on_item_selector_V3":
            case "onclick_in_input_V3":
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                this.component_radio_list.doActionAfter( event_name, param );
                break;
            case "add_message_validation":
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = this.getValue();
                this.component_radio_list.doActionAfter( event_name, param );
                break;
            case "change_radio_mode":
            case "property_value__set__by_js":
            case "value_changed":
            case "click_done":
            case "ask_hide_pop_up":
            case "change_selector_default_title":
            case "set_placeholder_input_V3":
                this.component_radio_list.doActionAfter( event_name, param );
                break;
            case "click_on_radio_button_V3":
                this.clickOnRadioBtn( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] );
                break;
        }
    },
    //********************************************  GETTER SETTER ***********************************************//
    ___unset                : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser        : function ( value ) {
        if ( !value ) {
            value = PROPERTY_V2.COMMON.VALUE.DEFAULT;
        }
        this.clickOnRadioBtn( value );
    },
    setDefaultKeyAndValue   : function ( default_key, default_value ) {
        this.component_radio_list.setDefaultKeyAndValue( default_key, default_value );
    },
    getDefaultValue         : function () {
        return this.component_radio_list.getDefaultValue();
    },
    getDefaultKey           : function () {
        return this.component_radio_list.getDefaultKey();
    },
    setButtonVisibilityState: function ( button_name, to_set ) {
        this.component_radio_list.setButtonVisibilityState( button_name, to_set );
    },
    setButtonTooltip        : function ( button_name, to_set, tooltip_type ) {
        this.component_radio_list.setButtonTooltip( button_name, to_set, tooltip_type );
    },
    getNbButtonVisible      : function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.component_radio_list.getSize(); i < _size_i; i++ ) {
            if ( this.component_radio_list.getContent( i ).isVisible() ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    addParamForEvents       : function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        if ( this.component_radio_list ) {
            this.component_radio_list.addParamForEvents( key, value );
        }
    },
    //********************************************  SAVE     *********************************************************//
    getValue          : function () {
        return this.component_radio_list.getValue();
    },
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListAbstract, PROPERTY.InterfaceCommon );

PROPERTY.RadioListFromHtml           = function ( dom_element ) {
    this.initSpecific( dom_element );
};
PROPERTY.RadioListFromHtml.prototype = {
    initSpecific: function ( dom_element ) {
        this.init();
        this.initWithDomElement( dom_element );
        this.component_radio_list = new COMPONENT.RadioListGeneric( dom_element, this );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromHtml, PROPERTY.RadioListAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromHtml, PROPERTY.InterfaceCommonFromHtml );

PROPERTY.RadioListFromData           = function ( property_name, data_buttons ) {
    this.initSpecific( property_name, data_buttons );
};
PROPERTY.RadioListFromData.prototype = {
    initSpecific: function ( property_name, data_buttons ) {
        this.name                 = property_name;
        this.component_radio_list = new COMPONENT.RadioListFromData( data_buttons, this.name );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.RADIO_LIST;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_radio_list.computeHtml();
        DOM.Service.addElementTo( this.component_radio_list.getDomElement(), this.dom_cell_action );
    },
    computeHtml_setEventName            : function ( to_set ) {
        return this.component_radio_list.computeHtml_setEventName( to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData, PROPERTY.RadioListAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData, PROPERTY.InterfaceCommonFromData );

PROPERTY.RadioListFromData_V3           = function ( property_name, data_buttons, label ) {
    this.initSpecific( property_name, data_buttons, label );
};
PROPERTY.RadioListFromData_V3.prototype = {
    initSpecific: function ( property_name, data_buttons, label ) {
        this.init( property_name );
        this.setLabel( label );
        this.component_radio_list = this.getChildConstructor( this.name );
        this.component_radio_list.addParamsForEvents( this.getParamForEvents() );
        this.component_radio_list.initListContent( data_buttons );
    },
    //********************************************  GETTER - SETTER    **********************************************************//
    getChildConstructor: function ( property_name ) {
        return new COMPONENT.RadioListFromData_V3( property_name );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.RADIO_LIST;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_radio_list.computeHtml();
        DOM.Service.addElementTo( this.component_radio_list.getDomElement(), this.dom_cell_action );
    },
    computeHtml_setEventName            : function ( to_set ) {
        return this.component_radio_list.computeHtml_setEventName( to_set );
    },
    //********************************************  SAVE    **********************************************************//
    getDataToSave__20241127: function ( type_save ) {
        let to_return = this.getDataToSaveFinal();
        switch ( type_save ) {
            case SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID:
                to_return = SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseValueToDict_withValueKey( to_return, to_return === this.getDefaultKey() ? this.getDefaultValue() : to_return );
                break;
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData_V3, PROPERTY.RadioListAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData_V3, PROPERTY.InterfaceCommonFromData_V3 );


PROPERTY.CheckBoxRadioPropFromData_V3           = function ( property_name, values, property_label ) {
    this.initSpecific( property_name, values, property_label );
};
PROPERTY.CheckBoxRadioPropFromData_V3.prototype = {
    initSpecific     : function ( property_name, data_buttons, label ) {
        this.init( property_name );
        this.setLabel( label );
        this.component_radio_list = this.getChildConstructor( this.name );
        this.component_radio_list.addParamsForEvents( this.getParamForEvents() );
        this.component_radio_list.initListContent( data_buttons );
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    //********************************************  GETTER - SETTER    **********************************************************//
    getChildConstructor: function ( property_name ) {
        return new SHINKEN.OBJECT.CheckBoxRadioModes( property_name );
    },
    //********************************************  SAVE    **********************************************************//
    getDataToSave__20241127: function ( type_save ) {
        let to_return = this.getDataToSaveFinal();
        switch ( type_save ) {
            case SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID:
                to_return = SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseValueToDict_withValueKey( to_return, to_return === this.getDefaultKey() ? this.getDefaultValue() : to_return );
                break;
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.CheckBoxRadioPropFromData_V3, PROPERTY.RadioListFromData_V3 );

PROPERTY.CheckBoxRadioProp__WithSelector__FromData           = function ( property_name, values, property_label ) {
    this.initSpecific( property_name, values, property_label );
};
PROPERTY.CheckBoxRadioProp__WithSelector__FromData.prototype = {
    initSpecific: PROPERTY.CheckBoxRadioPropFromData_V3.prototype.initSpecific,
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
        switch ( event_name ) {
            case "property_value__set__by_data":
                if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] === this.getDefaultKey() ) {
                    this.component_radio_list.doActionAfter( "set_default_value_in_selector", { [ PROPERTY.COMMON.PARAM.DEFAULT_VALUE ]: this.getDefaultValue() } );
                }
                break;
        }
    },
    //********************************************  GETTER - SETTER    **********************************************************//
    getChildConstructor: function ( property_name ) {
        return new SHINKEN.OBJECT.CheckBoxRadioModes__WithSelector( property_name );
    },
    ___hidePopup       : function ( exception ) {
        this.doActionAfter( "click_done", {} );
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                const values = param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getNextOrPrevious( event_name );
                this.component_radio_list.doActionAfterLastModification( event_name, values[ "radios_list" ] );
                this.doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: values[ [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] ] } );
                this.previous_modication_data = this.getDataForLastModification();
                break;
        }
    },
    getDataForLastModification   : function () {
        return {
            [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]      : this.getDataToSave(),
            "radios_list": this.component_radio_list.getDataForLastModification()
        };
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.CheckBoxRadioProp__WithSelector__FromData, PROPERTY.CheckBoxRadioPropFromData_V3 );

PROPERTY.CheckBoxRadioProp__WithStringInput__FromData           = function ( property_name, values, property_label ) {
    this.initSpecific( property_name, values, property_label );
};
PROPERTY.CheckBoxRadioProp__WithStringInput__FromData.prototype = {
    initSpecific: PROPERTY.CheckBoxRadioPropFromData_V3.prototype.initSpecific,
    //********************************************  GETTER - SETTER    **********************************************************//
    getChildConstructor: function ( property_name ) {
        return new SHINKEN.OBJECT.CheckBoxRadioModes__WithStringInput( property_name );
    },
    doActionAfterChange: function ( param ) {
        this.component_radio_list.doActionAfter( "update_radio_mode_using_input_value", param );
        CONTROLLER.Form.doActionAfter( "onchange_in_input_V3_done", { [ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ]: this, [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: this.getName() } );
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: PROPERTY.CheckBoxRadioProp__WithSelector__FromData.prototype.doActionAfterLastModification,
    getDataForLastModification   : PROPERTY.CheckBoxRadioProp__WithSelector__FromData.prototype.getDataForLastModification
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.CheckBoxRadioProp__WithStringInput__FromData, PROPERTY.CheckBoxRadioPropFromData_V3 );