//__lib__ lib_common_V02_01
"use strict";

PROPERTY.SingleSelectAbstract           = function () {
};
PROPERTY.SingleSelectAbstract.prototype = {
    init: function ( property_name, label ) {
        this.name  = property_name;
        this.label = label;
        this.addParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME, this.name );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector    : function ( selector_name ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector( selector_name ).clickOnSelector();
    },
    clickOnItemSelector: function ( selector_name, item_name ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector( selector_name ).clickOnItemSelector( item_name, this );
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_item_selector_done":
                DOM.Service.setDataSet( this.getDomElement(), "currentValue", param_1.getValue() );
                break;
        }
    },
    addParamForEvents  : function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        if ( this.component_selector ) {
            this.component_selector.addParamForEvents( key, value );
        }
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeState: function () {
        this._computeLabelSelect();
    },
    //********************************************  GET / SET    **********************************************************//
    setComponentSelector      : function ( to_set ) {
        this.component_selector = to_set;
        this.component_selector.addParamsForEvents( this.getParamForEvents() );
    },
    setValueFromUser          : function ( value ) {
        this.clickOnItemSelector( null, value );
    },
    getValue                  : function ( value ) {
        return this.getSelector().getValue();
    },
    setStatus                 : function ( _to_set ) {
        this.status = _to_set;
        this.component_selector.setStatus( _to_set );
    },
    setDefaultLabelForSelector: function ( selector_name, to_set ) {
        this.getSelector( selector_name ).setDefaultLabelForSelector( to_set );
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSave: function () {
        return this.getSelector().getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectAbstract, PROPERTY.InterfaceSelectAbstract );

PROPERTY.SingleSelectFromData           = function ( property_name, data_option_array, label ) {
    this.initSpecific( property_name, data_option_array, label );
};
PROPERTY.SingleSelectFromData.prototype = {
    initSpecific    : function ( property_name, data_option_array, label, extra_columns ) {
        this.init( property_name, label );
        this.initMainSelector( data_option_array, extra_columns );
    },
    initMainSelector: function ( data_option_array ) {
        this.setComponentSelector( new COMPONENT.SingleSelectFromDataV2( this.getName() ) );
        this.component_selector.setOptionsFromArray( data_option_array );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_item_selector_done":
                DOM.Service.setDataSet( this.getDomElement(), "currentValue", param_1.getValue() );
                return;
        }
        if ( param_1[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] !== this.getName() ) {
            return;
        }
        param_1[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
        this.component_selector.doActionAfter( event_name, param_1, param_2, param_3 );
    },
    //********************************************  OTHER    **********************************************************//
    changeOptionsFromArray: function ( data_option_array ) {
        this.component_selector.changeOptionsFromArray( data_option_array );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.SINGLE_SELECT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_selector.computeHtml();
        DOM.Service.addElementTo( this.component_selector.getDomElement(), this.dom_cell_action );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData, PROPERTY.SingleSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData, PROPERTY.InterfaceSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData, PROPERTY.InterfaceCommonFromData );


PROPERTY.SingleSelectFromData_V3           = function ( property_name, data_option_array, label ) {
    this.initSpecific( property_name, data_option_array, label );
};
PROPERTY.SingleSelectFromData_V3.prototype = {
    initSpecific    : function ( property_name, data_option_array, label, extra_columns ) {
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        this.init( property_name, label );
        this.initMainSelector( data_option_array, extra_columns );
    },
    initMainSelector: function ( data_option_array ) {
        this.setComponentSelector( new COMPONENT.SingleSelectFromData_V3( this.getName() ) );
        this.component_selector.setOptionsFromArray( data_option_array );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter      : function ( event_name, param, param_2, param_3 ) {
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    doActionAfterCommon: function ( event_name, param, param_2, param_3 ) {
        param = param || {};
        switch ( event_name ) {
            case "click_on_item_selector_done":
                DOM.Service.setDataSet( this.getDomElement(), "currentValue", param.getValue() );
                return;
            case "click_done":
                this.component_selector.doActionAfter( event_name, param );
                return;
            case "property_visibility__set":
                this.setVisibilityState( param[ PROPERTY.COMMON.PARAM.PROPERTY_VISIBILITY ] );
                return;
        }
        param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
        this.component_selector.doActionAfter( event_name, param, param_2, param_3 );
    },
    //********************************************  OTHER    **********************************************************//
    changeOptionsFromArray: function ( data_option_array ) {
        this.component_selector.changeOptionsFromArray( data_option_array );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
        this.setPhaseDomElement( this.getDomElement() );
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.SINGLE_SELECT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_selector.computeHtml();
        DOM.Service.addElementTo( this.component_selector.getDomElement(), this.dom_cell_action );
    },
    getDataToSave__20241127             : function ( type_save ) {
        let to_return = this.getDataToSave();
        switch ( type_save ) {
            case SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID:
                to_return = SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseValueToDict_withValueKey( to_return, to_return );
                break;
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData_V3, PROPERTY.SingleSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData_V3, PROPERTY.InterfaceSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData_V3, PROPERTY.InterfaceCommonFromData_V3 );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData_V3, SHINKEN.OBJECT.PhaseInterface );

PROPERTY.SingleSelectWithResearchFromData_V3           = function ( property_name, data_option_array, label, extra_columns ) {
    this.initSpecific( property_name, data_option_array, label, extra_columns );
};
PROPERTY.SingleSelectWithResearchFromData_V3.prototype = {
    initSpecific    : PROPERTY.SingleSelectFromData_V3.prototype.initSpecific,
    initMainSelector: function ( data_option_array, extra_columns ) {
        this.setComponentSelector( new COMPONENT.SingleSelectWithResearchFromData_V3( this.getName(), null, extra_columns ) );
        this.component_selector.setOptionsFromArray( data_option_array );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfterChange: function ( validation_done ) {
        this.component_selector.doActionAfter( "ask_apply_filter" );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml_getClassContainer: function () {
        return "shinken-element-property-line-V3 shinken-layout-column-start-h ";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectWithResearchFromData_V3, PROPERTY.SingleSelectFromData_V3 );
