//priority 10
//__lib__ lib_common
SHINKEN.TOOLS.ARRAY = (function ( self ) {
    "use strict";
    
    self.cleanEmpty                      = function ( array ) {
        const toReturn = [];
        for ( let i = 0, _size_i = array.length; i < _size_i; i++ ) {
            if ( array[ i ] === null || array[ i ] === undefined ) {
                continue;
            }
            toReturn.push( array[ i ] );
        }
        return toReturn;
    };
    self.concat                          = function ( array_1, array_2 ) {
        return array_1.concat( array_2 );
    };
    self.concatUnique                    = function ( array_1, array_2, key_for_unique ) {
        const toReturn = [];
        let _size      = array_1.length;
        for ( let i = 0; i < _size; i++ ) {
            toReturn[ i ] = array_1[ i ];
        }
        _size = array_2.length;
        for ( let i = 0; i < _size; i++ ) {
            if ( !key_for_unique ) {
                self.addElement( toReturn, array_2[ i ] );
            }
            else if ( !self.containsElementWith( toReturn, array_2[ i ][ key_for_unique ], key_for_unique ) ) {
                toReturn.push( array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.concatUniqueIfNotPresentIn      = function ( array_1, array_2, array_3 ) {
        const toReturn = [];
        let _size      = array_1.length;
        for ( let i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_1[ i ] ) ) {
                toReturn[ i ] = array_1[ i ];
            }
        }
        _size = array_2.length;
        for ( let i = 0; i < _size; i++ ) {
            if ( !self.contains( array_3, array_2[ i ] ) ) {
                self.addElement( toReturn, array_2[ i ] );
            }
        }
        return toReturn;
    };
    self.insert                          = function ( array, element_to_insert, index ) {
        index = index || 0;
        array.splice( index, 0, element_to_insert );
    };
    self.sortNumber                      = function ( array ) {
        if ( !array ) {
            return array;
        }
        return array.sort( function ( a, b ) {
            return a - b;
        } );
    };
    self.sortArray                       = function ( array, comparator_value, first_index_to_sort, reverse ) {
        if ( reverse === undefined ) {
            reverse = false;
        }
        
        if ( !array ) {
            return array;
        }
        if ( !comparator_value ) {
            return array.sort();
        }
        const size    = array.length;
        let fix_array = [];
        let to_sort   = array;
        if ( first_index_to_sort ) {
            fix_array = array.slice( 0, first_index_to_sort );
            to_sort   = array.slice( first_index_to_sort, size );
        }
        to_sort.sort( function ( a, b ) {
            if ( a[ comparator_value ] < b[ comparator_value ] ) {
                return reverse ? 1 : -1;
            }
            else if ( a[ comparator_value ] > b[ comparator_value ] ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
        return fix_array.concat( to_sort );
    };
    self.sortArrayByUsingInteger         = function ( array, reverse ) {
        return array.sort( function ( a, b ) {
            if ( SHINKEN.TOOLS.NUMBER.parseStringToPositiveInteger( a ) < SHINKEN.TOOLS.NUMBER.parseStringToPositiveInteger( b ) ) {
                return reverse ? 1 : -1;
            }
            else if ( SHINKEN.TOOLS.NUMBER.parseStringToPositiveInteger( a ) > SHINKEN.TOOLS.NUMBER.parseStringToPositiveInteger( b ) ) {
                return reverse ? -1 : 1;
            }
            return 0;
        } );
    };
    self.sortArrayMultiple               = function ( array, comparator_values ) {
        if ( !array || !comparator_values ) {
            return array;
        }
        const to_sort = array;
        to_sort.sort(
            function ( a, b ) {
                return self._comparator( a, b, comparator_values, 0 );
            }
        );
        return to_sort;
    };
    self.getMapValues                    = function ( map ) {
        if ( !map ) {
            return null;
        }
        return Object.keys( map ).map( function ( e ) {
            return map[ e ];
        } );
    };
    self._comparator                     = function ( a, b, comparators, index ) {
        if ( index >= comparators.length ) {
            return 0;
        }
        if ( a[ comparators[ index ] ] < b[ comparators[ index ] ] ) {
            return -1;
        }
        else if ( a[ comparators[ index ] ] > b[ comparators[ index ] ] ) {
            return 1;
        }
        return self._comparator( a, b, comparators, (index + 1) );
    };
    self.filterWith                      = function ( array, key, value ) {
        if ( !array ) {
            return [];
        }
        if ( !key || !value ) {
            return null;
        }
        const size = array.length;
        if ( !size ) {
            return [];
        }
        const toReturn = [];
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.filterWithDeeply                = function ( array, keys, value ) {
        if ( !array || !keys || !value ) {
            return null;
        }
        const size = array.length;
        if ( !size ) {
            return null;
        }
        const _to_return = [];
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( self.findValueDeeply( _current, keys ) === value ) {
                _to_return.push( _current );
            }
        }
        return _to_return;
    };
    self.findValueDeeply                 = function ( dict, keys ) {
        if ( !dict || !keys ) {
            return null;
        }
        const _size = keys.length;
        if ( _size < 1 ) {
            return null;
        }
        const _to_return = dict[ keys[ 0 ] ];
        if ( _size === 1 ) {
            return _to_return;
        }
        return self.findValueDeeply( _to_return, SHINKEN.TOOLS.ARRAY.clone( keys ).splice( -1, 1 ) );
    };
    self.findFirstElementWith            = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        const size = array.length;
        if ( !size ) {
            return null;
        }
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return _current;
            }
        }
        return null;
    };
    self.findFirstIndexWith              = function ( array, key, value ) {
        if ( !array || !key || typeof value === 'undefined' ) {
            return null;
        }
        const size = array.length;
        if ( !size ) {
            return null;
        }
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( _current[ key ] === value ) {
                return i;
            }
        }
        return -1;
    };
    self.getLengthWith                   = function ( array, key, value ) {
        const _filtered = self.filterWith( array, key, value );
        if ( !_filtered ) {
            return 0;
        }
        return _filtered.length;
    };
    self.extractKey                      = function ( array, key, ignoreEmpty ) {
        if ( !array || !key ) {
            return null;
        }
        const toReturn = [];
        const size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current && !ignoreEmpty ) {
                toReturn[ i ] = null;
            }
            else {
                if ( _current[ key ] || !ignoreEmpty ) {
                    toReturn[ i ] = _current[ key ];
                }
            }
        }
        return toReturn;
    };
    self.extractKeys                     = function ( array, keys ) {
        const _keys_size = keys.length;
        if ( !array || !_keys_size ) {
            return null;
        }
        const toReturn = [];
        const size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( !_current ) {
                toReturn[ i ] = self.initEmptyArray( _keys_size );
            }
            else {
                toReturn[ i ] = [];
                for ( let j = 0; j < _keys_size; j++ ) {
                    toReturn[ i ].push( _current[ keys[ j ] ] );
                }
            }
        }
        return toReturn;
    };
    self.removeDuplicate                 = function ( array ) {
        if ( !array ) {
            return null;
        }
        const toReturn = [];
        const size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            if ( toReturn.indexOf( _current ) !== -1 ) {
                continue;
            }
            toReturn.push( _current );
        }
        return toReturn;
    };
    self.removeDuplicateArray            = function ( array ) {
        if ( !array ) {
            return null;
        }
        const toReturn = [];
        const size     = array.length;
        if ( !size ) {
            return toReturn;
        }
        let _current;
        let _to_add;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ];
            _to_add  = true;
            for ( let j = 0, _size_j = toReturn.length; j < _size_j; j++ ) {
                if ( self.areEqual( toReturn[ j ], _current ) ) {
                    _to_add = false;
                }
            }
            if ( _to_add ) {
                toReturn.push( _current );
            }
        }
        return toReturn;
    };
    self.hasSameKeyContent               = function ( array1, array2, key ) {
        if ( !key ) {
            return false;
        }
        if ( !array1 && !array2 ) {
            return true;
        }
        if ( !array1 || !array2 ) {
            return false;
        }
        
        const _extract1 = self.extractKey( array1, key );
        const _extract2 = self.extractKey( array2, key );
        if ( _extract1 === null && _extract2 === null ) {
            return true;
        }
        else if ( _extract1 === null || _extract2 === null ) {
            return false;
        }
        
        const _size1 = _extract1.length;
        const _size2 = _extract2.length;
        
        if ( _size1 !== _size2 ) {
            return false;
        }
        
        for ( let i = 0; i < _extract1; i++ ) {
            if ( _extract1[ i ] !== _extract2[ i ] ) {
                return false;
            }
        }
        return true;
    };
    self.getElementFromTo                = function ( array, indexBegin, indexEnd ) {
        return array.slice( indexBegin, indexEnd );
    };
    self.getElement                      = function ( array, key, value_to_find ) {
        const _size = self.getLength( array );
        let _current_element;
        for ( let i = 0; i < _size; i++ ) {
            _current_element = array[ i ];
            if ( _current_element[ key ] === value_to_find ) {
                return _current_element;
            }
        }
    };
    self.reverseArrayClone               = function ( array ) {
        const toReturn = Array.prototype.slice.call( array );
        toReturn.reverse();
        return toReturn;
    };
    self.initEmptyArray                  = function ( length ) {
        const toReturn = [];
        for ( let i = 0; i <= length; i++ ) {
            toReturn.push( null );
        }
        return toReturn;
    };
    self.initConstantArray               = function ( to_add, length ) {
        const toReturn = [];
        for ( let i = 0; i < length; i++ ) {
            toReturn.push( to_add );
        }
        return toReturn;
    };
    self.initIntegerArray                = function ( indexBegin, indexEnd ) {
        const toReturn = [];
        for ( let i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i );
        }
        return toReturn;
    };
    self.initIntegerArrayToString        = function ( indexBegin, indexEnd ) {
        const toReturn = [];
        for ( let i = indexBegin; i <= indexEnd; i++ ) {
            toReturn.push( i + "" );
        }
        return toReturn;
    };
    self.initArrayWithKey                = function ( array, key ) {
        const toReturn = [];
        for ( let i = 0, _size_i = array.length; i < _size_i; i++ ) {
            toReturn.push( array[ i ][ key ] );
        }
        return toReturn;
    };
    self.indexOf                         = function ( array, key, value ) {
        const size = array.length;
        let _current;
        for ( let i = 0; i < size; i++ ) {
            _current = array[ i ][ key ];
            if ( _current && _current === value ) {
                return i;
            }
        }
        return -1;
    };
    self.indexOfCollection               = function ( array, to_find ) {
        const size = array.length;
        for ( let i = 0; i < size; i++ ) {
            if ( array[ i ] === to_find ) {
                return i;
            }
        }
        return -1;
    };
    self.search                          = function ( array, key, value ) {
        const index = self.indexOf( array, key, value );
        if ( index === -1 ) {
            return null;
        }
        return array[ index ];
    };
    self.join                            = function ( array, separator ) {
        if ( Array.isArray( array ) ) {
            return array.join( separator );
        }
        return array.toString();
    };
    self.getLength                       = function ( array ) {
        if ( array ) {
            return array.length;
        }
        return 0;
    };
    self.clone                           = function ( array ) {
        return array.slice( 0 );
    };
    self.swap                            = function ( array, index_1, index_2 ) {
        if ( !array ) {
            return;
        }
        const b          = array[ index_1 ];
        array[ index_1 ] = array[ index_2 ];
        array[ index_2 ] = b;
        return array;
    };
    self.contains                        = function ( array, toSearch ) {
        if ( !array ) {
            return false;
        }
        return array.indexOf( toSearch ) !== -1;
    };
    self.containsAtLeastOne              = function ( array1, array2 ) {
        if ( !array1 || !array2 ) {
            return false;
        }
        for ( let i = 0, _size_i = array2.length; i < _size_i; i++ ) {
            if ( self.contains( array1, array2[ i ] ) ) {
                return true;
            }
        }
        return false;
    };
    self.addElement                      = function ( array, toAdd ) {
        if ( self.contains( array, toAdd ) ) {
            return -1;
        }
        return array.push( toAdd );
    };
    self.removeElement                   = function ( array, toRemove ) {
        const index = array.indexOf( toRemove );
        if ( index === -1 ) {
            return false;
        }
        self.removeElementByIndex( array, index );
        return true;
    };
    self.removeElementByIndex            = function ( array, index ) {
        array.splice( index, 1 );
    };
    self.removeAllElementsFromIndex      = function ( array, index ) {
        array.splice( index );
    };
    self.removeXElementsFromIndex        = function ( array, index, nb ) {
        array.splice( index, nb );
    };
    self.parseToArray                    = function ( obj, extra_value ) {
        if ( !obj ) {
            return null;
        }
        
        const _keys      = Object.keys( obj );
        const _size      = _keys.length;
        const _to_return = [];
        for ( let i = 0; i < _size; i++ ) {
            _to_return[ i ] = obj[ _keys[ i ] ];
        }
        if ( extra_value ) {
            _to_return.push( extra_value );
        }
        return _to_return;
    };
    self.parseForClipboard               = function ( array ) {
        let _to_return = "";
        for ( let i = 0, _size_i = array.length; i < _size_i; i++ ) {
            for ( let j = 0, _size_j = array[ i ].length; j < _size_j; j++ ) {
                _to_return += array[ i ][ j ] + '\t';
            }
            _to_return += "\r";
        }
        return _to_return;
    };
    self.getNumberOfLineWithConstraint   = function ( array, column_size_array ) {
        let to_return = 1;
        for ( let i = 0, _size_i = column_size_array.length; i < _size_i; i++ ) {
            if ( column_size_array[ i ] ) {
                to_return = Math.max( to_return, Math.ceil( array[ i ].length / column_size_array[ i ] ) );
            }
        }
        return to_return;
    };
    self.parseArrayToTextWithConstraint  = function ( array, column_size_array ) {
        let _to_return = "";
        let nb_lines   = self.getNumberOfLineWithConstraint( array, column_size_array );
        let nb_column  = column_size_array.length;
        for ( let i = 0; i < nb_lines; i++ ) {
            for ( let j = 0; j < nb_column; j++ ) {
                if ( column_size_array[ j ] ) {
                    _to_return += array[ j ].substring( i * column_size_array[ j ], column_size_array[ j ] * (i + 1) ).padEnd( column_size_array[ j ] ) + '\t';
                }
                else if ( i === 0 ) {
                    _to_return += array[ j ] + '\t';
                }
                else {
                    _to_return += "".padEnd( array[ j ].length ) + '\t';
                }
            }
            _to_return += "\r";
        }
        return _to_return;
    };
    self.parseForClipboardText           = function ( array, column_size_array ) {
        let _to_return = "";
        for ( let i = 0, _size_i = array.length; i < _size_i; i++ ) {
            _to_return += self.parseArrayToTextWithConstraint( array[ i ], column_size_array );
        }
        return _to_return;
    };
    self.containsElementWith             = function ( array, toSearch, key ) {
        if ( !array ) {
            return false;
        }
        if ( !key ) {
            return false;
        }
        
        const _size = array.length;
        for ( let i = 0; i < _size; i++ ) {
            if ( array[ i ][ key ] === toSearch ) {
                return true;
            }
        }
        return false;
    };
    self.areEqual                       = function ( array1, array2 ) {
        return JSON.stringify( array1 ) === JSON.stringify( array2 );
    };
    self.getMedianIndex                  = function ( array, round_up ) {
        if ( !array ) {
            return SHINKEN.TOOLS.ARRAY.NOT_FOUND;
        }
        return round_up ? Math.ceil( array.length / 2 ) : Math.floor( array.length / 2 );
    };
    self.getFirstPartOf                  = function ( array ) {
        return array.slice( 0, self.getMedianIndex( array ) + 1 );
    };
    self.getLastPartOf                   = function ( array ) {
        return array.slice( self.getMedianIndex( array ), array.length );
    };
    self.minNumber                       = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.min( a, b );
        }, array[ 0 ] );
    };
    self.maxNumber                       = function ( array ) {
        if ( !array ) {
            return null;
        }
        return array.reduce( function ( a, b ) {
            return Math.max( a, b );
        }, array[ 0 ] );
    };
    self.medianNumber                    = function ( array ) {
        if ( !array ) {
            return null;
        }
        const sorted = array.slice().sort();
        const half   = Math.floor( array.length / 2 );
        
        if ( array.length % 2 ) {
            return sorted[ half ];
        }
        
        return (sorted[ half - 1 ] + sorted[ half ]) / 2.0;
    };
    self.take                            = function ( arr, n ) {
        return arr.filter( function ( _, i ) {
            return i < n;
        } );
    };
    self.takeLast                        = function ( arr, n ) {
        const _len = arr.length;
        return arr.filter( function ( _, i ) {
            return _len - i <= n;
        } );
    };
    self.searchIndexByDichotomy          = function ( comp_by_index, i_up, i_down ) {
        /*
        * return the index of the bigger element that is smaller or equal to the search element.
        *
        * [i_down, i_up] are search interval
        * comp_by_index, comparing function:
        *       return value > 0 if the value at index i is bigger than the search value
        *       return value < 0 if the value at index i is smaller than the search value
        *       return 0 if the value at index i is equal than the search value
        *  */
        if ( !i_down ) {
            i_down = 0;
        }
        let _i_up   = i_up;
        let _i_down = i_down;
        let _i_cur;
        while ( _i_up > _i_down ) {
            _i_cur = Math.floor( (_i_up + _i_down + 1) / 2 );
            if ( comp_by_index( _i_cur ) > 0 ) {
                if ( _i_up === _i_cur ) {
                    break;
                }
                _i_up = _i_cur;
            }
            else {
                if ( _i_down === _i_cur ) {
                    break;
                }
                _i_down = _i_cur;
            }
        }
        return _i_down;
    };
    self.removeElementFromArrayWithValue = function ( arr, value ) {
        let index = arr.indexOf( value );
        if ( index !== -1 ) {
            arr.splice( index, 1 );
        }
    };
    self.getMissingElements              = function ( array_full, array_with_missing ) {
        let to_return = [];
        for ( let i = 0, _size = array_full.length; i < _size; i++ ) {
            if ( !array_with_missing.includes( array_full[ i ] ) ) {
                to_return.push( array_full[ i ] );
            }
        }
        return to_return;
    };
    //self.compareArrays                   = function ( array1, array2, reorder ) {
    //    if ( reorder ) {
    //        array1.sort();
    //        array2.sort();
    //    }
    //    return array1.length === array2.length && array1.every( ( value, index ) => value === array2[ index ] );
    //};
    //self.diff                            = function ( arr1, arr2 ) {
    //    return arr1.filter( x => !arr2.includes( x ) );
    //};
    //self.differencesBetweenTwoArray      = function ( array1, array2 ) {
    //    array1.sort();
    //    array2.sort();
    //    const diff  = self.diff( array1, array2 );
    //    const diff2 = self.diff( array2, array1 );
    //    return [diff, diff2];
    //};
    //
    return self;
})
( SHINKEN.TOOLS.ARRAY || {} );

SHINKEN.TOOLS.ARRAY.NOT_FOUND = -1;