//priority 10
//__lib__ lib_common
"use strict";
DOM.Service        = (function ( self ) {
    //********************************************  findElement   **************************************************//
    self.findParentElementWithDataSet              = function ( element, key, deepLimit ) {
        if ( !element || deepLimit < 0 ) {
            return null;
        }
        if ( self.hasKeyInDataSet( element, key ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass                = function ( element, class_tag, deepLimit, data_set_name, data_set_value ) {
        if ( !element || deepLimit < 0 ) {
            return null;
        }
        if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) && (element.tagName === "path" || element.tagName === "svg") ) {
            deepLimit--;
            return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit, data_set_name, data_set_value );
        }
        if ( element.classList.contains( class_tag ) ) {
            if ( !data_set_name ) {
                return element;
            }
            else {
                if ( element.dataset[ data_set_name ] === data_set_value ) {
                    return element;
                }
            }
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit, data_set_name, data_set_value );
    };
    self.findParentElementWithTagName              = function ( element, tagName, deepLimit ) {
        if ( !element || deepLimit < 0 ) {
            return null;
        }
        if ( element.tagName === tagName ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithTagName( element.parentElement, tagName, deepLimit );
    };
    self.findParentElementWithID                   = function ( element, id, deepLimit ) {
        if ( !element || deepLimit < 0 ) {
            return null;
        }
        if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) && (element.tagName === "path" || element.tagName === "svg") ) {
            deepLimit--;
            return this.findParentElementWithID( element.parentElement, id, deepLimit );
        }
        if ( element.id === id ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithID( element.parentElement, id, deepLimit );
    };
    self.findParentElementByClassWithClassExcluded = function ( element, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !element ) {
            return null;
        }
        if ( element.classList.contains( class_exclude ) ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementByClassWithClassExcluded( element.parentElement, class_tag, class_exclude, deepLimit );
    };
    self.askFindChildElementWithClass              = function ( element, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !element || !class_tag ) {
            return null;
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( class_tag, "." ) ) {
            class_tag = class_tag.substring( 1 );
        }
        if ( SHINKEN.TOOLS.STRING.startsWith( class_exclude, "." ) ) {
            class_exclude = class_exclude.substring( 1 );
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        return this.findChildElementWithClass( element.children, class_tag, class_exclude, deepLimit );
    };
    self.findChildElementWithClass                 = function ( elements, class_tag, class_exclude, deepLimit ) {
        if ( deepLimit < 0 || !elements.length ) {
            return null;
        }
        let children = [];
        for ( let i = 0, _size = elements.length; i < _size; i++ ) {
            try {
                if ( elements[ i ].classList.contains( class_tag ) ) {
                    return elements[ i ];
                }
                if ( !elements[ i ].classList.contains( class_exclude ) || !elements[ i ].childElementCount ) {
                    children = SHINKEN.TOOLS.ARRAY.concat( children, SHINKEN.TOOLS.ARRAY.parseToArray( elements[ i ].children ) );
                }
            }
            catch ( e ) {
            
            }
        }
        deepLimit--;
        return this.findChildElementWithClass( children, class_tag, class_exclude, deepLimit );
        
    };
    self.querySelectorAll                          = function ( dom_element, css_selector ) {
        return dom_element.querySelectorAll( css_selector );
    };
    self.findChildWithCssSelector                  = function ( dom_element, css_selector ) {
        return dom_element.querySelector( css_selector );
    };
    self.querySelectorAllWithOutChild              = function ( dom_element, class_tag, class_exclude ) {
        let _to_return = [];
        let _current;
        if ( dom_element ) {
            for ( let i = 0, _size_i = dom_element.children.length; i < _size_i; i++ ) {
                _current = dom_element.children[ i ];
                if ( _current.classList.contains( class_exclude ) ) {
                    continue;
                }
                if ( _current.classList.contains( class_tag ) ) {
                    _to_return.push( _current );
                    continue;
                }
                _to_return = SHINKEN.TOOLS.ARRAY.concat( _to_return, self.querySelectorAllWithOutChild( _current, class_tag, class_exclude ) );
            }
        }
        return _to_return;
    };
    self.isExisting                                = function ( dom_element ) {
        const elements = document.querySelectorAll( self.getSelector( dom_element ) );
        for ( let i = 0, _size_i = elements.length; i < _size_i; i++ ) {
            if ( elements[ i ] === dom_element ) {
                return true;
            }
        }
        return false;
    };
    self.isInDom                                   = function ( dom_element ) {
        return dom_element.getRootNode
               ? dom_element.getRootNode( { composed: true } ) === document
               : document.body.contains( dom_element );
    };
    self.getSelector                               = function ( dom_element ) {
        let _class_selector = SHINKEN.TOOLS.ARRAY.join( dom_element.classList, "." );
        if ( _class_selector ) {
            _class_selector = "." + _class_selector;
        }
        return dom_element.tagName + _class_selector;
    };
    //********************************************  TO_SET   **************************************************//
    self.setPageTitle                              = function ( to_set ) {
        document.title = to_set;
    };
    //********************************************  TO_SORT   **************************************************//
    self.hasKeyInDataSet                           = function ( element, key ) {
        return typeof element.dataset[ key ] !== "undefined";
    };
    self.hasKeyInDataSetAndKeyNotEmpty             = function ( element, key ) {
        return self.hasKeyInDataSet( element, key ) && element.dataset[ key ];
    };
    self.createTable                               = function ( cells_dom ) {
        const toReturn = document.createElement( "table", { class: "shinken-table" } );
        let _current_row;
        let _current_cell;
        for ( let i = 0, _size_i = cells_dom.length; i < _size_i; i++ ) {
            _current_row = document.createElement( "tr" );
            for ( let j = 0, _size_j = cells_dom[ i ].length; j < _size_j; j++ ) {
                _current_cell = document.createElement( "td" );
                _current_cell.appendChild( cells_dom[ i ][ j ] );
                _current_row.appendChild( _current_cell );
            }
            toReturn.appendChild( _current_row );
        }
        return toReturn;
    };
    self.createElement                             = function ( tag, attributes, innerHTML ) {
        const toReturn = document.createElement( tag );
        if ( attributes ) {
            const keys = Object.keys( attributes );
            const size = keys.length;
            for ( let i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML !== undefined && innerHTML !== null ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.createTextNode                            = function ( text ) {
        return document.createTextNode( text );
    };
    self.cloneElement                              = function ( dom_element_to_clone, attributes ) {
        const _to_return = dom_element_to_clone.cloneNode( true );
        if ( attributes ) {
            const keys = Object.keys( attributes );
            const size = keys.length;
            for ( let i = 0; i < size; i++ ) {
                _to_return.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        return _to_return;
    };
    self.addTooltip                                = function ( element, attributes, on_mouse_enter ) {
        if ( !attributes ) {
            return;
        }
        element.setAttribute( "onmouseenter", on_mouse_enter || "SHINKEN_TOOLTIP.showTooltip(this)" );
        element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        const _keys = Object.keys( attributes );
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            element.setAttribute( _keys[ i ], attributes[ _keys[ i ] ] );
        }
        return element;
    };
    self.removeTooltip                             = function ( element ) {
        element.setAttribute( "onmouseenter", "" );
        element.setAttribute( "onmouseleave", "" );
    };
    self.removeElement                             = function ( element ) {
        if ( !element ) {
            return;
        }
        const parent = element.parentNode;
        
        try {
            const _to_return = parent.removeChild( element );
            return _to_return;
        }
        catch ( e ) {
            return false;
        }
    };
    self.removeParentIfHasClassOrElement           = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        const parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            const _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.getInnerText                              = function ( element ) {
        if ( !element ) {
            return;
        }
        return element.innerText.trim();
    };
    self.toggleClass                               = function ( element, to_toggle ) {
        if ( element.classList.contains( to_toggle ) ) {
            element.classList.remove( to_toggle );
            return false;
        }
        else {
            element.classList.add( to_toggle );
            return true;
        }
    };
    self.removeElementIfHasClass                   = function ( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        const parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementWithIndex                       = function ( element, parent, index ) {
        if ( !index ) {
            index = 0;
        }
        if ( index >= parent.children.length ) {
            parent.appendChild( element );
        }
        else {
            parent.insertBefore( element, parent.children[ index ] );
        }
    };
    self.addElementAtIndex                         = function ( element, parent, index ) {
        if ( !parent || !element ) {
            return;
        }
        if ( !index ) {
            index = 0;
        }
        if ( parent.childElementCount <= index ) {
            return self.addElementTo( element, parent );
        }
        else {
            self.insertElementBefore( parent.children[ index ], element );
        }
        return element;
    };
    self.addAllChildrenTo                          = function ( element_with_children, parent ) {
        if ( parent && element_with_children ) {
            const _children = element_with_children.children;
            for ( let i = 0, _size_i = _children.length; i < _size_i; i++ ) {
                self.addElementTo( _children[ i ], parent );
            }
            parent.appendChild( element_with_children );
        }
        
    };
    self.addElementTo                              = function ( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
            return element;
        }
        return null;
    };
    self.addElementToAfterEmpty                    = function ( element, parent ) {
        self.empty( parent );
        self.addElementTo( element, parent );
    };
    self.addElementAfterTo                         = function ( element, target ) {
        const _next = target.nextSibling;
        if ( _next ) {
            target.parentNode.insertBefore( element, _next );
        }
        else {
            self.addElementTo( element, target.parentNode );
        }
    };
    self.addElementBeforeToAfterEmpty              = function ( element, target ) {
        self.empty( target );
        target.parentNode.insertBefore( element, target );
        
    };
    self.switchElementParent                       = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        const parent_1 = element_1.parentNode;
        const parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.switchElement                             = function ( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        const parent_1 = element_1.parentNode;
        const parent_2 = element_2.parentNode;
        
        const _index_1 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_1.children, element_1 );
        const _index_2 = SHINKEN.TOOLS.ARRAY.indexOfCollection( parent_2.children, element_2 );
        self.insertElementBefore( element_2, element_1 );
        self.addElementAtIndex( element_1, parent_2, _index_2 );
    };
    self.insertElementBefore                       = function ( element_existing, element_to_insert ) {
        if ( !element_existing || !element_to_insert ) {
            return;
        }
        const _parent = element_existing.parentNode;
        _parent.insertBefore( element_to_insert, element_existing );
    };
    self.addLoadingFrame                           = function ( dom_parent, text, parent_scrollable ) {
        if ( !dom_parent ) {
            return;
        }
        if ( DOM.Service.getComputedStyle( dom_parent, DOM.CONST.STYLE.POSITION ) === "absolute" ) {
            console.error( "NOT SUPPORTED addLoadingFrame" );
            return;
        }
        self.setStyle( dom_parent, DOM.CONST.STYLE.POSITION, "relative" );
        const _to_add = self.createElement( "div", { class: "shinken-loading-frame" }, "" );
        if ( text ) {
            var _dom_text = self.createElement( "div", { class: "shinken-loading-frame-text" }, text );
            self.addElementTo( _dom_text, _to_add );
            
            var _interval = setInterval( function () {
                if ( self.isExisting( _to_add ) ) {
                    if ( !parent_scrollable ) {
                        var _new_top = (self.getBoundingClientRect( _to_add )[ "height" ] - self.getBoundingClientRect( _dom_text )[ "height" ]) / 2;
                        self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, _new_top );
                    }
                    else {
                        var _scrolling_needed = self.getMissingScrollPositionToBeVisible( _dom_text, parent_scrollable );
                        if ( _scrolling_needed ) {
                            self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, Math.max( 0, self.getComputedStyle( _dom_text, DOM.CONST.STYLE.TOP ) + _scrolling_needed ) );
                        }
                    }
                }
                else {
                    clearInterval( _interval );
                }
            }, 200 );
        }
        self.addElementTo( _to_add, dom_parent );
    };
    self.addLoadingFrameV2                         = function ( dom_parent, text, parent_scrollable ) {
        if ( !dom_parent ) {
            return;
        }
        if ( DOM.Service.getComputedStyle( dom_parent, DOM.CONST.STYLE.POSITION ) === "absolute" ) {
            console.error( "NOT SUPPORTED addLoadingFrame" );
            return;
        }
        self.setStyle( dom_parent, DOM.CONST.STYLE.POSITION, "relative" );
        var _to_add = self.createElement( "div", { class: "shinken-loading-frame" }, SHINKEN.TOOLS.LOADING_FRAME.getHtml( "id-shinken-loading-ui-panel" ) );
        
        if ( text ) {
            var _dom_text = self.createElement( "div", { class: "shinken-loading-frame-text" }, text );
            self.addElementTo( _dom_text, _to_add );
            
            var _interval = setInterval( function () {
                if ( self.isExisting( _to_add ) ) {
                    if ( !parent_scrollable ) {
                        var _new_top = (self.getBoundingClientRect( _to_add )[ "height" ] - self.getBoundingClientRect( _dom_text )[ "height" ]) / 2;
                        self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, _new_top );
                    }
                    else {
                        var _scrolling_needed = self.getMissingScrollPositionToBeVisible( _dom_text, parent_scrollable );
                        if ( _scrolling_needed ) {
                            self.setStyle( _dom_text, DOM.CONST.STYLE.TOP, Math.max( 0, self.getComputedStyle( _dom_text, DOM.CONST.STYLE.TOP ) + _scrolling_needed ) );
                        }
                    }
                }
                else {
                    clearInterval( _interval );
                }
            }, 200 );
        }
        self.addElementTo( _to_add, dom_parent );
    };
    self.addServerDown                             = function ( dom_parent, text, parent_scrollable ) {
        if ( !dom_parent ) {
            return;
        }
        if ( DOM.Service.getComputedStyle( dom_parent, DOM.CONST.STYLE.POSITION ) === "absolute" ) {
            console.error( "NOT SUPPORTED addServerDown" );
            return;
        }
        self.setStyle( dom_parent, DOM.CONST.STYLE.POSITION, "relative" );
        
        self.addElementTo( self.createElement( "div", {}, SHINKEN.TOOLS.BACKEND_NO_RESPONSE_FRAME.getHtml( "id-shinken-loading-ui-panel" ) ), dom_parent );
    };
    //********************************************  POSITION ABSOLUTE AND FIXED *******************************//
    self.getPositionToPercentFull                  = function ( dom_element, forbid_negative_value ) {
        var _rect = self.getBoundingClientRect( dom_element );
        DOM.Service.removeStyles( dom_element, [DOM.CONST.STYLE.HEIGHT, DOM.CONST.STYLE.WIDTH] );
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.TOP ]    = self.getPercentCompareToWindowHeight( _rect[ DOM.CONST.STYLE.TOP ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.BOTTOM ] = self.getPercentCompareToWindowHeight( window.innerHeight - _rect[ DOM.CONST.STYLE.TOP ] - _rect[ DOM.CONST.STYLE.HEIGHT ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.LEFT ]   = self.getPercentCompareToWindowWidth( _rect[ DOM.CONST.STYLE.LEFT ], forbid_negative_value );
        _to_return[ DOM.CONST.STYLE.RIGHT ]  = self.getPercentCompareToWindowWidth( window.innerWidth - _rect[ DOM.CONST.STYLE.LEFT ] - _rect[ DOM.CONST.STYLE.WIDTH ], forbid_negative_value );
        return _to_return;
    };
    self.parsePositionToPercent                    = function ( dom_element, forbid_negative_value ) {
        var _rect                         = self.getBoundingClientRect( dom_element );
        var _styles                       = {};
        _styles[ DOM.CONST.STYLE.TOP ]    = "auto";
        _styles[ DOM.CONST.STYLE.BOTTOM ] = "auto";
        _styles[ DOM.CONST.STYLE.LEFT ]   = "auto";
        _styles[ DOM.CONST.STYLE.RIGHT ]  = "auto";
        
        _rect.left < window.innerWidth / 2 ?
        _styles[ DOM.CONST.STYLE.LEFT ] = self.getPercentCompareToWindowWidth( _rect[ DOM.CONST.STYLE.LEFT ], forbid_negative_value ) :
        _styles[ DOM.CONST.STYLE.RIGHT ] = self.getPercentCompareToWindowWidth( window.innerWidth - _rect[ DOM.CONST.STYLE.LEFT ] - _rect[ DOM.CONST.STYLE.WIDTH ], forbid_negative_value );
        
        _rect.top < window.innerHeight / 2 ?
        _styles[ DOM.CONST.STYLE.TOP ] = self.getPercentCompareToWindowHeight( _rect[ DOM.CONST.STYLE.TOP ], forbid_negative_value ) :
        _styles[ DOM.CONST.STYLE.BOTTOM ] = self.getPercentCompareToWindowHeight( window.innerHeight - _rect[ DOM.CONST.STYLE.TOP ] - _rect[ DOM.CONST.STYLE.HEIGHT ], forbid_negative_value );
        
        DOM.Service.setStyles( dom_element, _styles );
    };
    self.getPercentCompareToWindowHeight           = function ( value, forbid_negative_value ) {
        var _to_return = (value * 100) / window.innerHeight;
        if ( forbid_negative_value && _to_return < 0 ) {
            _to_return = 0;
        }
        return _to_return + "%";
    };
    self.getPercentCompareToWindowWidth            = function ( value, forbid_negative_value ) {
        var _to_return = (value * 100) / window.innerWidth;
        if ( forbid_negative_value && _to_return < 0 ) {
            _to_return = 0;
        }
        return _to_return + "%";
    };
    self.parsePositionForDragStart                 = function ( dom_element, ignore_size ) {
        var _rect = DOM.Service.getBoundingClientRect( dom_element );
        DOM.Service.removeStyles( dom_element, [DOM.CONST.STYLE.BOTTOM, DOM.CONST.STYLE.RIGHT] );
        var _new_styles                     = {};
        _new_styles[ DOM.CONST.STYLE.TOP ]  = _rect[ DOM.CONST.STYLE.TOP ];
        _new_styles[ DOM.CONST.STYLE.LEFT ] = _rect[ DOM.CONST.STYLE.LEFT ];
        if ( !ignore_size ) {
            _new_styles[ DOM.CONST.STYLE.WIDTH ]  = _rect[ DOM.CONST.STYLE.WIDTH ];
            _new_styles[ DOM.CONST.STYLE.HEIGHT ] = _rect[ DOM.CONST.STYLE.HEIGHT ];
        }
        DOM.Service.setStyles( dom_element, _new_styles );
    };
    self.getPositionsForSaveInPercent              = function ( dom_element, keys ) {
        var _to_return = {};
        var _current_key;
        for ( var i = 0, _size = keys.length; i < _size; i++ ) {
            _current_key                = keys[ i ];
            _to_return [ _current_key ] = self.getPositionForSaveInPercent( dom_element, _current_key );
        }
        return _to_return;
    };
    self.getPositionForSaveInPercent               = function ( dom_element, key ) {
        var _value = self.getBoundingClientRect( dom_element, key );
        switch ( key ) {
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.BOTTOM:
            case DOM.CONST.STYLE.HEIGHT:
                return self.getPercentCompareToWindowHeight( _value );
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.RIGHT:
            case DOM.CONST.STYLE.WIDTH:
                return self.getPercentCompareToWindowWidth( _value );
        }
    };
    
    //********************************************  DATASET   **************************************************//
    self.setDataSet                          = function ( element, data_name, value ) {
        if ( !element ) {
            return;
        }
        element.dataset[ data_name ] = value;
    };
    self.querySelectorAllWithData            = function ( css_selector, data_name, dom_element ) {
        dom_element    = dom_element || document;
        var _all_doms  = dom_element.querySelectorAll( css_selector );
        var _to_return = [];
        for ( var i = 0, _size_i = _all_doms.length; i < _size_i; i++ ) {
            if ( _all_doms[ i ].dataset[ data_name ] ) {
                _to_return.push( _all_doms[ i ] );
            }
        }
        return _to_return;
    };
    self.addControllerAnchor                 = function ( dom_element, controller_name ) {
        dom_element.classList.add( "shinken-parent-event-listener" );
        dom_element.dataset.controller = controller_name;
    };
    //********************************************  CLASSES   **************************************************//
    self.updateWithComputedWidthClass        = function ( dom_element ) {
        var _class_to_add = self.computedWidthClass( self.getBoundingClientRect( dom_element, DOM.CONST.STYLE.WIDTH ) );
        var _classes      = dom_element.classList;
        for ( var i = 0, _size_i = _classes.length; i < _size_i; i++ ) {
            if ( SHINKEN.TOOLS.STRING.startsWith( _classes[ i ], "shinken-width-for-responsive-" ) ) {
                dom_element.classList.remove( _classes[ i ] );
            }
        }
        dom_element.classList.add( _class_to_add );
    };
    self.computedWidthClass                  = function ( width ) {
        var _width_compute = Math.floor( width / 50 );
        return "shinken-width-for-responsive-" + _width_compute * 50;
    };
    self.askAddClass                         = function ( element, to_add, time_out ) {
        if ( !element ) {
            return;
        }
        element.classList.add( to_add );
        if ( time_out ) {
            setTimeout( function () {
                element.classList.remove( to_add );
            }, time_out );
        }
    };
    self.addClasses                          = function ( dom_element, class_to_add ) {
        if ( !dom_element ) {
            return;
        }
        if ( typeof class_to_add === "string" ) {
            class_to_add = class_to_add.split( " " );
        }
        for ( var i = 0, _size_i = class_to_add.length; i < _size_i; i++ ) {
            dom_element.classList.add( class_to_add[ i ] );
        }
    };
    self.removeClasses                       = function ( dom_element, class_to_remove ) {
        if ( !dom_element ) {
            return;
        }
        if ( typeof class_to_remove === "string" ) {
            class_to_remove = class_to_remove.split( " " );
        }
        for ( var i = 0, _size_i = class_to_remove.length; i < _size_i; i++ ) {
            dom_element.classList.remove( class_to_remove[ i ] );
        }
    };
    self.addOrRemoveClasses                  = function ( dom_element, boolean, _class ) {
        boolean ? self.addClasses( dom_element, _class ) : self.removeClasses( dom_element, _class );
    };
    self.applySiblingSettings                = function ( dom_element, dom_element_ref ) {
        dom_element.className = dom_element_ref.className;
    };
    //********************************************  STYLE   **************************************************//
    self.getComputedStyle                    = function ( dom_element, key, skip_parsing ) {
        if ( !dom_element ) {
            return {};
        }
        var _to_return = dom_element.currentStyle || getComputedStyle( dom_element );
        if ( key ) {
            _to_return = _to_return[ key ];
            if (!skip_parsing && SHINKEN.TOOLS.STRING.endsWith( _to_return, "px" ) ) {
                _to_return = parseInt( _to_return );
            }
        }
        return _to_return;
    };
    self.getComputedStyles                   = function ( dom_element, keys ) {
        if ( !keys || !dom_element ) {
            return self.getComputedStyle( dom_element );
        }
        var _computed  = self.getComputedStyle( dom_element );
        var _to_return = {};
        var _to_add;
        for ( var i = 0, _size_i = keys.length; i < _size_i; i++ ) {
            _to_add = _computed[ keys[ i ] ];
            if ( SHINKEN.TOOLS.STRING.endsWith( _to_add, "px" ) ) {
                _to_add = parseInt( _to_add );
            }
            _to_return[ keys[ i ] ] = _to_add;
        }
        return _to_return;
    };
    self.cleanAllStyles                      = function ( dom_element ) {
        dom_element.removeAttribute( "style" );
    };
    self.attributeStyleToDict                = function ( dom_element ) {
        var attribute_style = dom_element.getAttribute( "style" );
        var _to_return      = {};
        var split_1         = attribute_style.split( ";" );
        for ( var i = 0, _size_i = split_1.length; i < _size_i; i++ ) {
            if ( !split_1[ i ] ) {
                continue;
            }
            var split_2                = split_1[ i ].split( ":" );
            _to_return[ split_2[ 0 ] ] = split_2[ 1 ];
        }
        return _to_return;
    };
    self.cleanAllStyles                      = function ( dom_element ) {
        dom_element.removeAttribute( "style" );
    };
    self.setStyle                            = function ( dom_element, key, value ) {
        if ( !dom_element || !key ) {
            return;
        }
        if ( value !== "" ) {
            dom_element.style[ key ] = self._parseStyle( key, value );
        }
        else {
            self.removeStyle( dom_element, key );
        }
    };
    self._parseStyle                         = function ( key, value ) {
        switch ( key ) {
            case DOM.CONST.STYLE.LEFT:
            case DOM.CONST.STYLE.TOP:
            case DOM.CONST.STYLE.HEIGHT:
            case DOM.CONST.STYLE.WIDTH:
            case DOM.CONST.STYLE.LINE_HEIGHT:
            case DOM.CONST.STYLE.MAX_HEIGHT:
            case DOM.CONST.STYLE.MAX_WIDTH:
            case DOM.CONST.STYLE.BORDER_RADIUS:
                if ( !isNaN( value ) ) {
                    value = value + "px";
                }
                break;
            default:
                break;
        }
        return value;
    };
    self.setStyles                           = function ( dom_element, styles ) {
        var keys = Object.keys( styles );
        for ( var i = 0, size = keys.length; i < size; i++ ) {
            self.setStyle( dom_element, keys[ i ], styles[ keys[ i ] ] );
        }
    };
    self.removeStyles                        = function ( dom_element, styles ) {
        for ( var i = 0, size = styles.length; i < size; i++ ) {
            self.removeStyle( dom_element, styles[ i ] );
        }
    };
    self.removeStyle                         = function ( dom_element, style ) {
        if ( !dom_element ) {
            return;
        }
        dom_element.style.removeProperty( style );
    };
    self.styleToHtml                         = function ( styles ) {
        var _keys      = Object.keys( styles );
        var _current_key;
        var _to_return = "";
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _to_return += _current_key + ":" + self._parseStyle( _current_key, styles[ _current_key ] ) + ";";
        }
        return _to_return;
    };
    self.setStyleInHard                      = function ( dom_element, style ) {
        self.removeStyle( dom_element, style );
        var _hard_value = self.getBoundingClientRect( dom_element, style );
        self.setStyle( dom_element, style, _hard_value );
    };
    self.ChangeUserSelect                    = function ( dom_element, add_or_remove ) {
        if ( !add_or_remove ) {
            DOM.Service.setStyles( dom_element, { userSelect: "none" } );
            for ( let _dom_element of dom_element.querySelectorAll( ".shinken-user-select-text" ) ) {
                _dom_element.style.cssText += "user-select: none !important;";
            }
        }
        else {
            DOM.Service.setStyles( dom_element, { userSelect: "" } );
            for ( let _dom_element of dom_element.querySelectorAll( ".shinken-user-select-text" ) ) {
                DOM.Service.setStyles( _dom_element, { userSelect: "" } );
            }
        }
    };
    //********************************************  OTHERS   **************************************************//
    self.getBoundingClientRect               = function ( dom_element, key ) {
        if ( !dom_element ) {
            return;
        }
        var _rect = dom_element.getBoundingClientRect();
        if ( !key ) {
            return _rect;
        }
        if ( key === DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM ) {
            return parseInt( (_rect[ DOM.CONST.STYLE.TOP ] + _rect[ DOM.CONST.STYLE.BOTTOM ]) / 2 );
        }
        return parseInt( _rect[ key ] );
    };
    self.hasScrollHeight                     = function ( dom_element ) {
        return dom_element.clientHeight < dom_element.scrollHeight;
    };
    self.hasScrollWidth                      = function ( dom_element ) {
        return dom_element.clientWidth < dom_element.scrollWidth;
    };
    self.setHtmlOrHide                       = function ( dom_element, to_set ) {
        if ( !dom_element ) {
            return;
        }
        if ( to_set ) {
            dom_element.innerHTML = to_set;
            dom_element.classList.remove( "shinken-hidden" );
        }
        else {
            dom_element.classList.add( "shinken-hidden" );
        }
    };
    self.replaceElement                      = function ( element_to_replace, element_replace_with ) {
        var _parent_node = element_to_replace.parentNode;
        _parent_node.replaceChild( element_replace_with, element_to_replace );
    };
    self.empty                               = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        while ( dom_element.firstChild ) {
            dom_element.removeChild( dom_element.firstChild );
        }
    };
    self.addAttribute                        = function ( dom_element, attribute_name, to_set ) {
        dom_element.setAttribute( attribute_name, to_set );
    };
    self.removeAttribute                     = function ( dom_element, attribute_name ) {
        dom_element.removeAttribute( attribute_name );
    };
    self.getHeight                           = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight;
    };
    self.getHeightWithMargin                 = function ( dom_element ) {
        if ( !dom_element ) {
            return 0;
        }
        return dom_element.offsetHeight + self.getComputedStyle( dom_element, "marginTop" ) + self.getComputedStyle( dom_element, "marginBottom" );
    };
    self.isVisible                           = function ( elem, deepness ) {
        if ( !elem ) {
            return false;
        }
        if ( !deepness ) {
            deepness = 0;
        }
        try {
            var styles = self.getComputedStyle( elem );
        }
        catch ( ex ) {
            throw Error( "DOM.Service: elem is not an element." );
        }
        
        if ( styles.display === "none" ) {
            return false;
        }
        if ( styles.visibility !== "visible" && styles.visibility !== "inherit" ) {
            return false;
        }
        if ( styles.opacity < 0.1 ) {
            return false;
        }
        if ( elem.parentElement && deepness > 0 ) {
            return self.isVisible( elem.parentElement, --deepness );
        }
        return true;
    };
    self.getMissingScrollPositionToBeVisible = function ( dom_element, dom_parent ) {
        var _parent_rect  = self.getBoundingClientRect( dom_parent );
        var _element_rect = self.getBoundingClientRect( dom_element );
        if ( _element_rect[ DOM.CONST.STYLE.TOP ] < _parent_rect[ DOM.CONST.STYLE.TOP ] ) {
            return _parent_rect[ DOM.CONST.STYLE.TOP ] - _element_rect[ DOM.CONST.STYLE.TOP ];
        }
        if ( _element_rect[ DOM.CONST.STYLE.BOTTOM ] > _parent_rect[ DOM.CONST.STYLE.BOTTOM ] ) {
            return _parent_rect[ DOM.CONST.STYLE.BOTTOM ] - _element_rect[ DOM.CONST.STYLE.BOTTOM ];
        }
        return 0;
    };
    
    self.setInputValue                                     = function ( dom_element, to_set ) {
        if ( SHINKEN.NAVIGATOR.isNavigator( "isIE" ) ) {
            // Cette BGL permet de rendre les modifications de la valeur visibles dans le navigateur
            dom_element.setAttribute( "value", to_set );
            //dom_element = self.replaceChild( dom_element, dom_element );
            dom_element.value = to_set;
            return;
        }
        dom_element.value = to_set;
    };
    self.setCheckBoxValue                                  = function ( dom_element, to_set ) {
        dom_element.checked = !!to_set;
    };
    self.hasFocus                                          = function ( dom_element ) {
        return dom_element === document.activeElement;
    };
    self.generateDomElementFromString                      = function ( string ) {
        var _to_return = self.createElement( "div", "", string );
        return _to_return.children;
    };
    self.isMatchingMedianDomElementTopWith                 = function ( list, y ) {
        var _median_index = SHINKEN.TOOLS.ARRAY.getMedianIndex( list, true );
        if ( _median_index === SHINKEN.TOOLS.ARRAY.NOT_FOUND ) {
            return DOM.CONST.VALUE.NONE;
        }
        var _median  = list[ _median_index ];
        var _compare = self.compareCoordinates( _median, null, y );
        if ( _compare === 0 ) {
            return _median;
        }
        return _compare;
    };
    self.compareCoordinates                                = function ( dom_element, x, y ) {
        var _rect = self.getBoundingClientRect( dom_element );
        if ( x ) {
            if ( _rect.left < x ) {
                return -1;
            }
            if ( _rect.left + _rect.width > x ) {
                return 1;
            }
        }
        if ( y ) {
            if ( _rect.top > y ) {
                return -1;
            }
            if ( _rect.top + _rect.height < y ) {
                return 1;
            }
        }
        return 0;
    };
    self.show                                              = function ( dom_element ) {
        dom_element.classList.remove( "shinken-hidden" );
    };
    self.hide                                              = function ( dom_element ) {
        dom_element.classList.add( "shinken-hidden" );
    };
    self.setEditable                                       = function ( edit_content, dom_container, dom_to_edit ) {
        dom_to_edit.contentEditable = edit_content;
        if ( edit_content === true ) {
            self.focusAtTheEnd( dom_to_edit );
        }
        self.setDataSet( dom_container, "statusEdit", edit_content ? "1" : "0" );
    };
    self.focusAtTheEnd                                     = function ( dom_element ) {
        dom_element.focus();
        var range = document.createRange();
        range.selectNodeContents( dom_element );
        range.collapse( false );
        var sel = window.getSelection();
        sel.removeAllRanges();
        sel.addRange( range );
    };
    self.scrollbarIsVisible                                = function ( dom_element, axe ) {
        switch ( axe ) {
            case "height":
                return dom_element.scrollHeight > dom_element.clientHeight;
            case "width":
                return dom_element.scrollWidth > dom_element.clientWidth;
        }
    };
    self.scrollIntoElementIfNotVisible                     = function ( dom_element ) {
        dom_element.scrollIntoView( { block: "nearest" } );
    };
    self.scrollIntoElementStart                            = function ( dom_element ) {
        dom_element.scrollIntoView( { block: "start" } );
    };
    //********************************************  ZOOM   **************************************************//
    self.getNavigatorZoom                                  = function () {
        return Math.round( window.devicePixelRatio * 100 );
    };
    self.getFontZoomed                                     = function ( font_size, zoom_percent ) {
        if ( !zoom_percent || zoom_percent === 100 ) {
            return font_size;
        }
        return parseInt( font_size * zoom_percent / 100 );
    };
    //********************************************  EDITION   **************************************************//
    self.isActiveElementEditable                           = function () {
        return Boolean( document.activeElement.isContentEditable );
    };
    //********************************************  CURSOR  ************************************************//
    self.saveCursorPosition                                = function ( dom_element ) {
        return dom_element.selectionStart;
    };
    self.focusAndSetCursorPosition                         = function ( dom_element, cursor_position ) {
        if ( !cursor_position ) {
            return;
        }
        dom_element.selectionStart = cursor_position;
        dom_element.selectionEnd   = cursor_position;
        dom_element.blur();
        dom_element.focus();
    };
    self.isMouseOnScrollBar                                = function ( event, dom_element, zoom ) {
        let value_X = event.clientX;
        let value_y = event.clientY;
        if ( zoom ) {
            const scale = zoom / 100;
            value_X     = event.clientX * scale;
            value_y     = event.clientY * scale;
        }
        return value_X >= dom_element.clientWidth || value_y >= dom_element.clientHeight;
    };
    self.changeCursorIcon                                  = function ( dom_element, url_icon ) {
        if ( url_icon ) {
            dom_element.style.cursor = `url("${url_icon}") 16 16, auto`;
        }
        else {
            this.getDomElement().style.cursor = "default";
        }
    };
    //********************************************  SIMULATE ACTION  ************************************************//
    self.SimulateAction                                    = {
        _doDispatch: function ( event_name, dom_element ) {
            if ( !dom_element ) {
                return;
            }
            var evt = document.createEvent( "HTMLEvents" );
            evt.initEvent( event_name, false, true );
            dom_element.dispatchEvent( evt );
        },
        mouseDown  : function ( dom_element ) {
            self.SimulateAction._doDispatch( "mousedown", dom_element );
        },
        mouseUp    : function ( dom_element ) {
            self.SimulateAction._doDispatch( "mouseup", dom_element );
        },
        keyUp      : function ( dom_element ) {
            self.SimulateAction._doDispatch( "keyup", dom_element );
        },
        click      : function ( dom_element ) {
            self.SimulateAction._doDispatch( "click", dom_element );
        }
    };
    self.computeHasScrollVertical                          = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        self.addOrRemoveClasses( dom_element, self.hasScrollHeight( dom_element ), "shinken-scroll-vertical-active" );
    };
    self.computeHasScrollVerticals                         = function ( selector, dom_element ) {
        if ( !selector ) {
            return;
        }
        if ( !dom_element ) {
            dom_element = document;
        }
        var _dom_s = dom_element.querySelectorAll( selector );
        for ( var i = 0, _size_i = _dom_s.length; i < _size_i; i++ ) {
            self.computeHasScrollVertical( _dom_s[ i ] );
        }
    };
    self.focusOnAnchor                                     = function ( selector_css, parent_dom, animation, extra_size_for_top ) {
        return selector_css.focusOnAnchor_withDom( document.querySelector( selector_css ), parent_dom, new DOM.Service.Animation( animation, 2000 ), extra_size_for_top );
    };
    self.focusOnAnchor_withDom                             = function ( dom_element, parent_dom, animation_object, extra_size_for_top ) {
        if ( !dom_element ) {
            return;
        }
        if ( parent_dom ) {
            parent_dom.classList.add( "shinken-scroll-behavior-smooth" );
            extra_size_for_top   = extra_size_for_top || 5; //-5 USED TO NOT BE STUCK ON THE TOP
            parent_dom.scrollTop = dom_element.offsetTop - extra_size_for_top;
        }
        else {
            dom_element.scrollIntoView();
            //METHOD SMOOTH IS NOT WORKING on ALL NAVIGATOR
        }
        if ( animation_object ) {
            switch ( animation_object.type ) {
                case 'shinken-pulsate':
                    DOM.Service.askAddClass( dom_element, 'shinken-pulsate', animation_object.timer );
            }
        }
    };
    self.focus                                             = function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        dom_element.focus();
    };
    self.isElementOnScreen                                 = function ( dom_element ) {
        const rect         = dom_element.getBoundingClientRect();
        const windowHeight = (window.innerHeight || document.documentElement.clientHeight);
        const windowWidth  = (window.innerWidth || document.documentElement.clientWidth);
        const verticallyVisible   = (rect.top <= windowHeight) && ((rect.top + rect.height) >= 0);
        const horizontallyVisible = (rect.left <= windowWidth) && ((rect.left + rect.width) >= 0);
        return verticallyVisible && horizontallyVisible;
    };
    self.isPartiallyVisibleIntoScrollingVerticalParent_Box = function ( box_dom, box_parent ) {
        return box_dom.bottom >= box_parent.top && box_dom.top <= box_parent.bottom;
    };
    self.isInScreenVertically                              = function ( dom_element ) {
        const _element_rect = self.getBoundingClientRect( dom_element );
        const body_rect     = self.getBoundingClientRect( DOM.BodyService.getDomElement() );
        return _element_rect[ DOM.CONST.STYLE.BOTTOM ] >= body_rect[ DOM.CONST.STYLE.BOTTOM ];
    };
    self.addResizeCursorsTo                                = function ( dom_container, positions_list ) {
        if ( !positions_list ) {
            positions_list = ["top-left", "top-right", "bottom-left", "bottom-right"];
        }
        for ( let i = 0; i < positions_list.length; i++ ) {
            let current_position   = positions_list[ i ];
            let css_classes        = `shinken-${current_position} shinken-2024-${current_position}-triangle shinken-resize-cursor`;
            let dom_cursor_element = DOM.Service.createElement( "span", { class: css_classes, "data-position": current_position } );
            DOM.Service.addElementTo( dom_cursor_element, dom_container );
        }
    };
    self.reloadIframe                                      = function ( css_selector ) {
        document.querySelector( css_selector ).src += "";
    };
    return self;
})( DOM.Service || {} );
DOM.Service.Toggle = (function ( self ) {
    self.CONST     = {
        PARAM_EVENT: {
            TOGGL_SERVICE__IS_OPEN: "toggl_service__is_open"
        }
    };
    self.toggle    = function ( dom_element, level ) {
        var dom_parent;
        if ( level ) {
            dom_parent = DOM.Service.findParentElementWithClass( dom_element, "shinken-toggle-container-lvl", 50, "lvl", level );
        }
        else {
            dom_parent = DOM.Service.findParentElementWithClass( dom_element, "shinken-toggle-container", 50 );
        }
        DOM.Service.toggleClass( dom_parent, "shinken-close" );
    };
    self.toggle_V3 = function ( dom_element ) {
        DOM.Service.toggleClass( dom_element, "shinken-close" );
        return dom_element.classList.contains( "shinken-close" );
    };
    self.close     = function ( dom_element ) {
        dom_element.classList.add( "shinken-close" );
    };
    self.isOpen    = function ( dom_element ) {
        return !dom_element.classList.contains( "shinken-close" );
    };
    return self;
})( DOM.Service.Toggle || {} );

DOM.CONST = {
    STYLE                   : {
        LEFT            : "left",
        RIGHT           : "right",
        TOP             : "top",
        BOTTOM          : "bottom",
        HEIGHT          : "height",
        MAX_HEIGHT      : "max-height",
        MAX_WIDTH       : "max-width",
        LINE_HEIGHT     : "line-height",
        WIDTH           : "width",
        Z_INDEX         : "z-index",
        DISPLAY         : "display",
        POSITION        : "position",
        BACKGROUND_COLOR: "background-color",
        PADDING         : "padding",
        MARGIN          : "margin",
        BORDER_RADIUS   : "border-radius",
        FONT_SIZE       : "font-size"
    },
    ATTRIBUTE               : {
        SCROLL_DOWN: "scrollDown",
        SCROLL_TOP : "scrollTop",
        SCROLL_LEFT: "scrollLeft"
    },
    VALUE                   : {
        NONE: "none"
    },
    SPECIAL                 : {
        MEDIAN_TOP_BOTTOM: "MEDIAN_TOP_BOTTOM"
    },
    WAITING_TIME_BEFORE_EXEC: {
        INPUT: 200
    }
};

DOM.Service.Animation = function ( type, timer ) {
    this.type  = type;
    this.timer = timer;
};

