//priority 10
//__lib__ lib_common
"use strict";
SHINKEN.TOOLS.LOADING_FRAME = (function ( self ) {
    self.getDomElement = function ( id ) {
        if ( id ) {
            return DOM.Service.createElement( "div", {
                class: "shinken-loading-frame", id: id
            }, '<div class="shinken-loading-frame-container"><h1><div class="shinken-pulsate">' + _( 'loading_frame.load_in_progress', [DICTIONARY_COMMON_UI] ) + '</div></h1></div>' );
        }
        return DOM.Service.createElement( "div", {
            class: "shinken-loading-frame"
        }, '<div class="shinken-loading-frame-container"><h1><div class="shinken-pulsate">' + _( 'loading_frame.load_in_progress', [DICTIONARY_COMMON_UI] ) + '</div></h1></div>' );
    };
    self.getDomElement_V3 = function ( id ) {
        if ( id ) {
            return DOM.Service.createElement( "div", {
                class: "shinken-loading-frame shinken-layout-center-h-v", id: id
            }, '<div class="shinken-loading-frame-container"><h1><div class="shinken-pulsate">' + _( 'loading_frame.load_in_progress', [DICTIONARY_COMMON_UI] ) + '</div></h1></div>' );
        }
        return DOM.Service.createElement( "div", {
            class: "shinken-loading-frame shinken-layout-center-h-v"
        }, '<div class="shinken-loading-frame-container"><h1><div class="shinken-pulsate">' + _( 'loading_frame.load_in_progress', [DICTIONARY_COMMON_UI] ) + '</div></h1></div>' );
    };
    self.getHtml       = function ( id ) {
        return self.getDomElement( id ).outerHTML;
    };
    return self;
})( SHINKEN.TOOLS.LOADING_FRAME || {} );
SHINKEN.TOOLS.BACKEND_NO_RESPONSE_FRAME = (function ( self ) {
    self.getDomElement = function () {
        return DOM.Service.createElement( "div", {
            class: "shinken-no-backend-response-frame shinken-layout-center-h-v"
        }, '<div class="shinken-no-backend-response-frame-container"><h1><div> ' + _("communication.no_backend_response", [DICTIONARY_COMMON_UI]) + '</div></h1><div class="shinken-contact-admin"> ' + _("communication.contact_admin_shinken", [DICTIONARY_COMMON_UI]) + '</div></div>' );
    };
    self.getHtml       = function () {
        return self.getDomElement().outerHTML;
    };
    return self;
})( SHINKEN.TOOLS.BACKEND_NO_RESPONSE_FRAME || {} );