//__lib__ lib_common_V02_01
"use strict";

SHINKEN_GRID.Cells           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cells.prototype = {
    init             : function ( data ) {
        this.setUUID();
        this.addParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_UUID, "SHINKEN_GRID.Cells" );
        this.index_label_index = 1;
        this.initContents();
        this.initPhase();
        this.initCounterCommon();
        this.content_mapping = {};
        this.updateData( data );
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
    },
    //********************************************  EVENT LISTENER  *********************************************//
    doActionAfter                  : function ( event_name, params ) {
        switch ( event_name ) {
            case "widget_mapping_has_changed":
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL, "total", this.getSize() );
                return;
            case "add_new_widget__manually":
                this.setPreviousModificationElement();
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ].setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                this.addCellObject( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ] );
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ].doActionAfter( "adding_new_widget_manually", params );
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_CHILD ) );
                this.updateJsonIfNeeded( params );
                return;
            case "delete_selected_grid_cell":
                const last_modification = new SHINKEN.OBJECT.LastModification();
                last_modification.setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.DELETE );
                this.setPreviousModificationElement();
                this.removeCells( params );
                last_modification.addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_CHILD ) );
                params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].doActionAfter( "add_last_modification", { [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ]: last_modification } );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                if ( this.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ) ) ) {
                    this.getContentByUUID( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ) ).doActionAfter( event_name, params );
                    return;
                }
                this.doActionAfter__lastModification( event_name, params );
                return;
            case "on_scroll":
            case "update_nb_tiles_in_height":
            case "mouseover_on_deleting_pop_up":
            case "default__param__configured__from_form":
                for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
                    this.getContent( i ).doActionAfter( event_name, params );
                }
                return;
            case "default__param__configured__from_form__done":
                if ( !params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_OBJECT ].getSize() ) {
                    return; //NO SIZES CHANGE
                }
                for ( let i = 0, _size_i = params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_OBJECT ].getSize(); i < _size_i; i++ ) {
                    this.computeOverlapping( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_OBJECT ].getContent( i ) );
                    params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_OBJECT ].getContent( i ).doActionAfter( event_name, params );
                }
        }
        var _cell = this.getContentByUUID( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] || params );
        if ( !_cell ) {
            return;
        }
        _cell.doActionAfter( event_name, params );
        
        switch ( event_name ) {
            case "mouse_down_on_grid_cell":
            case "mouse_up_on_grid_cell":
                return _cell;
        }
    },
    doActionAfter__lastModification: function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        var _keys_next             = Object.keys( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getNext().mapping );
        var _keys_previous         = Object.keys( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getPrevious().mapping );
        var _list_uuid_missing;
        var _cell_added;
        switch ( modification_element.getTypeModification() ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_CHILD:
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ] = SHINKEN.TOOLS.ARRAY.getMissingElements( _keys_next, _keys_previous );
                switch ( event_name ) {
                    case "undo_last_modification":
                        this.removeCells( params );
                        break;
                    case "redo_last_modification":
                        this.addCellsFromLastModification( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getNext(), params );
                        break;
                }
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_CHILD:
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ] = SHINKEN.TOOLS.ARRAY.getMissingElements( _keys_previous, _keys_next );
                switch ( event_name ) {
                    case "redo_last_modification":
                        this.removeCells( params );
                        break;
                    case "undo_last_modification":
                        this.addCellsFromLastModification( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getPrevious(), params );
                        break;
                }
                break;
        }
        this.updateJsonIfNeeded( params );
    },
    addCellsFromLastModification   : function ( data, params ) {
        for ( let i = 0, _size_i = params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ].length; i < _size_i; i++ ) {
            this.addCellFromLastModification( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ][ i ], data, params );
        }
    },
    addCellFromLastModification    : function ( uuid_cell, data, params ) {
        let _cell_added = this.addCell( { "value": data[ "contents" ][ data[ "mapping" ][ uuid_cell ] ] }, uuid_cell );
        _cell_added.computeHtml( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ].dom_parent_with_scroll, true );
        _cell_added.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
        params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ].getController().doActionAfter( "window_problem__update__grid_cell__after__manual_action", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ]: _cell_added } );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setUUID              : function ( to_set ) {
        if ( !to_set && !this.uuid ) {
            to_set = SHINKEN.TOOLS.STRING.buildUUID();
        }
        this.uuid = to_set || this.uuid;
        this.addParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_UUID, this.uuid );
        this.addJsonAnchor( this.uuid );
    },
    getUUID              : function ( to_set ) {
        return this.uuid;
    },
    getChildConstructor  : function ( data ) {
        return new SHINKEN_GRID.Cell( data );
    },
    getChildrenObject    : function () {
        return this.getContents();
    },
    getChildrenObjectDict: function () {
        return this.getContents();
    },
    getJsonEditorInstance: function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.JsonEditor( dom_element, json, default_tag );
    },
    //********************************************  OTHERS  *****************************************************//
    getMaxTileInHeight: function () {
        var _box_content;
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return = Math.max( this.getContent( i ).getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ) + this.getContent( i ).getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ), _to_return );
        }
        return _to_return;
    },
    //********************************************  COMPUTE  *****************************************************//
    computeSizes            : function ( shinken_grid ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeSizes( shinken_grid );
        }
    },
    computeContentWithChange: function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _to_return += this.getContent( i ).computeContentWithChange();
        }
        return _to_return;
    },
    computeMapping          : function () {
        this.computeMappingCommon();
        this.doActionAfter( "widget_mapping_has_changed" );
    },
    //********************************************  LAST MODIFICATION  *****************************************************//
    getLastModificationElement: function ( type_modification ) {
        let to_return;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.ADD_CHILD:
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.REMOVE_CHILD:
                previous = this.previous_modication_data;
                next     = this.getDataForLastModification();
                break;
        }
        to_return                     = new SHINKEN.OBJECT.LastModificationElement( type_modification, element_modified, previous, next );
        this.previous_modication_data = null;
        return to_return;
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        var _to_return = [];
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.contents[ i ].getDataToSave() );
        }
        return _to_return;
    },
    //********************************************  HTML   **************************************************//
    computeHtml: function ( shinken_grid, dom_parent_with_scroll ) {
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml( shinken_grid, dom_parent_with_scroll );
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), shinken_grid.getDomElement() );
        }
    },
    //********************************************  UPDATE DATA   **************************************************//
    updateContentData : function ( data ) {
        var _keys = Object.keys( data );
        var _current_key;
        var _currents_content;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key      = _keys[ i ];
            _currents_content = this.content_mapping[ _current_key ];
            if ( _currents_content ) {
                for ( var j = 0, _size_j = _currents_content.length; j < _size_j; j++ ) {
                    _currents_content[ j ].updateShinkenElementData( data[ _current_key ] );
                }
            }
            else {
                console.error( "[Cells - updateContentData]", data );
            }
        }
    },
    updateData        : SHINKEN.OBJECT.DefaultConfiguration.prototype.updateData,
    setData           : function ( key, value ) {
        switch ( key ) {
            case "list_content":
                for ( var i = 0, _size_i = value.length; i < _size_i; i++ ) {
                    this.addCell( value[ i ] );
                }
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    addCell           : function ( data, forced_uuid ) {
        return this.addCellObject( this.getChildConstructor( data ), forced_uuid );
    },
    addCellObject     : function ( to_add, forced_uuid ) {
        if ( forced_uuid ) {
            SHINKEN.TOOLS.ARRAY.removeElementFromArrayWithValue( to_add._json_anchor, to_add.getUUID() );
            to_add.setUUID( forced_uuid );
        }
        this.addSynchronizedPhase( to_add );
        to_add.setCountersParent( this );
        this.add( to_add );
        to_add.setIndexLabel( this.index_label_index );
        this.index_label_index++;
        var _uuid_content = to_add.getContentUUID();
        if ( _uuid_content ) {
            if ( !this.content_mapping[ _uuid_content ] ) {
                this.content_mapping[ _uuid_content ] = [];
            }
            this.content_mapping[ _uuid_content ].push( to_add.content );
        }
        this.doActionAfter( "widget_mapping_has_changed" );
        to_add.addParamsForEvents( this.getParamForEvents() );
        return to_add;
    },
    removeCells       : function ( params ) {
        for ( let i = 0, _size_i = params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ].length; i < _size_i; i++ ) {
            this.removeContent( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ][ i ], params );
        }
        params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].doActionAfter( "ask_close_form_for_widget_configuration__if_needed", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ]: this } );
        this.updateJsonIfNeeded( params );
    },
    updateJsonIfNeeded: function ( params ) {
        if ( params && params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
            this.linkJsonDomElement();
            let json_editor = this.getJsonEditorInstance( null, this.getDataForJson(), SHINKEN_PAGE.CONST.DEFAULT_VALUE );
            DOM.Service.replaceElement( this.dom_element__json, json_editor.content.firstChild );
            this.dom_element__json = null;
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    computeOverlapping: function ( grid_cell ) {
        grid_cell.resetCounterByType( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeOverlapping( grid_cell );
        }
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase          : function () {
    },
    addParamForEvents         : SHINKEN.OBJECT.EditableElementContainerInterface.prototype.addParamForEvents,
    getDataForLastModification: SHINKEN.OBJECT.EditableElementContainerInterface.prototype.getDataForLastModification
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.EditableElementContainerInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cells, SHINKEN.OBJECT.PhaseInterface );