//priority 1048
//__lib__ lib_common_V02_01
"use strict";
SHINKEN.OBJECT.CommonFormInterface           = function () {
};
SHINKEN.OBJECT.CommonFormInterface.prototype = {
    addToPropertyModified              : function ( property_name ) {
        if ( !this.properties_modified.includes( property_name ) ) {
            this.properties_modified.push( property_name );
        }
    },
    askValidateForm                    : function ( param ) {
        this.addToPropertyModified( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] );
        if ( this.timeout__compute_validate_form ) {
            clearTimeout( this.timeout__compute_validate_form );
        }
        this.timeout__compute_validate_form = setTimeout( () => {
            this.validateForm( param );
            this.timeout__compute_validate_form = null;
            this.properties_modified            = [];
        }, 200 );
    },
    parseTilesBackgroundValueForPreview: function ( composed_key ) {
        switch ( composed_key ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.COMPOSED_KEY:
                switch ( __tiles_background__ ) {
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.CONTEXT_AND_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.CONTEXT_THEN_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.OPTIONS.ONLY_STATUS;
                }
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY:
                switch ( __tiles_background__ ) {
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.DEFAULT:
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.CONTEXT_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS;
                    case SHINKEN.ELEMENT.USER.PARAM.TILES_FORMAT.BACKEND_KEY.STATUS_UP:
                        return WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS;
                }
                break;
        }
    },
    parseConfigurationToArray          : function ( enum_tab, dict_key, property_structure, widget_type ) {
        let composed_key  = property_structure.COMPOSED_KEY ? property_structure.COMPOSED_KEY.split( "." ).slice( 1 ).join( "." ) : SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT;
        let default_value = this.getDefaultValueFromGridObject( widget_type, composed_key );
        let to_return     = [];
        
        const _keys = Object.keys( enum_tab );
        let value;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            value = enum_tab[ _keys[ i ] ];
            to_return.push( { name: value, label: _( dict_key + "." + value, [DICTIONARY_COMMON_UI] ) } );
        }
        let default_label = default_value;
        if ( isTranslateKeyExisting( dict_key + "." + default_value, [DICTIONARY_COMMON_UI] ) ) {
            default_label = _( dict_key + "." + default_value, [DICTIONARY_COMMON_UI] );
        }
        default_label = SHINKEN.TOOLS.STRING.format( _( "property.default_label", [DICTIONARY_COMMON_UI] ), default_label );
        to_return.push( { name: WEATHER.CONST.DEFAULT_VALUE, label: default_label, [ PROPERTY_V2.COMMON.PARAM.IS_DEFAULT ]: true, [ PROPERTY_V2.COMMON.PARAM.DEFAULT_VALUE ]: default_value } );
        return to_return;
    },
    getDefaultValueFromGridObject      : function ( widget_type, composed_key ) {
        return this.grid_object.getDefaultValueFor( widget_type, composed_key );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getController: function () {
        return CONTROLLER.PageController;
    },
    setPropertyValue   : function ( property_name, value ) {
        this.doActionAfter( "property_value__set__by_js", {
            [ SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ]: this.getName(), [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: property_name, [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: value
        } );
    },
    //********************************************  USER PREF  *****************************************************//
    getUserPref: function () {
        let to_return = {
            [ SHINKEN.USER_PREFS.KEY ]  : this.getName(),
            [ SHINKEN.USER_PREFS.VALUE ]: {}
        };
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            to_return[ SHINKEN.USER_PREFS.VALUE ][ this.getContent( i ).getUUID() ] = this.getContent( i ).getUserPref();
        }
        return to_return;
    }
};