//priority 1048
//__lib__ lib_common_V02_01
"use strict";


SHINKEN.OBJECT.WeatherWidgetFormInterface = function () {
};

SHINKEN.OBJECT.WeatherWidgetFormInterface.prototype = {
    initWeatherWidgetDefault: function ( user_prefs ) {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData_V3( SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.WEATHER._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.WEATHER._KEY ) ), true );
        if ( !user_prefs || !user_prefs.getValueByKey( [widget_cf.getUUID(), SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN] ) ) {
            widget_cf.addClass( "shinken-close" );
        }
        
        let current_cf = this.addSpecificToChild( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.DEFAULTFORM.WIDGET.COLLAPSE_FOLDER.DIMENSION_AREA._KEY, _( "grid.mode_edition.form_widget.cf_common.cf_size.title", [DICTIONARY_COMMON_UI] ) ), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.getProperty__widgetWeather__width(), current_cf );
        this.addSpecificToChild( this.getProperty__widgetWeather__height(), current_cf );
        
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetWeather__display(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetWeather__areas(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        
        this.grid_for_preview = this.addSpecificToChild( new SHINKEN_GRID.GridForPreview( this.getInitialDataForPreviewWidget( true ) ), widget_cf, true );
        this.grid_for_preview.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
        this.grid_cell_for_preview = this.grid_for_preview.grid_elements.getContent( 0 );
        this.grid_cell_for_preview.computeHtml();
        
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__leftArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__topRightArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__slaArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__nameArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        
    },
    // ************************************* COLLAPSE FOLDERS *******************************************//
    getCollapseFolder__widgetWeather__display     : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.DISPLAY._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_display.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetWeather__usedAsName(), to_return );
        this.addSpecificToChild( this.getProperty__widgetWeather__background(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__areas       : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_area.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetWeather__displayTopRight(), to_return );
        this.addSpecificToChild( this.getProperty__widgetWeather__displaySla(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__leftArea    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_left_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.getProperty__widgetWeather__iconTypeLeftArea(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__topRightArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.getProperty__widgetWeather__iconTypeTopRight(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__slaArea     : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_sla_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.getProperty__widgetWeather__slaShowIcon(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__nameArea    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.NAME_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.title", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.getProperty__widgetWeather__verticalAlign(), to_return );
        this.addSpecificToChild( this.getProperty__widgetWeather__fontZoom(), to_return );
        this.addSpecificToChild( this.getProperty__widgetWeather__nbLinesMax(), to_return );
        return to_return;
    },
    // ************************************* PROPERTIES *******************************************//
    getProperty__widgetWeather__usedAsName      : function () {
        return new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.property_used_as_name._key", [DICTIONARY_COMMON_UI] ) );
    },
    getProperty__widgetWeather__background      : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithSelector__FromData( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND ), _( "grid.mode_edition.form_widget.weather_widget.cf_display.properties.background._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "change_selector_default_title", { [ COMPONENT.CONST.PARAM.TEXT_DEFAULT_SELECTOR ]: _( "grid.mode_edition.form_widget.weather_widget.cf_display.properties.background.radio.default_label_selector", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetWeather__displayTopRight : function () {
        const to_return = new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) );
        to_return.addParamForEvents( SHINKEN.OBJECT.COLLAPSE.PARAM.NAME_FOR_HIDDEN_PREVIEW, SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY );
        return to_return;
    },
    getProperty__widgetWeather__displaySla      : function () {
        const to_return = new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) );
        to_return.addParamForEvents( SHINKEN.OBJECT.COLLAPSE.PARAM.NAME_FOR_HIDDEN_PREVIEW, SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY );
        return to_return;
    },
    getProperty__widgetWeather__iconTypeLeftArea: function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithSelector__FromData( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE ), _( "grid.mode_edition.form_widget.weather_widget.cf_left_area.properties.icon_type._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "change_selector_default_title", { [ COMPONENT.CONST.PARAM.TEXT_DEFAULT_SELECTOR ]: _( "grid.mode_edition.form_widget.weather_widget.cf_left_area.properties.icon_type.radio.default_label_selector", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetWeather__iconTypeTopRight: function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithSelector__FromData( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE ), _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.icon_type._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "change_selector_default_title", { [ COMPONENT.CONST.PARAM.TEXT_DEFAULT_SELECTOR ]: _( "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.displayed.radio.default_label_selector", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetWeather__slaShowIcon     : function () {
        return new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON ), _( "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.show_icon._key", [DICTIONARY_COMMON_UI] ) );
    },
    getProperty__widgetWeather__verticalAlign   : function () {
        return new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.vertical_align._key", [DICTIONARY_COMMON_UI] ) );
    },
    getProperty__widgetWeather__fontZoom        : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.font_zoom_percent._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.font_zoom_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetWeather__nbLinesMax      : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX ), _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.nb_lines_max._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.nb_lines_max.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetWeather__width           : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.WIDTH.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.WIDTH ), _( "grid.mode_edition.form_widget.cf_common.cf_size.width._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.cf_common.cf_size.width.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetWeather__height          : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.HEIGHT.COMPOSED_KEY, this.getConfigurationForWeatherPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.HEIGHT ), _( "grid.mode_edition.form_widget.cf_common.cf_size.height._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.cf_common.cf_size.height.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    // ************************************* COMPUTE  *****************************************************
    synchronizationProperty: function ( param, avoid_notification ) {
        switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY:
                let property_left  = this.property_set.getContentByUUID( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY );
                let property_right = this.property_set.getContentByUUID( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY );
                let value_left     = property_left.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                let value_tp_r     = property_right.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                if ( WIDGET.CONST.isSameIconType( value_left, value_tp_r ) ) {
                    if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY ) {
                        if ( value_left[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS );
                        }
                        else {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON );
                        }
                        if ( !avoid_notification ) {
                            SHINKEN.TOOLS.NOTIFICATION.addNotification( SHINKEN.TOOLS.STRING.format( _( "validation.errors.change_auto__duplicate_value_on_property" ),
                                '<span class="shinken-data-user">' + property_right.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY )
                                                                                                                                                    .getLabel() + '&nbsp;)</span>',
                                '<span class="shinken-data-user">' + property_left.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY )
                                                                                                                                                   .getLabel() + '&nbsp;)</span>'
                            ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO, null, 10000 );
                        }
                    }
                    if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY ) {
                        if ( value_tp_r[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS );
                        }
                        else {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON );
                        }
                        if ( !avoid_notification ) {
                            SHINKEN.TOOLS.NOTIFICATION.addNotification( SHINKEN.TOOLS.STRING.format( _( "validation.errors.change_auto__duplicate_value_on_property" ),
                                '<span class="shinken-data-user">' + property_right.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY )
                                                                                                                                                    .getLabel() + '&nbsp;)</span>',
                                '<span class="shinken-data-user">' + property_left.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY )
                                                                                                                                                   .getLabel() + '&nbsp;)</span>'
                            ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO, null, 10000 );
                        }
                    }
                }
                break;
        }
    },
    // ************************************* GETTER *****************************************************
    getInitialDataForPreviewWidget               : function ( is_default_form ) {
        const layout = is_default_form ?
                       this.getDefaultPreviewWidgetLayout() :
                       SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseDictToDict_withValueKey( this.main_grid_cell.content.layout.getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT ) );
        return {
            "width"  : {
                "value": 15
            },
            "height" : {
                "value": 4
            },
            "content": {
                "type"  : {
                    "value": "weather_widget"
                },
                "layout": {
                    "value": layout
                },
                "item"  : {
                    "value": {
                        "item_uuid": {
                            "value": "010010010"
                        },
                        "item_name": {
                            "value": "Preview_Widget"
                        },
                        "item_type": {
                            "value": "host"
                        }
                    }
                }
            }
        };
    },
    getConfigurationForWeatherPropertiesRadioList: function ( property_structure ) {
        let to_return = [];
        let enum_tab;
        let dict_key;
        switch ( property_structure._KEY ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.WIDTH._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_sizes.properties.width.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_display.properties.background.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.property_used_as_name.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_left_area.properties.icon_type.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_name_area.properties.vertical_align.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.displayed.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_top_right_area.properties.icon_type.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.displayed.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON._KEY:
                dict_key = "grid.mode_edition.form_widget.weather_widget.cf_sla_area.properties.show_icon.radio";
                break;
        }
        return this.parseConfigurationToArray( property_structure.OPTIONS, dict_key, property_structure, WIDGET.CONST.TYPE.WEATHER );
    }
};