//__lib__ lib_common_V02_01
"use strict";

SHINKEN_PAGE.InfoBar = function ( data ) {
    this.dom_element = null;
    this.init(data);
};

SHINKEN_PAGE.InfoBar.prototype = {
    updateWithData      : function ( data ) {
        this.updateData( data );
        this.updateHtml();
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR, SHINKEN_VALIDATION.CONST.COLOR.CSS._KEY],
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, ['top', 'bottom', SHINKEN_PAGE.CONST.DEFAULT_VALUE]]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH, "SHINKEN_PAGE.InfoBarRefresh"]
        ] );
    },
    setDomElement       : function ( to_set ) {
        this.dom_element = to_set;
    },
    updateHtml          : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.computeInfoBarBackgroundColor();
        this.computeInfoBarShinkenLogo();
        this.computeInfoBarChronoDisplayed();
        this.computeInfoBarGenerationTimeDisplayed();
    },
    
    getPosition                          : function () {
        if ( !this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED ) &&
             !this.getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED ) &&
             !this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED ) ) {
            return "shinken-hidden";
        }
        if ( this.getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.POSITION ) === SHINKEN_PAGE.CONST.INFO_BAR.VALUES.POSITION_BOTTOM ) {
            return "bottom";
        }
        else {
            return "top";
        }
    },
    computeInfoBarBackgroundColor        : function () {
        DOM.Service.setStyle( this.dom_element.querySelector( ".shinken-info-bar" ), DOM.CONST.STYLE.BACKGROUND_COLOR, this.getValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.BACKGROUND_COLOR ) );
    },
    computeInfoBarShinkenLogo            : function () {
        var _dom_logo_img      = this.dom_element.querySelector( '.shinken-logo' );
        var _is_logo_displayed = this.getBooleanValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.LOGO_DISPLAYED );
        if ( !__external_url_uuid__ ) {
            DOM.Service.addClasses( _dom_logo_img, 'shinken-hidden' );
            return;
        }
        DOM.Service.addOrRemoveClasses( _dom_logo_img, !_is_logo_displayed, 'shinken-hidden' );
    },
    computeInfoBarChronoDisplayed        : function () {
        var _dom_chrono     = this.dom_element.querySelector( '.shinken-container-clock' );
        var _chrono_display = this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getBooleanValue(  SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED );
        DOM.Service.addOrRemoveClasses( _dom_chrono, !_chrono_display, 'shinken-hidden' );
        
    },
    computeInfoBarGenerationTimeDisplayed: function () {
        var _dom_generate_refresh = this.dom_element.querySelector( '.shinken-container-update-at' );
        var _generated = this.getChild( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.REFRESH ).getBooleanValue( SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED );
        DOM.Service.addOrRemoveClasses( _dom_generate_refresh, !_generated, 'shinken-hidden' );
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.InfoBar, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );


SHINKEN_PAGE.InfoBarRefresh = function ( data ) {
    this.init( data );
};

SHINKEN_PAGE.InfoBarRefresh.prototype = {
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.CHRONO_DISPLAYED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY],
            [SHINKEN_PAGE.CONST.INFO_BAR.PARAMS.GENERATION_TIME_DISPLAYED, SHINKEN_VALIDATION.CONST.BOOLEAN._KEY]
        ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_PAGE.InfoBarRefresh, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );