//__lib__ lib_common
"use strict";

WINDOW.ElementFromData           = function ( name, parent_name ) {
    this.__class_name__ = 'WINDOW.ElementFromData';
    this.name           = name;
    this.parent_name    = parent_name;
    this.init();
};
WINDOW.ElementFromData.prototype = {
    init          : function () {
        this.initCounters();
        this.initId();
    },
    initId        : function () {
        this.id = "id-shinken-window-" + this.name + this.parent_name;
    },
    initController: function () {
    },
    getController : function () {
        return "";
    },
    //********************************************  OTHER  *****************************************************//
    resizeDone: function () {
        if ( this.getController() ) {
            this.getController().resizeDone();
        }
    },
    //********************************************  HTML  *****************************************************//
    getMainClass     : function () {
        var _to_return = "shinken-window-element";
        if ( this.isActive() ) {
            _to_return += " shinken-active";
        }
        if ( this.is_disabled ) {
            _to_return += " shinken-disabled";
        }
        
        return _to_return;
    },
    computeHtml      : function () {
        this.setDomElement( DOM.Service.createElement( "td", {
            "class"                : this.getMainClass(),
            "id"                   : this.id,
            "data-group-name"      : this.parent_name,
            "data-name"            : this.name,
            "data-visibility-state": this.getVisibilityState()
        } ) );
        this.main_div_dom_element = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-div-tab" } ) );
        var _div_1                = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-div-tab-content" } ), this.main_div_dom_element );
        var _table                = DOM.Service.addElementTo( DOM.Service.createElement( "table", { "class": "shinken-table" } ), _div_1 );
        var _tr                   = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        DOM.Service.addElementTo( this.getLabelCellHtml(), _tr );
        
        this.computeHtml_lvl_1();
        this.computeHtml_tooltip();
        this.computeHtmlTarget();
    },
    getLabelCellHtml : function () {
        var _to_return = DOM.Service.createElement( "td", { "class": "shinken-window-element-label" } );
        var _div       = DOM.Service.addElementTo( DOM.Service.createElement( "div", {}, this.getLabel() ), _to_return );
        if ( this.total ) {
            this.total.computeHtml();
            DOM.Service.addElementTo( this.total.getDomElement(), _div );
        }
        return _to_return;
    },
    computeHtml_lvl_1: function () {
    },
    computeHtmlTarget: function () {
        var _class = "shinken-tab-pane property-tab-pane shinken-prop-table shinken-parent-tab-id-parent";
        if ( !this.is_active ) {
            _class += " shinken-hidden";
        }
        this.dom_element_target = DOM.Service.createElement( "div", {
            "class"    : _class,
            "id"       : this.id + "-target",
            "data-name": this.name
        } );
        if ( this.content_dom_element_target ) {
            DOM.Service.addElementToAfterEmpty( this.content_dom_element_target, this.dom_element_target );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementFromData, WINDOW.Element );

WINDOW.ElementFromDataWithComma           = function ( name, parent_name ) {
    this.__class_name__ = 'WINDOW.ElementFromDataWithComma';
    this.name           = name;
    this.parent_name    = parent_name;
    this.init();
};
WINDOW.ElementFromDataWithComma.prototype = {
    init             : WINDOW.ElementFromData.prototype.init,
    computeHtml_lvl_1: function () {
        var start_div = DOM.Service.addElementAtIndex( DOM.Service.createElement( "div", { class: "shinken-div-round-part-1" } ), this.main_div_dom_element, 0 );
        var start_svg = DOM.Service.addElementTo( DOM.Service.cloneElement( document.getElementById( 'id-shinken-window-comma-shadow-left' ).querySelector( ".window-comma-shadow-left" ) ), start_div );
        
        var end_div = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-div-round-part-2" } ), this.main_div_dom_element );
        var end_svg = DOM.Service.addElementTo( DOM.Service.cloneElement( document.getElementById( 'id-shinken-window-comma-shadow-right' ).querySelector( ".window-comma-shadow-right" ) ), end_div );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementFromDataWithComma, WINDOW.ElementFromData );