//__lib__ lib_common
"use strict";

WINDOW.ElementFromHtml           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.ElementFromHtml';
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.ElementFromHtml.prototype = {
    init          : function () {
        this.initDomElement();
        if ( this.is_menu ) {
            var _dom_element_counters = this.dom_element.querySelectorAll( '.shinken-counter' );
            this.counters             = {};
            var _current;
            for ( var i = 0, _size_i = _dom_element_counters.length; i < _size_i; i++ ) {
                _current                                      = _dom_element_counters[ i ];
                this.counters[ _current.dataset.counterType ] = new SHINKEN.OBJECT.Counter();
                this.counters[ _current.dataset.counterType ].init( _current );
            }
        }
        else {
            this.initCounters();
        }
    },
    initDomElement: function () {
        this.id = this.dom_element.getAttribute( 'id' );
        if ( this.is_menu ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.is_active = true;
        }
        this.dom_element_target = document.getElementById( this.id + '-target' );
        if ( !this.dom_element_target ) {
            console.warn( "[LA STRUCTURE HTML des windows n'est pas correcte]", this.id, this.id + '-target  ==> not found' );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementFromHtml, WINDOW.Element );

//WINDOW.ElementWithProperties           = function ( name, dom_element, is_menu ) {
//    this.__class_name__ = 'WINDOW.ElementWithProperties';
//
//    //id
//    //dom_element_target
//    //counters
//    this.name        = name;
//    this.dom_element = dom_element;
//    this.is_menu     = !!is_menu;
//    this.init();
//};
//WINDOW.ElementWithProperties.prototype = {
//    hasProperties: function () {
//        return true;
//    }
//};
//SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementWithProperties, WINDOW.Element );