#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2009-2012:
#    Gabes Jean, naparuba@gmail.com
#    Gerhard Lausser, Gerhard.Lausser@consol.de
#    Gregory Starck, g.starck@gmail.com
#    Hartmut Goebel, h.goebel@goebel-consult.de
#
# This file is part of Shinken.
#
# Shinken is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Shinken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Shinken.  If not, see <http://www.gnu.org/licenses/>.

# Tell PyCharm the imports have been made for external module import, so it is not considered unused.
__all__ = (
    'cPickle',
    'cStringIO',
    'Empty',
    'StringIO',
    'ConfigParser',
    'SHINKEN_PICKLE_PROTOCOL',
    'bytes_to_unicode',
    'unicode_to_bytes',
)

import pickle as cPickle
from io import StringIO as cStringIO
from queue import Empty

StringIO = cStringIO
import configparser as ConfigParser

SHINKEN_PICKLE_PROTOCOL = cPickle.DEFAULT_PROTOCOL


def bytes_to_unicode(s, strict=False):
    if isinstance(s, (bytes, bytearray)):  # bytearray is bytes that can mutate
        if strict:
            return s.decode('utf8')
        return s.decode('utf8', 'ignore')
    return s


def unicode_to_bytes(s):
    if isinstance(s, str):
        return s.encode('utf8', 'ignore')
    return s
