#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.
#

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Union
    from shinken.log import PartLogger


class ERROR_LEVEL:
    ERROR = 'ERROR'
    WARNING = 'WARNING'
    FATAL = 'FATAL'


class ErrorHandler:
    def handle_exception(self, message, exception, _logger, level):
        # type: (str, Union[str,Exception], PartLogger, str) -> None
        raise NotImplementedError()
