#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_item import SourceItem


class SourceMacroModulation(SourceItem):
    __slots__ = SourceItem.__slots__ + [
        'macromodulation_name',
        'modulation_period',
        'imported_from',
        'definition_order',
        'uuid'
    ]
    
    
    def __init__(self):
        super(SourceMacroModulation, self).__init__()
        self.item_type = ITEM_TYPE.MACROMODULATIONS
