"use strict";
SHINKEN.TOOLS.RECEIVER_MODULE_WEBSERVICE = (function ( self ) {
    const _INTERNAL                    = {};
    self.ACKNOWLEDGE                   = {};
    self.ACKNOWLEDGE.ACTION            = {};
    self.PUSH_CHECK_RESULT             = {};
    self.PUSH_CHECK_RESULT.ACTION      = {};
    //********************************************  INTERNAL   **************************************************//
    _INTERNAL.computeWebserviceData    = function ( data ) {
        let to_return = "";
        let _keys     = Object.keys( data );
        let _current_key;
        let _current_value;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key   = _keys[ i ];
            _current_value = data[ _current_key ];
            if ( i ) {
                to_return += "&";
            }
            to_return += _current_key + "=" + _current_value;
        }
        return to_return;
    };
    //********************************************  ACTION  **************************************************//
    self.ACKNOWLEDGE.ACTION.call       = function ( timeout, data ) {
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executeCurlCommand(
            timeout,
            "anonymous",
            "secret",
            "POST",
            "http://" + SHINKEN.HIGHWAY.getHostName() + ":" + MODULE__PORT__RECEIVER_WEBSERVICE + "/acknowledge",
            null,
            _INTERNAL.computeWebserviceData( data )
        );
        return 3500;
    };
    self.PUSH_CHECK_RESULT.ACTION.call = function ( timeout, data ) {
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executeCurlCommand(
            timeout,
            "anonymous",
            "secret",
            "POST",
            "http://" + SHINKEN.HIGHWAY.getHostName() + ":" + MODULE__PORT__RECEIVER_WEBSERVICE + "/push_check_result",
            null,
            _INTERNAL.computeWebserviceData( data )
        );
        return 4000;
    };
    return self;
})( SHINKEN.TOOLS.RECEIVER_MODULE_WEBSERVICE || {} );
