"use strict";
TI.PROPERTY = (function ( self ) {
    self.DOM                    = {};
    self.TEST                   = {};
    self.TEST.JS                = {};
    self.ACTION                 = {};
    self.GETTER                 = {};
    self.CONST                  = {
        DISPLAY: {
            HIDDEN : "property__display__hidden",
            VISIBLE: "property__display__visible"
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.line               = function ( property_name, dom_element ) {
        if ( !dom_element ) {
            dom_element = document;
        }
        return dom_element.querySelector( '.shinken-element-property-line[data-name="' + property_name + '"]' );
    };
    self.DOM.lineV3               = function ( property_name, dom_element ) {
        if ( !dom_element ) {
            dom_element = document;
        }
        return dom_element.querySelector( '.shinken-element-property-line-V3[data-name="' + property_name + '"]' );
    };
    self.DOM.actionCell          = function ( property_name ) {
        return self.DOM.lineV3( property_name ).querySelector( ".shinken-prop-cell-action-V3 " );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.display__20250130 = function ( timeout, property_name, state ) {
        var _to_return = 10;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.isState', property_name + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( state ) {
                case self.CONST.DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( self.DOM.lineV3( property_name ), "property " + property_name );
                    break;
                case self.CONST.DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.lineV3( property_name ), "property " + property_name );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return 10;
    };
    //********************************************  ACTION   **************************************************//
    return self;
})( TI.PROPERTY || {} );
