"use strict";
TI.WEATHER.FORM.WIDGET = (function ( self ) {
    self.DOM                                               = {};
    self.DOM.WEATHER                                       = {};
    self.TEST                                              = {};
    self.TEST.WEATHER                                      = {};
    self.TEST.WEATHER.PREVIEW                              = {};
    self.ACTION                                            = {};
    self.ACTION.WEATHER                                    = {};
    self.ACTION.WEATHER.PREVIEW                            = {};
    self.ACTION.WEATHER.PREVIEW.LEFT_AREA                  = {};
    self.ACTION.WEATHER.PREVIEW.NAME_AREA                  = {};
    self.ACTION.WEATHER.PREVIEW.SLA_AREA                   = {};
    self.ACTION.WEATHER.PREVIEW.TOP_RIGHT_AREA             = {};
    self.CONST                                             = {
        PREVIEW_WIDGET: {
            ZONE         : {
                LEFT          : "form_default__zones__left_area",
                SLA           : "form_default__zones__SLA_area",
                TOP_RIGHT_AREA: "form_default__zones__top_right_area",
                NAME          : "form_default__zones__name_area",
                NAME_CLICK    : "form_default__zones__name_area_click",
                NAME_LABEL    : "form_default__zones__name_area_label"
            },
            STATE_DISPLAY: {
                HIDDEN : 0,
                VISIBLE: 1
            }
        }
    };
    //********************************************  TEST   **************************************************//
    self.TEST.WEATHER.PREVIEW.isLabel__20250203            = function ( timeout, text_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.WEATHER.widgetPreview__zoneNameLabel(), text_expected );
        }, timeout );
        return 200;
    };
    self.TEST.WEATHER.PREVIEW.hasBackgroundColor__20250203 = function ( timeout, color_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.WEATHER.widgetPreview(), "backgroundColor", color_expected );
        }, timeout );
        return 200;
    };
    self.TEST.WEATHER.PREVIEW.stateArea__20250203          = function ( timeout, widget_area, state ) {
        setTimeout( function () {
            let _dom_element = self.DOM.WEATHER.widgetPreview__zone( widget_area );
            switch ( state ) {
                case self.CONST.PREVIEW_WIDGET.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNoWidth( 0, _dom_element, widget_area );
                    break;
                case self.CONST.PREVIEW_WIDGET.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_element, widget_area );
                    break;
            }
        }, timeout );
        return 300;
    };
    self.TEST.WEATHER.PREVIEW.verticalAlign                = function ( timeout, widget_area, alignment ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.WEATHER.PREVIEW.verticalAlign" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.WEATHER.widgetPreview__zone( widget_area ), "vertical-align", alignment );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  DOM  ****************************************//
    self.DOM.form                                          = function () {
        return document.querySelector( ".shinken-extra-form-specific .shinken-form-container" );
    };
    self.DOM.WEATHER.form                                  = function () {
        return self.DOM.form().querySelector( ".shinken-collapse-folder[data-name='cf_weather_widget_part']" );
    };
    self.DOM.WEATHER.widgetPreview                         = function () {
        return self.DOM.form().querySelector( ".shinken-widget" );
    };
    self.DOM.WEATHER.widgetPreview__zone                   = function ( zone_area ) {
        switch ( zone_area ) {
            case self.CONST.PREVIEW_WIDGET.ZONE.LEFT:
                return self.DOM.WEATHER.widgetPreview__zoneLeft();
            case self.CONST.PREVIEW_WIDGET.ZONE.NAME:
                return self.DOM.WEATHER.widgetPreview__zoneName();
            case self.CONST.PREVIEW_WIDGET.ZONE.SLA:
                return self.DOM.WEATHER.widgetPreview__zoneSLA();
            case self.CONST.PREVIEW_WIDGET.ZONE.NAME_LABEL:
                return self.DOM.WEATHER.widgetPreview__zoneNameLabel();
            case self.CONST.PREVIEW_WIDGET.ZONE.NAME_CLICK:
                return self.DOM.WEATHER.widgetPreview__zoneNameClick();
            case self.CONST.PREVIEW_WIDGET.ZONE.TOP_RIGHT_AREA:
                return self.DOM.WEATHER.widgetPreview__zoneTopRight();
        }
    };
    self.DOM.WEATHER.widgetPreview__zoneLeft               = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-left-area .shinken-grid-cell-mask-container-preview" );
    };
    self.DOM.WEATHER.widgetPreview__zoneName               = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-name" );
    };
    self.DOM.WEATHER.widgetPreview__zoneNameClick          = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-name .shinken-grid-cell-mask-container-preview" );
    };
    self.DOM.WEATHER.widgetPreview__zoneNameLabel          = function () {
        return self.DOM.WEATHER.widgetPreview__zoneName().querySelector( ".shinken-optimal-container .shinken-label" );
    };
    
    self.DOM.WEATHER.widgetPreview__zoneSLA                   = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-row-sla .shinken-grid-cell-mask-container-preview" );
    };
    self.DOM.WEATHER.widgetPreview__zoneTopRight              = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-remaining .shinken-cell-top-right-area" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnPreviewZone                            = function ( timeout, zone_area ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnPreviewZone", zone_area );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.WEATHER.widgetPreview__zone( zone_area ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.WEATHER.PREVIEW.LEFT_AREA.clickLeftArea       = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.LEFT );
    };
    self.ACTION.WEATHER.PREVIEW.NAME_AREA.clickNameArea       = function ( timeout ) {
        return TI.WEATHER.FORM.WIDGET.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.NAME_CLICK );
    };
    self.ACTION.WEATHER.PREVIEW.SLA_AREA.clickSLAArea         = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.SLA );
    };
    self.ACTION.WEATHER.PREVIEW.TOP_RIGHT_AREA.clickRightArea = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.TOP_RIGHT_AREA );
    };
    
    return self;
})
( TI.WEATHER.FORM.WIDGET || {} );
