"use strict";
TI.WEATHER.GRID.HISTORY = (function ( self ) {
    self.DOM                 = {};
    self.DOM.CELL            = {};
    self.DOM.CELL.ACTION     = {};
    self.TEST                = {};
    self.TEST.CELL           = {};
    self.TEST.CELL.ACTION    = {};
    self.ACTION              = {};
    self.CONST               = {
        WINDOW_GROUP_PROBLEM: {
            STATUS: {
                VISIBLE     : "visible",
                HIDDEN      : "hidden",
                NON_EXISTING: "non_existing"
            }
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.container       = function () {
        return document.querySelector( "#id-shinken-window-V2-edit_tab_history-shinken-edition-main-part-target .shinken-view-history-container" );
    };
    self.DOM.lastLine        = function () {
        return self.DOM.container().querySelector( ".shinken-list-line" );
    };
    self.DOM.CELL.ACTION.cell = function () {
        return self.DOM.lastLine().querySelector( ".shinken-list-cell-content[data-filter='"+ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY +"']" );
    };
    self.DOM.CELL.ACTION.cellDate = function () {
        return self.DOM.lastLine().querySelector( ".shinken-list-cell-content[data-filter='"+ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.DATE_HISTORY +"']" );
    };
    //********************************************  GETTER   **************************************************//
    
    self.DOM.getHistoryLineWithIndex = function ( index ) {
        return self.DOM.lines()[ index ];
    };

    //********************************************  TEST   **************************************************//
    self.TEST.CELL.ACTION.hasText    = function ( timeout, text_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo(self.DOM.CELL.ACTION.cell(), text_expected );
        }, timeout );
        return 300;
    };
    self.TEST.CELL.ACTION.hasDate    = function ( timeout ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isNotEmpty(self.DOM.CELL.ACTION.cellDate() );
        }, timeout );
        return 300;
    };
    //********************************************  ACTION   **************************************************//
    
    return self;
})( TI.WEATHER.GRID.HISTORY || {} );

