"use strict";
SHINKEN.TOOLS.TEST_AUTO_DATA_TAB = (function ( self ) {
    self.DOM                = {};
    self.ACTION             = {};
    self.TEST               = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.navElement = function ( name, type ) {
        return document.querySelector( '#shinken-data-tab-nav .shinken-data-nav-link[data-name="' + name + '-' + type + '"]' );
    };
    self.DOM.getDataNavCountersDomElement    = function ( name, type ) {
        return self.DOM.navElement( name, type ).querySelectorAll( ".shinken-counter" );
    };
    self.DOM.allRemoveButtons    = function () {
        return document.querySelectorAll( '.shinken-element-property-line .shinken-delete-data-icon' );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.navigateInTab     = function ( timeout, name, type ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.navElement( name, type ) );
        }, timeout );
        return 100;
    };
    self.ACTION.removeAllData     = function ( timeout ) {
        setTimeout( function () {
            var _doms = self.DOM.allRemoveButtons();
            for ( let i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _doms[i] );
            }
        }, timeout );
        return 500;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.counter  = function ( timeout, nb_error, nb_warning, nb_user, nb_total, name_template, type ) {
        setTimeout( function () {
            var _counters = self.DOM.getDataNavCountersDomElement( name_template, type );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ 0 ], nb_error );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ 1 ], nb_warning );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ 2 ], nb_user );
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ 3 ], nb_total );
        }, timeout );
        return 10;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_DATA_TAB || {} );



