"use strict";
TI.SERVICE.DB = (function ( self ) {
    self.TEST                               = {};
    self.ACTION                             = {};
    var _INTERNAL                           = {};
    var _TEMPLATE                           = {};
    //********************************************  ACTION  ****************************************//
    self.ACTION.update                      = function ( timeout, database, collection, document_id ) {
        let _switch_value = __shinken_test_type + "-" + __phase;
        let data          = "";
        switch ( _switch_value ) {
            case "00274-10":
                data = {
                    "service_overrides": {
                        "raw_value"           : "",
                        "links"               : [
                            {
                                "key"       : "business_impact",
                                "value"     : "1",
                                "check_link": {
                                    "check_name": "00274_test_auto",
                                    "item_type" : "serviceshosts",
                                    "_id"       : "20000000000000000000000000000274",
                                    "exists"    : true
                                }
                            }
                        ],
                        "links_with_errors"   : [
                            {
                                "check_link": {
                                    "check_name": "00274_test_auto",
                                    "item_type" : "serviceshosts",
                                    "_id"       : "20000000000000000000000000000274",
                                    "exists"    : true
                                },
                                "error_type": "duplicate",
                                "value"     : "0",
                                "key"       : "business_impact"
                            }
                        ],
                        "link_error_raw_value": "Two services override with a different value were set on same check [ 00274_test_auto ] on the property [ business_impact ]. We removed value [ 1 ] and kept [ 0 ], as 1 was the value currently used by Shinken. You need to confirm this choice in the host page by checking the value and then removing the message on the overload.",
                        "all_linked_types"    : [
                            "serviceshosts"
                        ]
                        
                    }
                };
                break;
        }
        self.ACTION.updateDocumentToMongo( timeout, database, collection, document_id, data );
        return 3000;
    };
    self.ACTION.start                       = function ( timeout ) {
        let _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TI.SERVICE.DB.start' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service mongod start", function ( _status, data ) {
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.COMMON.errorExecuteCommand( "service mongod start" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.stop                        = function ( timeout ) {
        let _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TI.SERVICE.DB.stop' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "service mongod stop", function ( _status, data ) {
            }, function ( err ) {
                SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.COMMON.errorExecuteCommand( "service mongod stop" );
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.dropDatabase                = function ( timeout, database ) {
        var _command = "mongo " + database + " --eval " + "'db.dropDatabase()'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            self.COMMON.errorExecuteCommand( err );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.dropCollection              = function ( timeout, database, collection ) {
        var _command = "mongo " + database + " --eval " + "'db. " + collection + ".drop()'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            self.COMMON.errorExecuteCommand( err );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.dropAllDatabases            = function ( timeout ) {
        __do_next = false;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.stopAll( 0, function () {
                _INTERNAL.dropAllDatabases();
                SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.startAll( 4000,
                    function () {
                        SHINKEN.HIGHWAY.goTo( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                    } );
            } );
        }, timeout );
    };
    self.ACTION.deleteManyMongo             = function ( timeout, database, collection, query, mongo_username, mongo_password, mongo_autentication_database ) {
        let _command = "mongo ";
        if ( mongo_username ) {
            _command += `-u ${mongo_username} -p ${mongo_password} --authenticationDatabase ${mongo_autentication_database} `;
        }
        
        _command += database + " --eval " + "'db.getCollection(\"" + collection + "\").remove(" + JSON.stringify( query ) + ")'";
        
        console.log( _command );
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.upsertDocumentToMongo       = function ( timeout, database, collection, document_id, document ) {
        return self.ACTION.upsertStringDocumentToMongo( timeout, database, collection, document_id, JSON.stringify( document ) );
    };
    self.ACTION.updateDocumentToMongo       = function ( timeout, database, collection, document_id, document ) {
        return TI.SERVICE.DB.ACTION.updateStringDocumentToMongo( timeout, database, collection, document_id, '{ $set :' + JSON.stringify( document ) + '}' );
    };
    self.ACTION.upsertStringDocumentToMongo = function ( timeout, database, collection, document_id, document_string ) {
        var _key_to_find = { "_id": document_id };
        var _command     = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").update(" + JSON.stringify( _key_to_find ) + ", " + document_string + ", upsert=true)'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    self.ACTION.updateStringDocumentToMongo = function ( timeout, database, collection, document_id, document_string ) {
        var _key_to_find = { "_id": document_id };
        var _command     = "mongo " + database + " --eval " + "'db.getCollection(\"" + collection + "\").update(" + JSON.stringify( _key_to_find ) + ", " + document_string + ")'";
        
        var _success = function ( _status, data ) {
        
        };
        var _error   = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _success, _error );
        return 5000;
    };
    
    self.ACTION.insertManyIn        = function ( timeout, database_name, collection_name, element_to_insert ) {
        var _success       = function ( _status, data ) {
            console.log( "success", data );
        };
        var _error         = function ( e ) {
            console.log( "error", e );
        };
        let json_to_insert = JSON.stringify( element_to_insert );
        let command   = `mongo ${database_name} --eval 'db.getCollection("${collection_name}").insert(${json_to_insert})'`;
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, command, _success, _error );
    };
    self.ACTION.populateHiveAndList = function ( timeout, nb_to_generate, uuid_of_owner, owner_name ) {
        const _uuid = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.populateHiveAndList' );
        setTimeout( () => {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let list_hive_to_insert  = [];
            let list_share_to_insert = [];
            let list_list_to_insert  = [];
            let hive_name            = "";
            let share_name           = "";
            let list_name            = "";
            let share_list_name      = "";
            
            for ( let i = 0; i < nb_to_generate; i++ ) {
                hive_name       = "hive-" + owner_name + "-" + i;
                share_name      = "share-hive-" + owner_name + "-" + i;
                share_list_name = "share-list-" + owner_name + "-" + i;
                list_name       = "list-" + owner_name + "-" + i;
                
                list_hive_to_insert.push( _INTERNAL.getHiveTemplate( hive_name, uuid_of_owner ) );
                list_list_to_insert.push( _INTERNAL.getListTemplate( list_name, uuid_of_owner ) );
                
                list_share_to_insert.push( _INTERNAL.getShareTemplate( share_name, "hive", hive_name, uuid_of_owner, owner_name ) );
                list_share_to_insert.push( _INTERNAL.getShareTemplate( share_list_name, "list", list_name, uuid_of_owner, owner_name ) );
                
                if ( i % 100 === 0 ) {
                    self.ACTION.insertManyIn( 0, "shinken", "hive", list_hive_to_insert );
                    self.ACTION.insertManyIn( 0, "shinken", "list", list_list_to_insert );
                    self.ACTION.insertManyIn( 0, "shinken", "share", list_share_to_insert );
                    
                    list_hive_to_insert  = [];
                    list_share_to_insert = [];
                    list_list_to_insert  = [];
                }
            }
            if ( list_share_to_insert.length > 0 ) {
                self.ACTION.insertManyIn( 0, "shinken", "hive", list_hive_to_insert );
                self.ACTION.insertManyIn( 0, "shinken", "list", list_list_to_insert );
                self.ACTION.insertManyIn( 0, "shinken", "share", list_share_to_insert );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, 0 );
    };
    self.ACTION.insertSeveralShare  = function ( timeout, nb_to_generate, uuid_share_owner, name_share_owner, uuid_view, name_view, type_view ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.insertSeveralShare' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let list_share_to_insert = [];
            let share_name           = "";
            
            for ( let i = 0; i < nb_to_generate; i++ ) {
                share_name = name_view + "-" + i;
                
                list_share_to_insert.push( _TEMPLATE.getShareTemplate( share_name, type_view, name_view, uuid_view, uuid_share_owner, name_share_owner ) );
                
                //if ( i % 100 === 0 ) {
                //    self.ACTION.insertManyIn( 0, "shinken", "hive", list_hive_to_insert );
                //    self.ACTION.insertManyIn( 0, "shinken", "list", list_list_to_insert );
                //    self.ACTION.insertManyIn( 0, "shinken", "share", list_share_to_insert );
                //
                //    list_hive_to_insert  = [];
                //    list_share_to_insert = [];
                //    list_list_to_insert  = [];
                //}
            }
            if ( list_share_to_insert.length > 0 ) {
                //self.ACTION.insertManyIn( 0, "shinken", "hive", list_hive_to_insert );
                //self.ACTION.insertManyIn( 0, "shinken", "list", list_list_to_insert );
                self.ACTION.insertManyIn( 0, "shinken", "share", list_share_to_insert );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    
    //********************************************  INTERNAL   **************************************************//
    _INTERNAL.dropAllDatabases = function () {
        self.ACTION.dropDatabase( 0, "shinken" );
        self.ACTION.dropDatabase( 0, "synchronizer" );
        self.ACTION.dropDatabase( 0, "event_container" );
        self.ACTION.dropDatabase( 0, "webui" );
    };
    //********************************************  TEMPLATE  ****************************************//
    _TEMPLATE.getShareTemplate = function ( share_name, type_view, name_view, uuid_view, uuid_share_owner, name_share_owner ) {
        let uuid = SHINKEN.TOOLS.STRING.buildUUID();
        return {
            "_id"              : uuid,
            "uuid"             : uuid,
            "name"             : name_view,
            "type"             : "personal",
            "screenIsReference": true,
            "index"            : 0,
            "kind"             : 1,
            "screen"           : {
                "uuid": uuid_view,
                "type": type_view
            },
            "owner"            : {
                "uuid": uuid_share_owner,
                "name": name_share_owner
            }
        };
    };
    return self;
})
( TI.SERVICE.DB || {} );

