//__lib__ lib_common
"use strict";

COMPONENT.INPUT = {
    PARAM: {
        NAME: "input_name"
    }
};

COMPONENT.InterfaceInput           = function ( value ) {
    this.__class_name__ = 'COMPONENT.Input';
    // dom_element
    // current_value
    // original_value
    // placeholder
    // is_protected
    // is_resizable
    this.init( value );
};
COMPONENT.InterfaceInput.prototype = {
    init: function ( value ) {
        this.current_value = value || "";
    },
    //********************************************  SETTER GETTER   **************************************************//
    clickOnInput: function () {
    },
    //********************************************  SETTER GETTER   **************************************************//
    hasFocus             : function () {
        return DOM.Service.hasFocus( this.dom_element_input );
    },
    getDomValue          : function () {
        if ( this.dom_element_input ) {
            return this.dom_element_input.value;
        }
    },
    getValue             : function () {
        return this.current_value;
    },
    setValue             : function ( keep_cursor_pos ) {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        this.askComputeHeight();
        this.updateBroomButton();
    },
    setValueFromJs       : function ( to_set ) {
        this.current_value = to_set;
        this.computeNeedValidation();
        if ( this.dom_element_input ) {
            DOM.Service.setInputValue( this.dom_element_input, to_set );
            this.validateValueInput();
            this.updateView();
            this.doExtraAction();
        }
        this.updateBroomButton();
    },
    setValueFromInput    : function () {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        if ( this.need_validation ) {
            this.updateView();
        }
        this.doExtraAction();
        this.updateBroomButton();
    },
    setStatus            : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    getStatus            : function () {
        return this.status;
    },
    setIsProtected       : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element_input.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? "shinken-password" : this.type );
    },
    setDisabled          : function ( to_set ) {
        if ( to_set ) {
            this.dom_element_input.setAttribute( "readonly", '' );
        }
        else {
            this.dom_element_input.removeAttribute( "readonly", '' );
        }
    },
    setPlaceholder       : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || "";
        }
        to_set           = SHINKEN.TOOLS.STRING.unescape_xss( to_set );
        this.placeholder = to_set;
        if ( this.dom_element_input ) {
            this.dom_element_input.placeholder = this.placeholder;
        }
    },
    skipValidation       : function ( to_set ) {
        this.skip_validation = to_set;
    },
    hasBeenChanged       : function () {
        return this.getValue() !== this.original_value;
    },
    setNeedValidation    : function ( to_set, parent_name ) {
        this.need_validation = to_set;
    },
    setType__20241003    : function ( to_set ) {
        this.type = to_set;
    },
    setTimeoutAfterChange: function ( to_set ) {
        this.time_out_compute_after_change = to_set;
    },
    //********************************************  MESSAGES   **************************************************//
    setExtraTooltip  : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    addShinkenTooltip: function ( type, text ) {
        this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( text ) {
                text += "<br>";
            }
            text += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
        }
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', text );
        
        text && this.hasFocus() ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setMessage       : function ( message ) {
        var _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message ? message.buildMessage() : "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    //********************************************  UPDATE VIEW  **************************************************//
    updateBroomButton    : function () {
        if ( this.broom_button ) {
            DOM.Service.addOrRemoveClasses( this.broom_button.getDomElement(), !this.current_value, "shinken-hidden" );
        }
    },
    restoreCursorLocation: function ( location ) {
        this.dom_element_input.focus();
        if ( location ) {
            this.last_cursor_location = location;
        }
        if ( !this.last_cursor_location ) {
            this.last_cursor_location = this.current_value.length;
        }
        this.dom_element_input.selectionStart = this.last_cursor_location;
        this.dom_element_input.selectionEnd   = this.last_cursor_location;
    },
    saveCursorLocation   : function () {
        this.last_cursor_location = this.getCursorLocation();
    },
    getCursorLocation    : function () {
        return this.dom_element_input.selectionStart;
    },
    updateView           : function ( is_inherited, update, keep_cursor_pos, has_inheritance ) {
        var _to_write = this.current_value;
        if ( this.current_value === 'null' && has_inheritance ) {
            _to_write = '';
        }
        if ( keep_cursor_pos ) {
            this.saveCursorLocation();
        }
        
        if ( update ) {
            this.computeNeedValidation();
            DOM.Service.setInputValue( this.dom_element_input, is_inherited ? '' : _to_write );
        }
        else {
            this.current_value = this.getDomValue();
        }
        if ( this.dom_element_input.value ) {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        this.askComputeHeight();
        if ( keep_cursor_pos ) {
            this.restoreCursorLocation();
        }
        if ( this.dom_element_input_broom ) {
            DOM.Service.addOrRemoveClasses( this.dom_element_input_broom, !this.current_value, "shinken-hidden" );
        }
    },
    askComputeHeight     : function () {
        var self = this;
        if ( self.timeout_ask_compute_height ) {
            clearTimeout( self.timeout_ask_compute_height );
        }
        self.timeout_ask_compute_height = setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element_input ) && DOM.Service.getBoundingClientRect( self.dom_element_input, 'height' ) < 150 ) {
                self.dom_element_input.style.height = Math.min( 150, self.dom_element_input.scrollHeight + 6 ) + 'px';
            }
        }, 200 );
    },
    //********************************************  EVENT LISTENER   **************************************************//
    askComputeAfterChange   : function ( dom_element, parent, arg ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange( dom_element, parent, arg );
        }, self.time_out_compute_after_change );
    },
    finishActionBeforeReload: function () {
        if ( this.timeout_ask_compute_after_change ) {
            this.computeAfterChange();
        }
    },
    computeAfterChange      : function ( dom_element, parent, args ) {
        this.setValueFromInput();
        if ( !args ) {
            args = {};
        }
        
        args[ 'validation_done' ] = this.validateValueInput();
        args[ 'input_object' ]    = this;
        if ( parent && this.getValue() !== this.previous_value_before_compute ) {
            this.previous_value_before_compute = this.getValue();
            parent.doActionAfterChange( args );
        }
    },
    //********************************************  VALIDATION  **************************************************//
    validateValueInput         : function ( forced, ignore_focus ) {
        if ( !SHINKEN.TOOLS.SHINKEN_VALIDATOR ) {
            if ( this.validation_parameter ) {
                return this.validateValueInputNewFormat( forced, ignore_focus );
            }
            return false;
        }
        if ( this.need_validation || forced ) {
            var _validation_rules = this.getValidationRules( ignore_focus );
            var _validator;
            if ( _validation_rules ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( _validation_rules, SHINKEN.TOOLS.STRING.trimExtented( this.getValue() ) );
            }
            else if ( this.key_validation ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
            }
            else {
                return false;
            }
            this.setMessage( _validator );
            this.setNeedValidation( false );
            return true;
        }
        return false;
    },
    validateValueInputNewFormat: function () {
        if ( this.need_validation ) {
            var _to_set = COMPONENT.CONST.STATUS.NONE;
            if ( !SHINKEN_VALIDATION.Service.isValid( this.getValue(), this.validation_parameter ) ) {
                _to_set = COMPONENT.CONST.STATUS.ERROR;
            }
            this.setStatus( _to_set );
            this.setNeedValidation( false );
            return true;
        }
        return false;
    },
    addValidationRule          : function ( to_add, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                if ( !this.validation_rules ) {
                    this.validation_rules = [];
                }
                this.validation_rules.push( to_add );
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                if ( !this.validation_rules_not_focus ) {
                    this.validation_rules_not_focus = [];
                }
                this.validation_rules_not_focus.push( to_add );
                break;
        }
        
    },
    setValidationRules         : function ( to_set, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                this.validation_rules = to_set;
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                this.validation_rules_not_focus = to_set;
                break;
        }
    },
    computeNeedValidation      : function () {
        if ( this.skip_validation ) {
            return;
        }
        if ( this.need_validation ) {
            return;
        }
        if ( this.current_value !== this.getDomValue() ) {
            this.setNeedValidation( true );
        }
    },
    getValidationRules         : function ( ignore_focus ) {
        if ( !this.validation_rules && !this.validation_rules_not_focus ) {
            return null;
        }
        if ( ignore_focus ) {
            return this.validation_rules_not_focus || this.validation_rules;
        }
        if ( !this.hasFocus() && this.validation_rules_not_focus ) {
            return this.validation_rules_not_focus;
        }
        return this.validation_rules;
    },
    setValidationParameter     : function ( validation_parameter ) {
        this.validation_parameter = validation_parameter;
    },
    //********************************************  COMPUTE  *********************************************************//
    updateUrlWithValue: function () {
        var _value = this.current_value ? this.current_value : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings          : function ( input ) {
        if ( this.current_value === input.current_value ) {
            return;
        }
        this.simulateUserInteractionWriting( input.current_value );
    },
    simulateUserInteractionWriting: function ( value ) {
        this.setValueFromJs( value );
        this.time_out_compute_after_change = 0;
        DOM.Service.SimulateAction.keyUp( this.dom_element_input );
        this.time_out_compute_after_change = 200;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput, COMPONENT.Interface );

COMPONENT.InterfaceInput_V3           = function () {
};
COMPONENT.InterfaceInput_V3.prototype = {
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        return this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "property_value__set__by_data":
            case "property_value__set__by_js":
                this.setValueFromJs( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                break;
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "clean_input_value":
                        this.setValueFromJs( "" );
                        this.askComputeAfterChange( null, param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] );
                        break;
                }
                break;
        }
    },
    //********************************************  GETTER SETTER  **************************************************//
    getUUID          : function ( event_name, param ) {
        return this.getName();
    },
    addShinkenTooltip: function ( type, text ) {
        this.dom_element.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
        this.dom_element.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', text );
        text && this.hasFocus() ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
    },
    setMessage       : function ( message ) {
        let _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        const _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.setTooltipHtml( message.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.setTooltipHtml( message.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.setTooltipHtml( message ? message.buildMessageGeneric() : "", "" );
                break;
        }
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.getUUID(), _counter[ 0 ] );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.getUUID(), _counter[ 1 ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput_V3, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceInput_V3, COMPONENT.InterfaceInput );


COMPONENT.Input           = function ( dom_element, parent, no_auto_valid, extra_key_validation ) {
    this.__class_name__ = 'COMPONENT.Input';
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init: function ( dom_element, parent, extra_key_validation ) {
        this.initCounters( parent );
        this.dom_element = dom_element;
        
        if ( this.dom_element.classList.contains( 'shinken-input' ) || this.dom_element.classList.contains( 'shinken-input-key' ) || this.dom_element.classList.contains( 'shinken-input-search' ) ) {
            this.dom_element_input = dom_element;
        }
        else {
            this.dom_element_input = dom_element.querySelector( '.shinken-input' );
        }
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element_input.getAttribute( 'value' ) || this.dom_element_input.value;
        this.type                    = this.dom_element_input.getAttribute( 'type' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element_input.placeholder;
        this.placeholder             = this.placeholder_no_template;
        this.is_resizable            = this.dom_element_input.tagName === 'TEXTAREA';
        this.setNeedValidation( true );
        this.key_validation = {
            "prop_name"     : parent ? parent.getParentName() : '',
            "component_name": extra_key_validation || ''
        };
        this.initInterface();
        this.time_out_compute_after_change = 200;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, COMPONENT.InterfaceInput );


COMPONENT.InputFromData           = function ( value ) {
    this.__class_name__ = 'COMPONENT.InputFromData';
    this.init( value );
};
COMPONENT.InputFromData.prototype = {
    init: function ( value ) {
        this.event_name    = "";
        this.param_name    = "";
        this.current_value = value || "";
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element       = DOM.Service.createElement( "table", {
                class       : "shinken-input-table",
                onmouseenter: "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave: "SHINKEN_TOOLTIP.hideTooltip()"
            }
        );
        var tr                 = DOM.Service.createElement( "tr" );
        var td                 = DOM.Service.createElement( "td", { class: "shinken-input-container-cell" } );
        var div                = DOM.Service.createElement( "div", { class: "shinken-input-container" } );
        var _on_change         = "MANAGER.EventManager.onChangeOnInput(event, '" + this.event_name + "', '" + this.param_name + "')";
        this.dom_element_input = DOM.Service.createElement( "input", {
            class      : "shinken-input",
            type       : "text",
            value      : this.current_value,
            oncut      : _on_change,
            onpaste    : _on_change,
            onkeyup    : _on_change,
            onclick    : "MANAGER.EventManager.clickOnInput(event, '" + this.event_name + "', '" + this.param_name + "')",
            placeholder: this.placeholder
        } );
        
        DOM.Service.addElementTo( this.dom_element_input, div );
        DOM.Service.addElementTo( div, td );
        DOM.Service.addElementTo( td, tr );
        DOM.Service.addElementTo( tr, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromData, COMPONENT.InterfaceInput );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromData, SHINKEN.OBJECT.ShinkenObjectHtml );

COMPONENT.InputFromDataV2           = function ( value, property_name, parent_uuid ) {
    this.__class_name__ = 'COMPONENT.InputFromDataV2';
    this.initSpecific( value, property_name, parent_uuid );
};
COMPONENT.InputFromDataV2.prototype = {
    initSpecific: function ( value, property_name, parent_uuid ) {
        this.init( value );
        this.property_name = property_name;
        this.parent_uuid   = parent_uuid;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "table", {
                class       : "shinken-input-table",
                onmouseenter: "SHINKEN_TOOLTIP.showTooltip(this)",
                onmouseleave: "SHINKEN_TOOLTIP.hideTooltip()"
            }
        ) );
        const _tr        = this.addDomElement( DOM.Service.createElement( "tr" ) );
        const _td        = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-input-container-cell" } ), _tr );
        const _div       = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-input-container container-with-broom" } ), _td );
        const _on_change = "MANAGER.EventManagerV2.onChangeInput(event,'" + this.property_name + "', '" + this.parent_uuid + "')";
        
        this.dom_element_input   = DOM.Service.addElementTo( DOM.Service.createElement( "input", {
            class      : "shinken-input",
            type       : "text",
            value      : this.current_value,
            oncut      : _on_change,
            onpaste    : _on_change,
            onkeyup    : _on_change,
            onclick    : "MANAGER.EventManagerV2.onClickInput(event,'" + this.property_name + "')",
            placeholder: this.placeholder
        } ), _div );
        let _class_shinken_broom = "shinken-icon-delete-input shinkon shinkon-broom";
        if ( !this.current_value ) {
            _class_shinken_broom += " shinken-hidden";
        }
        this.dom_element_input_broom = DOM.Service.addElementTo( DOM.Service.createElement( "span", {
            class  : _class_shinken_broom,
            onclick: "MANAGER.EventManagerV2.clickButton(event,'clean_input_value','" + this.property_name + "','" + this.parent_uuid + "')"
        } ), _div );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromDataV2, COMPONENT.InterfaceInput );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromDataV2, SHINKEN.OBJECT.ShinkenObjectHtml );

COMPONENT.InputFromData_V3           = function ( name, value, params ) {
    this.__class_name__ = 'COMPONENT.InputFromData_V3';
    this.initSpecific( name, value, params );
};
COMPONENT.InputFromData_V3.prototype = {
    initSpecific     : function ( name, value, params ) {
        this.setTimeoutAfterChange( 200 );
        this.name = name;
        this.init( value );
        this.broom_button = new COMPONENT.ButtonFromData_V3( "clean_input_value", "<span class='shinken-icon-delete-input shinkon shinkon-broom'></span>" );
        this.addParamForEvents( COMPONENT.INPUT.PARAM.NAME, this.getName() );
        this.addParamsForEvents( params );
        this.class = "shinken-input-component-container shinken-layout-center-h-v shinken-input-has-broom";
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_message_validation":
                this.setMessage( param[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ] );
                return;
            case "clean_validation_error":
                this.setMessage();
                break;
            case "clean_filter":
            case "click_on_button_V3":
                this.setValueFromJs( "" );
                break;
            case "set_placeholder_input_V3":
                this.setPlaceholder( param[ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ] );
                break;
            case "onchange_in_input_V3":
                this.askComputeAfterChange( null, param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] );
                break;
        }
        return this.doActionAfterCommon( event_name, param );
    },
    //********************************************  GETTER SETTER  **************************************************//
    addParamForEvents: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        this.broom_button.addParamForEvents( key, value );
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        this.setValueFromJs( param[ "value" ] );
        this.setMessage( param[ "message" ] );
    },
    getDataForLastModification   : function ( params ) {
        return {
            "value"  : this.getValue(),
            "message": this.message || ""
        };
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: this.getClass() } ) );
        const _on_change = "MANAGER.EventManagerV2.onChangeInput_V3(event," + this.parseParamForEventsToHtml() + ")";
        
        this.dom_element_input = this.addDomElement( DOM.Service.createElement( "input", {
            class      : "shinken-input-V3",
            type       : this.type || "text",
            value      : this.current_value,
            oncut      : _on_change,
            onpaste    : _on_change,
            onkeyup    : _on_change,
            onclick    : "MANAGER.EventManagerV2.onClickInput_V3(event," + this.parseParamForEventsToHtml() + ")",
            placeholder: this.placeholder || ""
        } ) );
        if ( !this.current_value ) {
            this.broom_button.addClass( "shinken-hidden" );
        }
        this.broom_button.computeHtml();
        this.addDomElement( this.broom_button.getDomElement() );
        this.computeHtml_tooltip();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromData_V3, COMPONENT.InterfaceInput_V3 );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputFromData_V3, SHINKEN.OBJECT.ShinkenObjectHtml );
