//__lib__ lib_common
"use strict";
COMPONENT.InterfaceLabel           = function () {
    this.__class_name__ = 'COMPONENT.Label';
    this.init();
};
COMPONENT.InterfaceLabel.prototype = {
    init: function () {
    },
    //******************************************** LABEL *****************************************************//
    setLabel     : function ( to_set ) {
        this.label = to_set;
        if ( this.dom_element_label ) {
            this.dom_element_label.innerHTML = this.label;
        }
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_message_validation":
                this.setMessage( param[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ] );
                break;
        }
    },
    getValue     : function () {
        return "";
    },
    hasLabel     : function () {
        return !!this.label;
    },
    updateLabel  : function ( to_set ) {
        this.label = to_set;
        if ( this.dom_element ) {
            this.dom_element.innerHTML = this.label;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID   : function () {
        return this.label;
    },
    setStatus : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    setMessage: function ( message ) {
        let _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        const _counter = [0, 0];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.setTooltipHtml( message.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.setTooltipHtml( message.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.setTooltipHtml( message ? message.buildMessageGeneric() : "", "" );
                break;
        }
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.uuid, _counter[ 0 ] );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.uuid, _counter[ 1 ] );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, COMPONENT.Interface );


COMPONENT.Label           = function ( dom_element ) {
    // dom_element
    // label
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init: function ( dom_element ) {
        this.dom_element = dom_element;
        this.label       = dom_element.outerText;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Label, COMPONENT.InterfaceLabel );

COMPONENT.LabelFromData           = function ( label ) {
    this.__class_name__ = 'COMPONENT.LabelFromData';
    this.initSpecific( label );
};
COMPONENT.LabelFromData.prototype = {
    initSpecific: function ( label ) {
        this.label = label;
        this.initCounterCommon();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setValueFromJs: function ( to_set ) {
        this.label = to_set;
        if ( this.dom_element_label ) {
            this.dom_element_label.innerHTML = to_set;
        }
    },
    getValue      : function () {
        return this.label;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-label-container " + this.getClass() } ) );
        this.dom_element_label = this.addDomElement( DOM.Service.createElement( "span", { class: "shinken-label" }, this.label ), this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.LabelFromData, COMPONENT.InterfaceLabel );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.LabelFromData, SHINKEN.OBJECT.ShinkenObjectHtml );

COMPONENT.LabelFromData_ForViewOnly           = function ( label, value ) {
    this.__class_name__ = 'COMPONENT.LabelFromData_ForViewOnly';
    this.initSpecific( label, value );
};
COMPONENT.LabelFromData_ForViewOnly.prototype = {
    initSpecific: function ( label, value ) {
        this.label = label;
        this.value = value;
        this.initCounterCommon();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setValueFromJs: function ( value, label ) {
        this.value = value;
        this.label = label;
        if ( this.dom_element_label ) {
            this.dom_element_label.innerHTML = this.label;
        }
    },
    getValue      : function () {
        return this.value || this.label;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.LabelFromData_ForViewOnly, COMPONENT.LabelFromData );

