//__lib__ lib_common
"use strict";

COMPONENT.ListSelectElement           = function ( dom_element ) {
    // dom_element
    // element
    // is_selected
    // is_filtered
    this.init( dom_element );
};
COMPONENT.ListSelectElement.prototype = {
    init               : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered   = false;
        this.reason_to_set = [];
        this.element = new OBJECT.ElementList();
        if ( dom_element ) {
            this.dom_title   = dom_element.querySelector( '.' + 'shinken-option-title' );
            //TODO GREG A REGARDER Car l'appel est faire pour le multiselect alors qu'il ne semble pas nécessaire
            this.initElement();
            this.is_selected = dom_element.classList.contains( 'shinken-selected' );
        }
    },
    initElement        : function () {
        this.element.canHaveXssFailure = !!this.dom_element.dataset.canHaveXssFailure;
        this.element.setName( this.dom_element.dataset.keyName, this.dom_element );
        this.element.setLabel( this.dom_element.dataset.keyLabel );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setUUID( this.dom_element.dataset.uuid );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsHiddenForAdminSi( this.dom_element.dataset.isHiddenForAdminSi );
        this.element.setIsLock(this.dom_element.classList.contains("shinken-option-locked"));
        this.element.setErrorMessage( this.dom_element.dataset.errorMessage );
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set, extra_class, reason ) {
        if ( !reason ) {
            reason = "shinken-main-selector";
        }
        if ( _to_set ) {
            SHINKEN.TOOLS.ARRAY.addElement( this.reason_to_set, reason );
            this.dom_element.classList.add( 'shinken-selected' );
            if ( extra_class ) {
                DOM.Service.addClasses( this.dom_element, extra_class );
            }
        }
        else {
            SHINKEN.TOOLS.ARRAY.removeElement( this.reason_to_set, reason );
            if ( this.reason_to_set.length ) {
                return;
            }
            this.dom_element.classList.remove( 'shinken-selected' );
            this.dom_element.classList.remove( 'shinken-select-focused' );
            this.dom_element.classList.remove( 'shinken-select-no-events' );
            if ( extra_class ) {
                DOM.Service.removeClasses( this.dom_element, extra_class );
            }
        }
        this.is_selected = _to_set;
    },
    isSelected         : function () {
        return this.is_selected;
    },
    setIsFiltered      : function ( to_set ) {
        this.is_filtered = to_set;
        if ( to_set ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
    },
    //********************************************  FILTER   *********************************************************//
    setFilteringOption : function ( to_set ) {
        this.filtering_option = to_set;
    },
    doFilter           : function ( filter ) {
        //TODO TO CHANGE WE HAVE TO MAKE DIFF BETWEEN CONF AND VISU
        if ( MANAGER.__instance_element_distributor.current_user && !MANAGER.__instance_element_distributor.current_user.is_admin && this.element.is_hidden_for_admin_si ) {
            return false;
        }
        if ( this.element.state === COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN ) {
            return false;
        }
        if ( !filter ) {
            this.setIsFiltered( false );
            return this.element.type === OBJECT.CONST.ELEMENT_LIST.TYPE.USER;
        }
        if ( this.filtering_option === OBJECT.CONST.ELEMENT_LIST.FILTER_OPTION.IGNORED ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.setIsFiltered( false );
            return true;
        }
        else {
            this.setIsFiltered( true );
            return false;
        }
    },
    //********************************************  VIEW   *********************************************************//
    updateHtmlLabel    : function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};
