//__lib__ lib_common_V02_01
"use strict";

COMPONENT.RadioListGeneric           = function ( dom_element, parent ) {
    this.init( dom_element, parent );
};
COMPONENT.RadioListGeneric.prototype = {
    init: function ( dom_element, parent ) {
        this.dom_element = dom_element;
        this.initContents();
        this.initCounters( parent );
        this.initListContent( dom_element );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "value_changed":
                this.clickOnRadioBtn( param );
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setValueFromUser: function ( to_set ) {
        this.clickOnRadioBtn( to_set );
    },
    
    initListContent      : function ( dom_element ) {
        var _list_dom = dom_element.querySelectorAll( '.shinken-radio-element' );
        var _current;
        
        for ( var i = 0, _size = _list_dom.length; i < _size; i++ ) {
            _current = new COMPONENT.Generic( _list_dom[ i ] );
            _current.initCounters( this );
            _current.computeCounters();
            this.add( _current );
            if ( _current.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current;
            }
        }
        
    },
    clickOnRadioBtn      : function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getContentByUUID( value );
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    getValue             : function () {
        return this.active_button.getValue();
    },
    isDefaultOn          : function () {
        var _element = this.getContentByUUID( COMPONENT.CONST.BTN_NAME.DEFAULT );
        if ( _element ) {
            return _element.isOn();
        }
        return false;
    },
    setDefault           : function ( to_set ) {
        var _element = this.getContentByUUID( COMPONENT.CONST.BTN_NAME.DEFAULT );
        if ( _element ) {
            _element.setState( to_set );
        }
    },
    setDefaultKeyAndValue: function ( to_set ) {
        this.dom_element.setAttribute( "data-default-value", to_set );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric, COMPONENT.Interface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric, SHINKEN.OBJECT.ShinkenObjectContainer );

COMPONENT.RadioListGenericV2           = function () {
    this.init();
};
COMPONENT.RadioListGenericV2.prototype = {
    init           : function () {
        this.initContents();
        this.initListContent();
    },
    initListContent: function () {
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setValueFromUser: function ( to_set ) {
        this.clickOnRadioBtn( to_set );
    },
    clickOnRadioBtn : function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getContentByUUID( value );
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    getValue        : function () {
        return this.active_button.getValue();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setButtonVisibilityState: function ( button_name, to_set ) {
        this.getContentByUUID( button_name ).setVisibilityState( to_set );
    },
    setButtonTooltip        : function ( button_name, to_set, tooltip_type ) {
        this.getContentByUUID( button_name ).setTooltipHtml( to_set, tooltip_type );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGenericV2, COMPONENT.Interface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGenericV2, SHINKEN.OBJECT.ShinkenObjectContainer );

COMPONENT.RadioListGeneric_V3           = function () {
    this.init();
};
COMPONENT.RadioListGeneric_V3.prototype = {
    init           : function () {
        this.initContents();
    },
    initListContent: function () {
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setValueFromUser: function ( to_set ) {
        this.clickOnRadioBtn( to_set );
    },
    clickOnRadioBtn : function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getContentByUUID( value );
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    getValue        : function () {
        return this.active_button.getValue();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setButtonVisibilityState: function ( button_name, to_set ) {
        this.getContentByUUID( button_name ).setVisibilityState( to_set );
    },
    setButtonTooltip        : function ( button_name, to_set, tooltip_type ) {
        this.getContentByUUID( button_name ).setTooltipHtml( to_set, tooltip_type );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric_V3, COMPONENT.Interface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric_V3, SHINKEN.OBJECT.ShinkenObjectContainer );


COMPONENT.RadioListButtons           = function ( dom_element, parent ) {
    this.initSpecific( dom_element, parent );
};
COMPONENT.RadioListButtons.prototype = {
    initSpecific: function ( dom_element, parent ) {
        this.init();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    //********************************************  TO SORT  *****************************************************//
    initListContent: function ( dom_element ) {
        var _list_dom = dom_element.querySelectorAll( '.shinken-radio-btn' );
        var _current;
        
        for ( var i = 0, _size = _list_dom.length; i < _size; i++ ) {
            _current = new COMPONENT.Button( _list_dom[ i ] );
            _current.initCounters( this );
            _current.computeCounters();
            this.radio_buttons.push( _current );
            this.mapping_radio_button[ _current.getValue() ] = i;
            if ( _current.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current;
            }
        }
        
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListButtons, COMPONENT.RadioListGeneric );


COMPONENT.RadioListFromData           = function ( data_buttons, property_name ) {
    this.initSpecific( data_buttons, property_name );
};
COMPONENT.RadioListFromData.prototype = {
    initSpecific   : function ( data_buttons, property_name ) {
        this.property_name = property_name;
        this.data_buttons  = data_buttons;
        this.init();
    },
    initListContent: function () {
        var _current;
        for ( var i = 0, _size_i = this.data_buttons.length; i < _size_i; i++ ) {
            _current = this.add( new COMPONENT.RadioButtonFromData( this.data_buttons[ i ].value, this.data_buttons[ i ].label, this.property_name ) );
            if ( this.event_name ) {
                _current.computeHtml_setEventName( this.event_name );
            }
            if ( this.data_buttons[ i ].is_active ) {
                this.active_button = _current;
                this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-btn-radio-container" } );
        var _table       = DOM.Service.addElementTo( DOM.Service.createElement( "table", { class: "shinken-btn-group-table" } ), this.getDomElement() );
        var tr           = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            _current.computeHtml();
            DOM.Service.addElementTo( _current.getDomElement(), tr );
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListFromData, COMPONENT.RadioListGenericV2 );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListFromData, SHINKEN.OBJECT.ShinkenObjectHtml );


COMPONENT.RadioListFromData_V3           = function ( property_name ) {
    this.initSpecific( property_name );
};
COMPONENT.RadioListFromData_V3.prototype = {
    initSpecific   : function ( property_name ) {
        this.init();
        this.property_name = property_name;
        this.class         = "shinken-btn-radio-container-V3 shinken-layout-center-h-v";
        this.addParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME, property_name );
    },
    initListContent: function ( data_radios ) {
        var _current;
        for ( var i = 0, _size_i = data_radios.length; i < _size_i; i++ ) {
            _current = this.add( this.getChildConstructor( data_radios[ i ].value, data_radios[ i ].label, this.property_name ) );
            if ( this.event_name ) {
                _current.computeHtml_setEventName( this.event_name );
            }
            if ( data_radios[ i ].is_active ) {
                this.active_button = _current;
                this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor: function ( value, label, property_name ) {
        return new COMPONENT.RadioButtonFromData_V3( value, label, property_name );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: this.getClass() } ) );
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            _current.computeHtml();
            this.addDomElement( _current.getDomElement() );
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListFromData_V3, COMPONENT.RadioListGeneric_V3 );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListFromData_V3, SHINKEN.OBJECT.ShinkenObjectHtml );


COMPONENT.RadioListClassicFromData_V3           = function ( property_name, label, value ) {
    this.initSpecific( property_name );
};
COMPONENT.RadioListClassicFromData_V3.prototype = {
    initSpecific: COMPONENT.RadioListFromData_V3.prototype.initSpecific,
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor: function ( value, label, property_name ) {
        return new COMPONENT.RadioButtonClassicFromData_V3( value, label, property_name );
    }
    //********************************************  HTML  *****************************************************//
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListClassicFromData_V3, COMPONENT.RadioListFromData_V3 );
