//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.CONST.LAST_MODIFICATION = {
    INITIAL_STEP: -1,
    ACTION      : {
        CREATE               : "CREATE",
        ADD_CHILD            : "ADD_CHILD",
        REMOVE_CHILD         : "REMOVE_CHILD",
        DELETE               : "DELETE",
        MOVE                 : "MOVE",
        MESSAGES             : "MESSAGES",
        RESIZE               : "RESIZE",
        CONFIGURE            : "CONFIGURE",
        EDIT_PARAMS          : "EDIT_PARAMS",
        PARAM_MODIFICATION   : "PARAM_MODIFICATION",
        PROPERTY_MODIFICATION: "PROPERTY_MODIFICATION",
        ADD_NEW_LINK         : "ADD_NEW_LINK",
        REMOVE_NEW_LINK      : "REMOVE_NEW_LINK"
    },
    HISTORY     : {
        CREATE                               : "CREATE",
        DELETE                               : "DELETE",
        MOVE                                 : "MOVE",
        RESIZE                               : "RESIZE",
        FORM_DEFAULT_VALUE_MODIFICATION      : "FORM_DEFAULT_VALUE_MODIFICATION",
        FORM_WIDGET_VALUE_MODIFICATION       : "FORM_WIDGET_VALUE_MODIFICATION",
        FORM_EXTERNAL_ADD_LINK               : "FORM_EXTERNAL_ADD_LINK",
        FORM_EXTERNAL_REMOVE_LINK            : "FORM_EXTERNAL_REMOVE_LINK",
        FORM_EXTERNAL_LINK_VALUE_MODIFICATION: "FORM_EXTERNAL_LINK_VALUE_MODIFICATION"
    },
    PARAM       : {
        TYPE_MODIFICATION: "type_modification",
        TYPE             : "last_modification_type",
        OBJECT           : "last_modification_object",
        OBJECT_ELEMENT   : "last_modification_object_element",
        ARRAY_ELEMENT    : "last_modification_array_element",
        NUMBER           : "last_modification_number",
        PARENT_OBJECT    : "last_modification_parent_object",
        PARAM_FOR_EVENT  : "param_for_event"
    }
};

SHINKEN.OBJECT.EditableElementInterface           = function () {
    throw new TypeError( "Interface EditableElementInterface cant be constructed." );
};
SHINKEN.OBJECT.EditableElementInterface.prototype = {
    undoLastModification          : function ( modification_data ) {
        throw new TypeError( "Function undoLastModification from EditableElementInterface have to be surcharged" );
    },
    redoLastModification          : function ( modification_data ) {
        throw new TypeError( "Function redoLastModification from EditableElementInterface have to be surcharged" );
    },
    getLastModificationElement    : function () {
        throw new TypeError( "Function getLastModificationElement from EditableElementInterface have to be surcharged" );
    },
    setPreviousModificationElement: function ( params ) {
        this.previous_modication_data = this.getDataForLastModification( params );
    }
};


SHINKEN.OBJECT.EditableElementContainerInterface           = function () {
    throw new TypeError( "Interface EditableElementContainerInterface cant be constructed." );
};
SHINKEN.OBJECT.EditableElementContainerInterface.prototype = {
    getDataForLastModification: function () {
        var _to_return = { "contents": [], "mapping": SHINKEN.TOOLS.DICT.clone( this.mapping ) };
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _to_return[ "contents" ].push( this.contents[ i ].getDataForLastModification() );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.EditableElementContainerInterface, SHINKEN.OBJECT.EditableElementInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.EditableElementContainerInterface, SHINKEN.OBJECT.ShinkenObjectContainer );
