//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.LastModificationElement           = function ( type_modification, element_modified, previous, next ) {
    this.init( type_modification, element_modified, previous, next );
};
SHINKEN.OBJECT.LastModificationElement.prototype = {
    init: function ( type_modification, element_modified, previous, next ) {
        this.uuid              = SHINKEN.TOOLS.STRING.buildUUID();
        this.type_modification = type_modification;
        this.addParamsForEvents( element_modified.getParamForEvents() );
        this.setPrevious( previous );
        this.setNext( next );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getTypeModification: function () {
        return this.type_modification;
    },
    isValid            : function () {
        if ( this.previous && this.next ) {
            return !SHINKEN.TOOLS.DICT.isEquals( this.previous, this.next );
        }
        return this.previous !== this.next;
    },
    setPrevious        : function ( previous ) {
        this.previous = previous;
    },
    setNext            : function ( next ) {
        this.next = next;
    },
    setParam           : function ( param_name, to_set ) {
        this[ param_name ] = to_set;
    },
    getParam           : function ( param_name ) {
        return this[ param_name ];
    },
    getPrevious        : function () {
        return this.previous;
    },
    getNext            : function () {
        return this.next;
    },
    getNextOrPrevious  : function ( event_name ) {
        switch ( event_name ) {
            case "undo_last_modification":
                return this.getPrevious();
            case "redo_last_modification":
                return this.getNext();
        }
    },
    getUUID            : function () {
        return this.uuid;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LastModificationElement, SHINKEN.OBJECT.ShinkenObject );
