//__lib__ lib_common
//priority 100
"use strict";
SHINKEN_LIST.Filter           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.Filter.prototype = {
    init          : function () {
        this._is_active = false;
    },
    initComponents: function () {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component = new COMPONENT.Select( this.dom_element, this.type, false, this );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
            case COMPONENT.CONST.TYPE.INPUT_STRING_ARRAY:
                this.component = new COMPONENT.Input( this.dom_element.querySelector( ".shinken-input-table" ), this );
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.component = new COMPONENT.InputWithDropDown( this.dom_element, this, true );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS );
                this.component.addValidationRule( PROPERTY.CONST.VALIDATOR.TYPE.SELECT_INPUT_WITH_CONDITION_NOT_FOCUS, COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS );
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    setType          : function ( to_set ) {
        switch ( to_set ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                to_set = COMPONENT.CONST.TYPE.SINGLE_SELECT;
                break;
        }
        this.type = to_set;
    },
    getUUID          : function () {
        return this.getName();
    },
    isValid          : function () {
        return (this.name && this.type);
    },
    isSet            : function () {
        this._computeState();
        return this.isActive();
    },
    getParentName    : function () {
        return this.name;
    },
    getValue         : function () {
        return this.component ? this.component.getValue() : "";
    },
    getName          : function () {
        return this.name;
    },
    getFinalValue    : function () {
        return this.component.getFinalValue();
    },
    setActive        : function ( to_set ) {
        to_set = !!to_set;
        if ( to_set ) {
            this.dom_element.classList.add( 'shinken-active' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
        }
        this._is_active = to_set;
    },
    isActive         : function () {
        return !!this._is_active;
    },
    setValue         : function ( to_set ) {
        this.component.setValueFromJs( to_set );
    },
    getListElement   : function () {
        return this.component.getListElement();
    },
    getChildrenObject: function () {
        if ( !this.component ) {
            return [];
        }
        return [this.component];
    },
    getComponent     : function () {
        return this.component;
    },
    //********************************************  TEMP TO CHANGE  **************************************************//
    initWhenInputReady: function () {
        var self = this;
        setTimeout( function () {
            self.component.validateValueInput();
            self._computeState();
            DOM.Service.setDataSet( self.dom_element, 'inputStatus', self.component.getStatus() );
        }, 300 );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter          : function ( event_name, param ) {
        if ( this.component ) {
            this.component.doActionAfter( event_name, param );
        }
    },
    clickOnSelector        : function () {
        this.component.clickOnSelector();
    },
    clickOnItemSelector    : function ( key_name, dom_element, selector, event ) {
        this.component.clickOnItemSelector( '', key_name, event );
        this._computeState();
        this.hidePopup();
        
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component.computeTitle();
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                if ( CONTROLLER.List ) {
                    var forced = !(key_name !== '');
                    CONTROLLER.List.getFilterAndReload( forced );
                }
                break;
        }
    },
    doChangeFilterSelect   : function () {
        this.component.doChangeFilterSelect();
    },
    askComputeAfterChange  : function ( dom_element, parent, args ) {
        this.component.askComputeAfterChange( dom_element, parent || this, args );
    },
    doActionAfterChange    : function ( args ) {
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
            case COMPONENT.CONST.TYPE.LABEL:
                return;
        }
        this._computeState();
        if ( this.component ) {
            this.component.computeAfterChange();
            DOM.Service.setDataSet( this.dom_element, 'inputStatus', this.component.getStatus() );
        }
        switch ( args.controller_name ) {
            case CONTROLLER.CONST.LIST_ALL.NAME:
                CONTROLLER.List.updateCleanButtonStatus();
                break;
        }
    },
    clickChangeFilterSelect: function () {
        this.component.clickChangeFilterSelect();
    },
    clickOnInput           : function () {
        this.component.clickOnInput();
    },
    hidePopup              : function ( exception ) {
        if ( exception === this ) {
            return;
        }
        this.setNeedValidation( true );
        this.doActionAfterChange( {} );
        switch ( this.type ) {
            case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                this.component.hidePopup();
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT:
                break;
            case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                this.component.hidePopup();
                break;
        }
    },
    _computeState          : function () {
        var _value = this.getValue();
        if ( _value === SHINKEN_LIST.CONST.FILTER.ALL ) {
            _value = false;
        }
        this.setActive( !!_value );
    },
    validateValueInput     : function () {
        this.component.validateValueInput();
    },
    keydown                : function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.ENTER:
                if ( this.component.hasAutoSelect() ) {
                    event.stopPropagation();
                    event.preventDefault();
                    this.component.validSelectedOrFirstElement();
                }
                else {
                    this.component.finishActionBeforeReload();
                    CONTROLLER.List.getFilterAndReload( true );
                }
                break;
            default:
                this.component.keydown( event, key_code );
        }
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings: function ( list_filter ) {
        this.component.applySiblingSettings( list_filter.component );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filter, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Filter, SHINKEN.OBJECT.ShinkenObjectHtml );
