//__lib__ lib_common
//priority 100

"use strict";
SHINKEN_LIST.Set           = function ( name ) {
    this.init( name );
};
SHINKEN_LIST.Set.prototype = {
    init             : function ( name ) {
        this.name = name;
        this.initCommon();
    },
    initCommon       : function () {
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.SET_UUID, this.name );
        this.initCounterCommon();
        this.initPhase();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    askComputeAfterChange: function ( dom_element ) {
        this.filters.askComputeAfterChange( dom_element, this );
        this.lines.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange  : function ( args ) {
        var _type = args[ "type" ];
        switch ( _type ) {
            case "shinken-list-filter":
                this.applyFilter();
                break;
            case "shinken-hide-all-element":
                this.lines.hideAllLines();
                break;
            case "shinken-list-sorting":
                this.lines.applySorting( this.headers.getActiveSortingHeaders() );
                break;
        }
    },
    doActionAfter        : function ( event_name, param, param_2, param_3 ) {
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    },
    doActionAfterCommon  : function ( event_name, param, param_2, param_3 ) {
        this.doActionAfterSpecific( event_name, param, param_2, param_3 );
        switch ( event_name ) {
            case "compute_html_done":
                this.addCountersTargetDomElement( this.getDomElement() );
                break;
            case "onchange_in_input_V3":
                if ( param[ SHINKEN_LIST.CONST.PARAM.FILTERS_UUID ] ) {
                    this.filters.doActionAfter( event_name, param );
                }
                else {
                    this.lines.doActionAfter( event_name, param );
                }
                break;
            case "update_counter__with_children":
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
            case "click_on_button_V3":
            case "cancel_user_orders":
            case "clean_selected_element":
                if ( this.filters ) {
                    this.filters.doActionAfter( event_name, param );
                }
                this.lines.doActionAfter( event_name, param );
                break;
            case "ask_apply_filter":
                this.applyFilter();
                break;
            case "clean_filter":
                this.filters.doActionAfter( event_name, param );
                this.applyFilter();
                break;
        }
    },
    doActionAfterSpecific: function ( event_name, param, param_2, param_3 ) {
    },
    clickOnCheckboxInput : function ( name ) {
        if ( name === "shinken-all-elements" ) {
            this.selectAllData( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ? SHINKEN_LIST.CONST.SELECTION.STATUS.OFF : SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
            return;
        }
        this.lines.getContentByUUID( name ).toggleSelect();
        this.setSelectAllStatus();
    },
    clickOnCollapseButton: function ( uuid ) {
        if ( uuid === "shinken-all-elements" ) {
            this.collapseAllData( !this.is_all_data_collapsed );
            return;
        }
        this.lines.toggleCollapse( uuid );
        this.setIsCollapseAllData( this.lines.isAllActiveLineCollapsed() );
    },
    clickOnSelector      : function ( event, param ) {
        this._clickOnSelector( event, param );
    },
    _clickOnSelector     : function ( event, param ) {
        this.filters.clickOnSelector( event, param );
        this.lines.clickOnSelector( event, param );
    },
    clickOnInput         : function ( event ) {
        this.filters.clickOnInput( event );
        this.lines.clickOnInput( event );
    },
    clickOnItemSelector  : function ( event, parent_name, element ) {
        this._clickOnItemSelector( event, parent_name, element );
    },
    _clickOnItemSelector : function ( event, parent_name, element ) {
        this.filters.clickOnItemSelector( event, parent_name, element );
        this.lines.clickOnItemSelector( event, parent_name, element );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, "name", 20 );
        this.doActionAfterChange( { "type": _parent_dom_element.dataset.objectType } );
    },
    onClick              : function ( event ) {
        this._onClick( event );
    },
    _onClick             : function ( event ) {
        if ( this.lines ) {
            this.lines.onClick( event );
        }
        if ( this.headers ) {
            this.headers.onClick( event );
        }
        if ( this.filters ) {
            this.filters.onClick( event );
        }
    },
    //********************************************  ACTIONS  *****************************************************//
    applyFilter      : function ( params_filter_by_line ) {
        this.applyFilterCommon( params_filter_by_line );
        this.setSelectAllStatus();
    },
    applyFilterCommon: function ( params_filter_by_line ) {
        let active_filter = this.filters.getActiveFilters();
        if ( this.getDomElement() ) {
            DOM.Service.addOrRemoveClasses( this.getDomElement(), active_filter.length, "shinken-has-active-filter" );
        }
        this.lines.applyFilter( active_filter, params_filter_by_line );
        this.lines.doActionAfter( "apply_filter_done" );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setHeaders            : function ( to_set ) {
        this.headers = to_set;
        //this.headers.addParamsForEvents( this.getParamForEvents() );
    },
    setFilters            : function ( to_set ) {
        this.filters = to_set;
        this.filters.addParamsForEvents( this.getParamForEvents() );
    },
    setLines              : function ( to_set ) {
        if ( this.lines ) {
            this.lines.resetContents();
        }
        this.lines = to_set;
        this.lines.addParamsForEvents( this.getParamForEvents() );
        this.addSynchronizedPhase( this.lines.phase );
        to_set.setCountersParent( this );
        if ( this.getDomElement() && to_set.getDomElement() ) {
            var _content_list = this.getDomElement().querySelector( ".shinken-list-tbody" );
            if ( _content_list ) {
                DOM.Service.replaceElement( _content_list, to_set.getDomElement() );
            }
        }
    },
    getLines              : function () {
        return this.lines;
    },
    getHeaders            : function () {
        return this.headers;
    },
    initLines             : function ( to_set ) {
        this.lines = this.initLinesObjects();
        this.addSynchronizedPhase( this.lines.phase );
    },
    initLinesObjects      : function () {
        return new SHINKEN_LIST.Lines();
    },
    setIsCollapseAllData  : function ( to_set ) {
        this.is_all_data_collapsed = to_set;
        if ( this.is_all_data_collapsed ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
    },
    collapseAllData       : function ( to_set ) {
        this.setIsCollapseAllData( to_set );
        this.lines.setIsCollapseAllData( this.is_all_data_collapsed );
    },
    setSelectAllStatus    : function ( to_set ) {
        if ( to_set === undefined ) {
            to_set = this.lines.isAllActiveLineSelected() ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_all_data_selected = to_set;
        if ( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
            this.dom_element.classList.add( "shinken-selected" );
        }
        else {
            this.dom_element.classList.remove( "shinken-selected" );
        }
        if ( this.checkbox ) {
            this.checkbox.setChecked( this.is_all_data_selected );
        }
    },
    selectAllData         : function ( to_set ) {
        this.setSelectAllStatus( to_set );
        this.lines.setSelectAllData( this.is_all_data_selected );
    },
    getSelectedLines      : function () {
        return this.lines.getSelected();
    },
    getFirstSelectedLine  : function () {
        var _to_return = this.getSelectedLines();
        if ( _to_return.length ) {
            return _to_return[ 0 ];
        }
        return null;
    },
    getNotSelectedLines   : function () {
        return this.lines.getNotSelected();
    },
    setAllLinesDataSet    : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        return this.lines.setAllLinesDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
    },
    removeLineByUuid      : function ( uuid ) {
        this.lines.removeContent( uuid );
        this.updateHtml();
    },
    getLineByUUID         : function ( uuid ) {
        return this.lines.getContentByUUID( uuid );
    },
    getLineByCellValue    : function ( key_cell, value_cell ) {
        return this.lines.getContentByCellValue( key_cell, value_cell );
    },
    getSum                : function ( header_name ) {
        var _to_return = 0;
        var _lines     = this.lines.getNotFiltered();
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _to_return += parseInt( _lines[ i ].getCellValueForSum( header_name ) || 0 );
        }
        return _to_return;
    },
    getSumBy              : function ( header_name, header_value ) {
        var _to_return = {};
        var _lines     = this.lines.getNotFiltered();
        var _current;
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _current = _lines[ i ].getCellValue( header_name );
            if ( !_to_return[ _current ] ) {
                _to_return[ _current ] = 0;
            }
            _to_return[ _current ] += parseInt( _lines[ i ].getCellValue( header_value ) || 0 );
        }
        return _to_return;
    },
    toggleEditionMode     : function () {
        this.edit_mode = !this.edit_mode;
        this.selectAllData( this.edit_mode ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
    },
    updateAfterActionsDone: function ( data ) {
        this.setMessages();
        var to_return = this.lines.updateAfterActionsDone( data );
        this.addMessages( this.lines.getMessages() );
        return to_return;
    },
    //********************************************  OTHERS  *****************************************************//
    hidePopup           : function ( _filter ) {
        if ( this.headers ) {
            this.headers.hidePopup( _filter );
        }
        if ( this.filters ) {
            this.filters.hidePopup( _filter );
        }
        if ( this.lines ) {
            this.lines.hidePopup( _filter );
        }
    },
    updateHtml          : function () {
        DOM.Service.setDataSet( this.dom_element, "numberLines", this.lines.contents.length );
    },
    applySiblingSettings: function ( list_set ) {
        this.filters.applySiblingSettings( list_set.filters );
        this.lines.applySiblingSettings( list_set.lines );
    },
    //********************************************  EXPORT DATA  *****************************************************//
    getDataToExport: function () {
        var _to_return = [this.headers.getDataToExport()];
        return SHINKEN.TOOLS.ARRAY.concat( _to_return, this.lines.getDataToExport( this.headers ) );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function ( type ) {
        return this.lines.getDataToSave( type );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Set, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Set, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Set, SHINKEN.OBJECT.PhaseInterface );