//__lib__ lib_common

"use strict";
SHINKEN.OBJECT.ConfirmationPopup           = function () {
    this.init();
};
SHINKEN.OBJECT.ConfirmationPopup.prototype = {
    init: function () {
        this.dom_element           = null;
        this.dom_element_popup     = null;
        this.validate_button_label = "";
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    show: function () {
        this.dom_element.classList.remove( "shinken-hidden" );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
    },
    hide: function () {
        this.dom_element.classList.add( "shinken-hidden" );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
        this.reset();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setValidateButtonLabel: function ( to_set ) {
        this.validate_button_label = to_set;
        if ( this.validate_button ) {
            this.validate_button.innerHTML = to_set;
        }
    },
    setTitle              : function ( to_set ) {
        this.title = to_set;
        if ( this.dom_element_title ) {
            this.dom_element_title.innerHTML = to_set;
        }
    },
    setController         : function ( to_set ) {
        this.controller = to_set;
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, "controller", this.controller );
        }
    },
    setContent            : function ( to_set ) {
        this.content = to_set;
        if ( this.dom_element_content ) {
            DOM.Service.addElementToAfterEmpty( this.content, this.dom_element_content );
        }
    },
    reset                 : function () {
        DOM.Service.removeElement( this.dom_element );
        this.dom_element = null;
    },
    //********************************************  HTML  *****************************************************//
    computeHtmlDomElement: function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            "class"          : "shinken-parent-event-listener shinken-hidden",
            "id"             : "id-shinken-confirmation-popup-container",
            "data-controller": this.controller
        } ) );
        this.computeHtmlPopup();
        DOM.Service.addElementTo( this.dom_element, DOM.BodyService.getDomElement() );
    },
    computeHtmlPopup     : function () {
        this.dom_element_popup = this.addDomElement( DOM.Service.createElement( "div", { "class": "shinken-confirmation-popup" } ) );
        this.computeHtmlHeader();
        this.computeHtmlContent();
        this.computeHtmlFooter();
    },
    computeHtmlHeader    : function () {
        var _container               = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-header-confirmation-popup" } ), this.dom_element_popup );
        var _table                   = DOM.Service.addElementTo( DOM.Service.createElement( "table", { "class": "shinken-width-100" } ), _container );
        var _tr                      = DOM.Service.addElementTo( DOM.Service.createElement( "tr", { "class": "shinken-header-confirmation-popup" } ), _table );
        this.dom_element_title       = DOM.Service.addElementTo( DOM.Service.createElement( "td", { "class": "shinken-title-confirmation-popup" }, this.title ), _tr );
        var _onclick_attribute_close = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-confirmation-popup")';
        DOM.Service.addElementTo( DOM.Service.createElement( "td", { "class": "shinken-confirmation-popup-cell-close", "onclick": _onclick_attribute_close }, "<span class='shinkon-times'></span>" ), _tr );
    },
    computeHtmlContent   : function () {
        this.dom_element_content = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-content-confirmation-popup" } ), this.dom_element_popup );
        DOM.Service.addElementTo( this.content, this.dom_element_content );
    },
    computeHtmlFooter    : function () {
        this.validate_button_label = this.validate_button_label || _( "confirmation_popup.validate_button", [DICTIONARY_COMMON_UI] );
        var _container             = DOM.Service.createElement( "div", { "class": "shinken-footer-confirmation-popup shinken-footer-confirmation-popup shinken-user-select-none" } );
        var _table                 = DOM.Service.createElement( "table", { "class": "shinken-footer-table-confirmation-popup" } );
        var _tr                    = DOM.Service.createElement( "tr", {} );
        var _td                    = DOM.Service.createElement( "td", {} );
        var _table_buttons         = DOM.Service.createElement( "table", { "class": "shinken-action-button-table-confirmation-popup" } );
        var _tr_buttons            = DOM.Service.createElement( "tr", {} );
        var _td_validate           = DOM.Service.createElement( "td", {} );
        this.validate_button       = DOM.Service.createElement( "div", {
            "class"  : "shinken-action-button-confirmation-popup shinken-validate-button",
            "onclick": "MANAGER.EventManager.clickOnButton(event, 'click-on-validate-confirmation-popup')"
        }, this.validate_button_label );
        var _td_cancel             = DOM.Service.createElement( "td", {} );
        var _onclick_cancel        = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-confirmation-popup")';
        var _cancel_button         = DOM.Service.createElement( "div", {
            "class"  : "shinken-action-button-confirmation-popup shinken-cancel-button",
            "onclick": _onclick_cancel
        }, _( "confirmation_popup.cancel_button", [DICTIONARY_COMMON_UI] ) );
        
        
        DOM.Service.addElementTo( this.validate_button, _td_validate );
        DOM.Service.addElementTo( _td_validate, _tr_buttons );
        
        DOM.Service.addElementTo( _cancel_button, _td_cancel );
        DOM.Service.addElementTo( _td_cancel, _tr_buttons );
        
        DOM.Service.addElementTo( _tr_buttons, _table_buttons );
        DOM.Service.addElementTo( _table_buttons, _td );
        DOM.Service.addElementTo( _td, _tr );
        DOM.Service.addElementTo( _tr, _table );
        DOM.Service.addElementTo( _table, _container );
        DOM.Service.addElementTo( _container, this.dom_element_popup );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ConfirmationPopup, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ConfirmationPopup, SHINKEN.OBJECT.ShinkenObjectHtml );

SHINKEN.OBJECT.CONFIRMATIONPOPUP = {
    PARAM: {
        NAME                   : "confirmation_pop_up_name",
        EVENT_NAME_CONFIRMATION: "event_name_after_apply_confirmation_pop_up"
    }
};

SHINKEN.OBJECT.ConfirmationPopup_V3           = function () {
    this.init();
};
SHINKEN.OBJECT.ConfirmationPopup_V3.prototype = {
    init: function ( name, event_name_validation_popup ) {
        this.uuid = "id-shinken-confirmation-popup-container";
        this.name = name;
        this.addParamForEvents( SHINKEN.OBJECT.CONFIRMATIONPOPUP.PARAM.NAME, this.uuid );
        this.addParamForEvents( SHINKEN.OBJECT.CONFIRMATIONPOPUP.PARAM.EVENT_NAME_CONFIRMATION, event_name_validation_popup );
        this.dom_element       = null;
        this.dom_element_popup = null;
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
        this.button_validate = new COMPONENT.ButtonFromData_V3( "valid_popup__20240904", _( "confirmation_popup.validate_button", [DICTIONARY_COMMON_UI] ) );
        this.button_cancel   = new COMPONENT.ButtonFromData_V3( "cancel_popup__20240904", _( "confirmation_popup.cancel_button", [DICTIONARY_COMMON_UI] ) );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "close_popup__20240904":
                    case "cancel_popup__20240904":
                        this.hide();
                        break;
                    case "valid_popup__20240904":
                        this.controller.doActionAfter( param[ SHINKEN.OBJECT.CONFIRMATIONPOPUP.PARAM.EVENT_NAME_CONFIRMATION ], param );
                        break;
                }
                break;
        }
    },
    show         : function () {
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
    },
    hide         : function () {
        this.reset();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    reset         : function ( name, event_name_validation_popup ) {
        DOM.Service.removeElement( this.dom_element );
        this.init( name, event_name_validation_popup );
    },
    setController : function ( to_set ) {
        this.controller = to_set;
        if ( this.getDomElement() ) {
            DOM.Service.setDataSet( this.getDomElement(), "controller", this.controller.controller_name );
        }
    },
    setValidButton: function ( to_set ) {
        this.button_validate = to_set;
    },
    isVisible     : function () {
        return this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
    },
    //********************************************  HTML  *****************************************************//
    computeHtml      : function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            "class"          : "shinken-parent-event-listener",
            "id"             : this.uuid,
            "data-name"      : this.name,
            "data-controller": this.controller.controller_name
        } ) );
        this.setPhaseDomElement( this.getDomElement() );
        this.dom_element_popup = this.addDomElement( DOM.Service.createElement( "div", {
            "class"                 : "shinken-confirmation-popup shinken-draggable",
            "data-drag-is-in-screen": "true"
        } ) );
        this.computeHtmlHeader();
        this.computeHtmlContent();
        this.computeHtmlFooter();
        DOM.Service.addElementTo( this.dom_element, DOM.BodyService.getDomElement() );
    },
    computeHtmlHeader: function () {
        var _container         = DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            "class": "shinken-header-confirmation-popup shinken-layout-center-h-v shinken-layout-justify-between", onmousedown: "MANAGER.DragNDropManager.dragStartSingle(event)"
        } ), this.dom_element_popup );
        this.dom_element_title = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-title-confirmation-popup shinken-user-select-none" }, this.title ), _container );
        let button_close       = new COMPONENT.ButtonFromData_V3( "close_popup__20240904", "<span class='shinkon-times'></span>" );
        button_close.addParamsForEvents( this.getParamForEvents() );
        button_close.computeHtml();
        DOM.Service.addElementTo( button_close.getDomElement(), _container );
    },
    computeHtmlFooter: function () {
        var footer = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-footer-confirmation-popup shinken-layout-right-h-center-v shinken-user-select-none" } ), this.dom_element_popup );
        this.button_validate.addParamsForEvents( this.getParamForEvents() );
        this.button_validate.computeHtml();
        this.button_cancel.addParamsForEvents( this.getParamForEvents() );
        this.button_cancel.computeHtml();
        DOM.Service.addElementTo( this.button_validate.getDomElement(), footer );
        DOM.Service.addElementTo( this.button_cancel.getDomElement(), footer );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ConfirmationPopup_V3, SHINKEN.OBJECT.ConfirmationPopup );

SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance = function () {
    if ( !MANAGER.__instance_confirmation_popup_V3 ) {
        MANAGER.__instance_confirmation_popup_V3 = new SHINKEN.OBJECT.ConfirmationPopup_V3();
    }
    return MANAGER.__instance_confirmation_popup_V3;
};

MANAGER.__instance_confirmation_popup = new SHINKEN.OBJECT.ConfirmationPopup();
