//__lib__ lib_common
//priority 12
"use strict";
SHINKEN.OBJECT.JSON_EDITOR = {
    SHINKEN_JSON_UUID_ANCHOR: "__SHINKEN_JSON_UUID_ANCHOR_ANCHOR__",
    JSON_FORMAT_INFORMATION : "__JSON_FORMAT_INFORMATION__",
    JSON_INDEX_ALREADY_WRITE: "__JSON_INDEX_ALREADY_WRITE__",
    CLASS_ERROR             : "shinken-json-error",
    PARAM                   : {
        JSON_OBJECT: "json_object"
    },
    FORMAT_DATA             : {
        OBJECT                   : "object",
        VALUE_ONLY               : "value_only",
        VALUE_AND_DEFAULT        : "value_and_default",
        VALUE_AND_DEFAULT_AND_CFG: "value_and_default_and_cfg",
        VALUE_AND_FORCE_DEFAULT  : "value_and_force_default"
    },
    PARAM_EVENT             : {
        JSON_FORM_OBJECT: "json_form__object"
    }
};


SHINKEN.OBJECT.JsonEditor           = function ( dom_element, json, default_tag ) {
    this.__class_name__ = 'SHINKEN.OBJECT.JsonEditor';
    this.dom_element    = dom_element;
    this.json           = json;
    this.content        = null;
    this.default_tag    = default_tag;
    this.init();
};
SHINKEN.OBJECT.JsonEditor.prototype = {
    init: function () {
        this.content = DOM.Service.createElement( "span", {}, this.parseToHtml( null, this.json ) );
        this.computeErrorContent();
    },
    
    //********************************************  GET JSON  **************************************************//
    doActionAfter                : function ( event_name, param ) {
        switch ( event_name ) {
            case "change_default_value_to_value":
                this.changeDefaultValueToValue( param.data_to_change_default_value, param.default_grid_value, param.widget_type );
                break;
        }
    },
    getCurrentContent            : function () {
        return this.dom_element.innerText;
    },
    getCurrentElementOfJsonEditor: function () {
        let element;
        const selection = window.getSelection();
        if ( selection.rangeCount > 0 ) {
            const range        = selection.getRangeAt( 0 );
            // Trouver l'élément parent dans lequel le curseur est situé
            let currentElement = range.startContainer;
            while ( currentElement && currentElement.nodeType === Node.TEXT_NODE ) {
                currentElement = currentElement.parentNode;
            }
            
            element = currentElement;
        }
        return element;
    },
    //********************************************  COMPUTE   **************************************************//
    computeErrorContent: function () {
        this.data_with_error  = {};
        const _error_contents = this.content.querySelectorAll( "." + SHINKEN.OBJECT.JSON_EDITOR.CLASS_ERROR );
        for ( let i = 0, _size_i = _error_contents.length; i < _size_i; i++ ) {
            if ( _error_contents[ i ].dataset.jsonUuidPart ) {
                this.data_with_error[ _error_contents[ i ].dataset.jsonUuidPart ] = _error_contents[ i ].innerText;
            }
        }
    },
    //********************************************  COMPUTE HTML  **************************************************//
    parseToHtml                         : function ( key, to_parse ) {
        let _to_return = '';
        if ( to_parse.__class_name__ === "SHINKEN.OBJECT.Param" ) {
            let _value = to_parse.getUserValue() === undefined ? "" : to_parse.getUserValue();
            
            if ( typeof _value === 'string' ) {
                return this.parseStringToHtml( key, _value, to_parse );
            }
            else if ( typeof _value === 'number' ) {
                return this.parseNumberToHtml( key, _value, to_parse );
            }
            else if ( typeof _value === 'boolean' ) {
                return this.parseBooleanToHtml( key, _value, to_parse );
            }
            else if ( _value instanceof Array ) {
                return this.parseArrayToHtml( key, _value, to_parse );
            }
            return this.parseObjectToHtml( key, _value, to_parse );
        }
        else if ( to_parse instanceof Array ) {
            _to_return += this.parseArrayToHtml( key, to_parse );
        }
        else if ( typeof to_parse === 'object' ) {
            _to_return += this.parseObjectToHtml( key, to_parse );
        }
        else if ( typeof to_parse === 'string' ) {
            return this.parseStringToHtml( key, to_parse );
        }
        else if ( typeof to_parse === 'number' ) {
            return this.parseNumberToHtml( key, to_parse );
        }
        else if ( typeof to_parse === 'boolean' ) {
            return this.parseBooleanToHtml( key, to_parse );
        }
        else {
            _to_return += '{}';
        }
        return _to_return;
    },
    parseObjectToHtml                   : function ( key, to_parse, object_with_json_information ) {
        if ( to_parse.json_list_content ) {
            return this.parseArrayToHtml( key, to_parse.json_list_content, to_parse );
        }
        let uuid_of_element = "";
        if ( to_parse[ SHINKEN.OBJECT.JSON_EDITOR.SHINKEN_JSON_UUID_ANCHOR ] ) {
            uuid_of_element = ' data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JSON_EDITOR.SHINKEN_JSON_UUID_ANCHOR ][ 0 ] + '"';
        }
        delete to_parse[ SHINKEN.OBJECT.JSON_EDITOR.SHINKEN_JSON_UUID_ANCHOR ];
        let _to_return = '<span ' + uuid_of_element + ' class="' + this.parseJsonTagToClassCss( key, object_with_json_information ) + '" ' + this.parseJsonTagToAttribute( key, object_with_json_information ) + '>{';
        let _keys      = Object.keys( to_parse );
        if ( _keys.length ) {
            _to_return += this.buildUlEntry( key, to_parse );
            let _current_key;
            _keys = Object.keys( to_parse ); //TO KEEP THERE BECAUSE THE KEYS CAN CHANGE
            for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                _to_return += this.buildLiEntry( key, to_parse );
                _to_return += this.buildKeyEntry( _current_key );
                _to_return += this.parseToHtml( _current_key, to_parse[ _keys[ i ] ] );
                if ( i < _keys.length - 1 ) {
                    _to_return += ",";
                }
                _to_return += "</div></li>";
            }
            _to_return += "</ul>";
        }
        _to_return += "}</span>";
        return _to_return;
    },
    parseArrayToHtmlWithListKeys        : function ( to_parse, object_with_json_information ) {
        let _to_return = "";
        for ( let i = 0, _size_i = object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].with_list_key.length; i < _size_i; i++ ) {
            _to_return += "<div>";
            _to_return += this.buildDivEntry( i, object_with_json_information );
            const _current_list_keys = object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].contents[ object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].with_list_key[ i ] ].list_keys;
            if ( !_current_list_keys ) {
                continue;
            }
            for ( let j = 0, _size_j = _current_list_keys.length; j < _size_j; j++ ) {
                _to_return += this.parseArrayToHtmlWithListKeys_forKey( _current_list_keys[ j ], to_parse );
            }
            _to_return += "</div></div>";
        }
        return _to_return;
    },
    parseArrayToHtmlWithListKeys_forKey : function ( key, to_parse ) {
        if ( to_parse[ key ][ SHINKEN.OBJECT.JSON_EDITOR.JSON_INDEX_ALREADY_WRITE ] ) {
            return "";
        }
        let _to_return = this.buildLiEntry( key );
        _to_return += this.parseToHtml( key, to_parse[ key ] );
        if ( typeof to_parse[ key ] === "object" ) {
            to_parse[ key ][ SHINKEN.OBJECT.JSON_EDITOR.JSON_INDEX_ALREADY_WRITE ] = true;
        }
        if ( !this.isLastIndexArrayDisplayed( to_parse ) ) {
            _to_return += ",";
        }
        _to_return += "</div></li>";
        return _to_return;
    },
    isLastIndexArrayDisplayed           : function ( array ) {
        for ( let i = 0, _size_i = array.length; i < _size_i; i++ ) {
            if ( !array[ i ][ SHINKEN.OBJECT.JSON_EDITOR.JSON_INDEX_ALREADY_WRITE ] ) {
                return false;
            }
        }
        return true;
    },
    parseObjectToHtmlWithListKeys       : function ( key, to_parse ) {
        let _to_return = "";
        for ( let i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].with_list_key.length; i < _size_i; i++ ) {
            _to_return += "<div>";
            _to_return += this.buildDivEntry( to_parse, i );
            const _current_list_keys = to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].contents[ to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].with_list_key[ i ] ].list_keys;
            if ( !_current_list_keys ) {
                continue;
            }
            for ( let j = 0, _size_j = _current_list_keys.length; j < _size_j; j++ ) {
                _to_return += this.parseObjectToHtmlWithListKeys_forKey( _current_list_keys[ j ], to_parse );
            }
            _to_return += "</div></div>";
        }
        return _to_return;
    },
    parseObjectToHtmlWithListKeys_forKey: function ( key, to_parse ) {
        if ( to_parse[ key ] === undefined ) {
            return ""; //PATCH if a key was already used, it is not anymore available (deleted)
        }
        let _to_return = this.buildLiEntry( key );
        _to_return += '<span class="k">"' + SHINKEN.TOOLS.STRING.cleanXss( key ) + '"</span> : ';
        _to_return += this.parseToHtml( key, to_parse[ key ] );
        delete to_parse[ key ];
        if ( Object.keys( to_parse ).length > 1 ) { // AT THIS MOMENT THERE IS AT LEAST THE PROPERTY JSON_FORMAT_INFORMATION
            _to_return += ",";
        }
        _to_return += "</div></li>";
        return _to_return;
    },
    parseArrayToHtml                    : function ( key, to_parse, object_with_json_information ) {
        let uuid_of_element = "";
        if ( object_with_json_information && object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.SHINKEN_JSON_UUID_ANCHOR ] ) {
            uuid_of_element = ' data-json-uuid-part="' + object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.SHINKEN_JSON_UUID_ANCHOR ][ 0 ] + '"';
            delete object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.SHINKEN_JSON_UUID_ANCHOR ];
        }
        let _to_return = '<span ' + uuid_of_element + 'class="' + this.parseJsonTagToClassCss( key, to_parse ) + '" ' + this.parseJsonTagToAttribute( key, to_parse ) + '>[';
        if ( object_with_json_information && object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ] ) {
            _to_return = '<span class="' + this.parseJsonTagToClassCss( key, object_with_json_information ) + '" ' + this.parseJsonTagToAttribute( key, object_with_json_information ) + '>[';
        }
        if ( to_parse.length ) {
            _to_return += "<ol class='A'>";
            if ( object_with_json_information && object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ] && object_with_json_information[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].with_list_key.length ) {
                _to_return += this.parseArrayToHtmlWithListKeys( to_parse, object_with_json_information );
            }
            for ( let i = 0, _size_i = to_parse.length; i < _size_i; i++ ) {
                _to_return += this.parseArrayToHtmlWithListKeys_forKey( i, to_parse );
            }
            _to_return += "</ol>";
        }
        _to_return += ']</span>';
        return _to_return;
    },
    parseStringToHtml                   : function ( key, string, to_parse ) {
        if ( string === this.default_tag && !(to_parse && to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ]) ) {
            return '<span class="X ' + this.parseJsonTagToClassCss( key, to_parse ) + '" data-dft-val="' + this.default_tag + '" ' + this.parseJsonTagToAttribute( key, to_parse ) + '>"' + this.default_tag + '"</span>';
        }
        const string_escape = SHINKEN.TOOLS.STRING.cleanXss( string );
        return '<span class="' + this.parseJsonTagToClassCss( key, to_parse ) + '" ' + this.parseJsonTagToAttribute( key, to_parse ) + '>"' + string_escape + '"</span>';
    },
    parseBooleanToHtml                  : function ( key, boolean, to_parse ) {
        return this.parseNumberToHtml( key, boolean, to_parse );
    },
    parseNumberToHtml                   : function ( key, number, to_parse ) {
        return '<span class="' + this.parseJsonTagToClassCss( key, to_parse ) + '" ' + this.parseJsonTagToAttribute( key, to_parse ) + '>' + number + '</span>';
    },
    parseJsonTagToClassCss              : function ( key, to_parse, index ) {
        let _to_return = "";
        if ( to_parse ) {
            if ( this.isEditableKeyElement( key ) ) {
                _to_return = "sk-json-edit-val";
            }
        }
        if ( to_parse && to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ] ) {
            for ( let i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].contents.length; i < _size_i; i++ ) {
                if ( index !== undefined && index !== i ) {
                    continue;
                }
                _to_return += " " + (to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].contents[ i ].class || "");
            }
        }
        return _to_return;
    },
    parseJsonTagToAttribute             : function ( key, to_parse, index ) {
        let _to_return = "";
        if ( to_parse ) {
            if ( this.isEditableKeyElement( key ) ) {
                _to_return = 'data-key="' + key + '"';
            }
        }
        if ( to_parse && to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ] ) {
            let _tooltip = "";
            for ( let i = 0, _size_i = to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].contents.length; i < _size_i; i++ ) {
                if ( index !== undefined && index !== i ) {
                    continue;
                }
                _to_return += ' data-json-uuid-part="' + to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].contents[ i ].uuid + '"';
                _tooltip += to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].contents[ i ].tooltip;
            }
            if ( _tooltip ) {
                _to_return += ' onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-type="shinken-warning" shi-tip-html="' + SHINKEN.TOOLS.STRING.cleanXssForTooltipWithUserData( _tooltip ) + '"';
            }
        }
        return _to_return;
    },
    isEditableKeyElement                : function ( key ) {
        return false;
    },
    isLabelOfEditableKey                : function () {
        return false;
    },
    //********************************************  PART HTML  **************************************************//
    buildUlEntry : function ( key, to_parse ) {
        let _to_return = "";
        if ( to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ] ) {
            if ( to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ].with_list_key.length ) {
                _to_return += '<ul class="D">';
                _to_return += this.parseObjectToHtmlWithListKeys( key, to_parse );
            }
            else {
                _to_return += '<ul class="D ' + this.parseJsonTagToClassCss( key, to_parse ) + '" ' + this.parseJsonTagToAttribute( key, to_parse ) + '>';
            }
            delete to_parse[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ];
        }
        else {
            _to_return += '<ul class="D">';
        }
        return _to_return;
    },
    buildKeyEntry: function ( key ) {
        if ( this.isLabelOfEditableKey( key ) ) {
            return '<span data-label-key="' + key + '" class="k">"' + SHINKEN.TOOLS.STRING.cleanXss( key ) + '"</span> : ';
        }
        return '<span class="k">"' + SHINKEN.TOOLS.STRING.cleanXss( key ) + '"</span> : ';
    },
    buildLiEntry : function ( key, to_parse ) {
        return '<li><div class="' + this.parseJsonTagToClassCss( key, to_parse ) + '" ' + this.parseJsonTagToAttribute( key, to_parse ) + '>';
    },
    buildDivEntry: function ( to_parse, index ) {
        return '<div class="z' + this.parseJsonTagToClassCss( '', to_parse, index ) + '" ' + this.parseJsonTagToAttribute( '    ', to_parse, index ) + '>';
    },
    //********************************************  VIEW   **************************************************//
    updateHtml            : function () {
        DOM.Service.addElementToAfterEmpty( this.content, this.dom_element );
        this.dom_element.classList.add( "shinken-json-editor-container" );
        this.dom_element.setAttribute( "contenteditable", "true" );
    },
    cleanHtmlAfterEdition : function () {
        this.updateDefaultValueHtml();
        this.removeErrorAfterUpdate();
    },
    updateDefaultValueHtml: function () {
        const _default_value_doms = this.dom_element.querySelectorAll( "[data-dft-val]" );
        for ( let i = 0, _size_i = _default_value_doms.length; i < _size_i; i++ ) {
            DOM.Service.addOrRemoveClasses( _default_value_doms[ i ], _default_value_doms[ i ].innerText === '"' + _default_value_doms[ i ].dataset.dftVal + '"', "X" );
        }
    },
    removeErrorAfterUpdate: function () {
        const _keys                         = Object.keys( this.data_with_error );
        const uuid_error_modified_for_cells = [];
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            const _current_key = _keys[ i ];
            const _current_dom = this.dom_element.querySelector( '.' + SHINKEN.OBJECT.JSON_EDITOR.CLASS_ERROR + '[data-json-uuid-part="' + _current_key + '"]' );
            if ( _current_dom && !this._is_same_text( _current_dom.innerText, this.data_with_error[ _current_key ] ) ) {
                _current_dom.classList.remove( SHINKEN.OBJECT.JSON_EDITOR.CLASS_ERROR );
                DOM.Service.removeTooltip( _current_dom );
                delete this.data_with_error[ _current_key ];
                let parent_for_cell = DOM.Service.findParentElementWithDataSet( _current_dom.parentElement, 'jsonUuidPart', 50 );
                if ( parent_for_cell ) {
                    uuid_error_modified_for_cells.push( parent_for_cell.getAttribute( 'data-json-uuid-part' ) );
                }
            }
        }
        //this.getController().doActionAfter( "remove_position_errors_of_cells_with_uuid", { uuid_list: uuid_error_modified_for_cells } );
    },
    _is_same_text         : function ( text_1, text_2 ) {
        return SHINKEN.TOOLS.STRING.replaceAll( text_1, "\n", "" ) === SHINKEN.TOOLS.STRING.replaceAll( text_2, "\n", "" );
    },
    getController         : function () {
        return CONTROLLER.CommonUI;
    },
    //*************************************************** UPDATE JSON VALUE ***********************************************
    changeDefaultValueToValue            : function ( array_data_to_change, default_grid_values, widget_type ) {
        array_data_to_change.forEach( data_to_change => {
            switch ( data_to_change.property_name ) {
                case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
                    if ( data_to_change.property_new_value === default_grid_values[ widget_type ][ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getCfgValue() ) {
                        return;
                    }
                    break;
                case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
                    if ( data_to_change.property_new_value === "all" || data_to_change.property_new_value === default_grid_values[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ].getCfgValue() ) {
                        return;
                    }
                    break;
            }
            data_to_change.property_data.setUserValueAndValue( data_to_change.property_new_value );
            data_to_change.dom_element.innerHTML = this.buildKeyEntry( data_to_change.property_name ) + this.parseToHtml( data_to_change.property_name, data_to_change.property_data ) + ',';
        } );
    },
    changeGridHeightValue                : function ( label_key, new_value, default_value ) {
        let new_element_html = this.buildKeyEntry( label_key );
        if ( new_value === default_value ) {
            new_element_html += this.parseStringToHtml( '', this.default_tag );
        }
        else {
            new_element_html += this.parseToHtml( label_key, new_value );
        }
        let dom_element_height                     = this.dom_element.querySelector( '[data-label-key="' + label_key + '"]' );
        dom_element_height.parentElement.innerHTML = new_element_html + ',';
    }
};


SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.JsonEditor, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.JsonEditorService = (function ( self ) {
    var __LINE_TAG__       = "__SHINKEN_LINE_TAG__";
    self.computeValidation = function ( dom_element ) {
        let _text_parsed = _parseJsonDomElementToText( dom_element );
        _text_parsed     = SHINKEN.TOOLS.STRING.replaceAll( _text_parsed, __LINE_TAG__, "\n" );
        return [_text_parsed, SHINKEN.TOOLS.STRING.JSON.isFormatJsonInvalid( _text_parsed )];
    };
    self.computeLineNumber = function ( dom_element, error_line ) {
        const _computed_style = DOM.Service.getComputedStyles( dom_element, ["padding-bottom", "padding-top", "line-height", "height"] );
        const number_line     = (dom_element.scrollHeight - _computed_style[ "padding-bottom" ] - _computed_style[ "padding-top" ]) / _computed_style[ "line-height" ];
        let _html             = '';
        for ( let i = 1, _size = number_line; i <= _size; i++ ) {
            if ( i === error_line ) {
                _html += '<div class="shinken-line-number shinken-weather-json-form-line-error" data-number="' + i + '">' + i + '</div>';
            }
            else {
                _html += '<div class="shinken-line-number" data-number="' + i + '">' + i + '</div>';
            }
        }
        const _container     = document.querySelector( '.shinken-textarea-line-nums' );
        _container.innerHTML = _html;
        if ( error_line ) {
            self.scrollToError( dom_element, error_line );
        }
        _container.style.transform = "translateY(-" + dom_element.scrollTop + "px)";
    };
    self.scrollToError     = function ( dom_element, error_line ) {
        const _computed_style = DOM.Service.getComputedStyles( dom_element, ["padding-bottom", "padding-top", "line-height", "height"] );
        dom_element.scrollTo( 0, (error_line) * _computed_style[ "line-height" ] - _computed_style[ "height" ] / 2 );
    };
    
    var _parseJsonDomElementToText = function ( dom_element ) {
        const clone    = DOM.Service.cloneElement( dom_element );
        let _text      = clone.innerHTML;
        _text          = SHINKEN.TOOLS.STRING.replaceAll( _text, "<li", __LINE_TAG__ + "<li" );
        _text          = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ol>", __LINE_TAG__ + "</ol>" );
        _text          = SHINKEN.TOOLS.STRING.replaceAll( _text, "</ul>", __LINE_TAG__ + "</ul>" );
        const _new_dom = DOM.Service.createElement( "div", {}, _text );
        const _text_2  = _new_dom.innerText;
        return SHINKEN.TOOLS.STRING.replaceAll( _text_2, __LINE_TAG__, "\n" );
    };
    
    return self;
})( SHINKEN.OBJECT.JsonEditorService || {} );

SHINKEN.OBJECT.JsonForm           = function ( dom_element ) {
    this.__class_name__ = 'SHINKEN.OBJECT.JsonForm';
    this.init( dom_element );
};
SHINKEN.OBJECT.JsonForm.prototype = {
    init         : function ( dom_element ) {
        this.dom_element                     = dom_element;
        this.message_invalid                 = "";
        this.timeout_computeEditorLineNumber = null;
        this.line_invalid                    = 0;
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "focus-on-anchor-json":
                let grid_cell_uuid = param[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] || param[ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ].getUUID();
                let _to_return     = this.dom_element.querySelector( "[data-json-uuid-part='" + grid_cell_uuid + "']" );
                DOM.Service.focusOnAnchor_withDom( _to_return, this.dom_element, new DOM.Service.Animation( "shinken-pulsate", 1600 ), 5 );
                return _to_return;
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "copy_to_clipboard":
                        if ( this.isValid() ) {
                            CLIPBOARD_SERVICE.setContent( param.event.target, JSON.stringify( JSON.parse( this.getText() ), null, 2 ) );
                        }
                        else {
                            CLIPBOARD_SERVICE.setContent( param.event.target, this.getCurrentContent(), WEATHER.Page.prototype.copyJsonCallbackJSONInvalid );
                        }
                        SHINKEN_TOOLTIP.hideTooltip();
                        break;
                }
                break;
        }
    },
    //********************************************  GETTER SETTER  **************************************************//
    isValid: function () {
        return !this.error_syntax;
    },
    getText: function () {
        return this.text;
    },
    //********************************************  COMPUTE  **************************************************//
    askComputeLineNumber: function ( timeout ) {
        timeout    = timeout || 0;
        const self = this;
        if ( self.timeout_computeEditorLineNumber ) {
            clearTimeout( self.timeout_computeEditorLineNumber );
        }
        self.timeout_computeEditorLineNumber = setTimeout( function () {
            const _interval_done = setInterval( function () {
                if ( self.dom_element.scrollHeight ) {
                    SHINKEN.OBJECT.JsonEditorService.computeLineNumber( self.dom_element, self.line_invalid );
                    clearInterval( _interval_done );
                }
            }, 100 );
        }, timeout );
    },
    scrollToError       : function () {
        SHINKEN.OBJECT.JsonEditorService.scrollToError( this.dom_element, this.line_invalid );
    },
    computeIsValid      : function () {
        this.line_invalid = 0;
        const _analyze    = SHINKEN.OBJECT.JsonEditorService.computeValidation( this.dom_element );
        this.text         = _analyze[ 0 ];
        this.error_syntax = _analyze[ 1 ];
        if ( !this.isValid() ) {
            if ( SHINKEN.NAVIGATOR.isNavigator( 'isFireFox' ) ) {
                this.line_invalid = parseInt( SHINKEN.TOOLS.STRING.extractBetween( this.error_syntax.toString(), 'at line ', ' column' ) );
            }
            else {
                this.line_invalid = parseInt( SHINKEN.TOOLS.STRING.extractBetween( this.error_syntax.toString(), 'line ', ' column' ) );
            }
            this.message_invalid = SHINKEN.TOOLS.STRING.format( _( "json_editor.invalid_json", [DICTIONARY_COMMON_UI] ), this.line_invalid );
        }
    }
};



SHINKEN.OBJECT.ShinkenObjectJson           = function () {
    this.__class_name__ = 'SHINKEN.OBJECT.ShinkenObjectJson';
};
SHINKEN.OBJECT.ShinkenObjectJson.prototype = {
    getDataForJson    : function ( format_data__20241115 ) {
        const _to_return  = this.getObjectToJson( format_data__20241115 );
        const _components = this.getChildrenObjectDict();
        
        
        if ( Array.isArray( _components ) ) {
            _to_return.json_list_content = [];
            for ( let _i = 0, _size_i = _components.length; _i < _size_i; _i++ ) {
                _to_return.json_list_content.push( _components[ _i ].getDataForJson( format_data__20241115 ) );
            }
        }
        else {
            const _keys = Object.keys( _components );
            let _current_key;
            for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                if ( Array.isArray( _components[ _current_key ] ) ) {
                    _to_return[ _current_key ] = [];
                    for ( let j = 0, _size_j = _components[ _current_key ].length; j < _size_j; j++ ) {
                        _to_return[ _current_key ].push( _components[ _current_key ][ j ].getDataForJson( format_data__20241115 ) );
                    }
                }
                else if ( _components[ _current_key ].__class_name__ === "SHINKEN.OBJECT.Param" ) {
                    _to_return[ _current_key ] = _components[ _current_key ].user_value;
                }
                else if ( _components[ _current_key ] ) {
                    _to_return[ _current_key ] = _components[ _current_key ].getDataForJson( format_data__20241115 );
                }
            }
        }
        return _to_return;
    },
    getObjectToJson   : function ( format_data__20241115 ) {
        const _to_return = this._getObjectToJson( format_data__20241115 ) || {};
        if ( this.unknown_property_keys ) {
            for ( let j = 0, _size_j = this.unknown_property_keys.length; j < _size_j; j++ ) {
                _to_return[ this.unknown_property_keys[ j ] ] = this[ this.unknown_property_keys[ j ] ].getObjectToJson( format_data__20241115 );
            }
        }
        if ( this.__class_name__ !== "SHINKEN.OBJECT.Param" ) {
            const _valid_own_property = this.getValidOwnProperty().getContent();
            for ( let i = 0, _size = _valid_own_property.length; i < _size; i++ ) {
                if ( _valid_own_property[ i ].is_mandatory && typeof this[ _valid_own_property[ i ].key ] === 'undefined' ) {
                    _to_return[ _valid_own_property[ i ].key ] = "";
                }
            }
        }
        
        if ( this._json_anchor && !format_data__20241115 ) {
            _to_return[ SHINKEN.OBJECT.JSON_EDITOR.SHINKEN_JSON_UUID_ANCHOR ] = this._json_anchor;
        }
        const _information = this.addJSONInformation( format_data__20241115 );
        if ( _information ) {
            _to_return[ SHINKEN.OBJECT.JSON_EDITOR.JSON_FORMAT_INFORMATION ] = _information;
        }
        return _to_return;
    },
    addJSONInformation: function ( format_data__20241115 ) {
        let _to_return = null;
        if ( this.messages && this.messages.hasStatus() ) {
            _to_return = this.messages._getObjectToJson( format_data__20241115 );
        }
        return _to_return;
    },
    _getObjectToJson  : function ( format_data__20241115 ) {
        return {};
    },
    //********************************************  ADD ANCHOR   **************************************************//.
    addJsonAnchor: function ( uuid_anchor ) {
        this._json_anchor = this._json_anchor || [];
        this._json_anchor.push( uuid_anchor );
    },
    //********************************************  HTML   **************************************************//.
    initJsonDomElement    : function ( css_selector, dom_element ) {
        if ( this.dom_element__json ) {
            return;
        }
        dom_element            = dom_element || document;
        this.dom_element__json = dom_element.querySelector( css_selector );
    },
    setJsonDomElement     : function ( to_set ) {
        this.dom_element__json = to_set;
    },
    getJsonDomElement     : function () {
        return this.dom_element__json;
    },
    setJsonDomElementValue: function ( to_set ) {
        if ( !this.dom_element__json ) {
            return;
        }
        if ( to_set === this.getValue() && this.getUserValue() === this.default_value ) {
            return;
        }
        this.dom_element__json.innerHTML = to_set === this.default_value ? '"' + to_set + '"' : to_set;
        DOM.Service.addOrRemoveClasses( this.dom_element__json, to_set !== this.getUserInitialValue(), "shinken-modified" );
        this.updateDefaultValueHtml();
    },
    updateDefaultValueHtml: function () {
        const _default_value_doms = this.dom_element__json.parentElement.querySelectorAll( "[data-dft-val]" );
        for ( let i = 0, _size_i = _default_value_doms.length; i < _size_i; i++ ) {
            DOM.Service.addOrRemoveClasses( _default_value_doms[ i ], _default_value_doms[ i ].innerText === '"' + _default_value_doms[ i ].dataset.dftVal + '"', "X" );
        }
    },
    linkJsonDomElement    : function ( property_list ) {
        this.initJsonDomElement( "#id-shinken-output-json [data-json-uuid-part='" + this.getUUID() + "']" );
        if ( property_list ) {
            for ( let i = 0, _size_i = property_list.length; i < _size_i; i++ ) {
                this[ property_list[ i ] ].initJsonDomElement( '.sk-json-edit-val[data-key="' + property_list[ i ] + '"]', this.dom_element__json );
            }
        }
    },
    //********************************************  HTML   **************************************************//.
    updateJsonIfNeeded          : function ( params ) {
        if ( params && params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
            this.linkJsonDomElement();
            let json_editor = this.getJsonEditorInstance( null, this.getDataForJson(), SHINKEN_PAGE.CONST.DEFAULT_VALUE );
            DOM.Service.replaceElement( this.dom_element__json, json_editor.content.firstChild );
            this.dom_element__json = null;
        }
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectJson, SHINKEN.OBJECT.ShinkenObject );
