//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.CONST.PARAM     = {
    VALUE       : "value",
    CFG_VALUE   : "cfg_value",
    SOURCE_VALUE: "source_value",
    PARAM_EVENT : {
        PARAM_LIST_KEY: "param_object__list_keys",
        PARAM_DATA    : "param_object__data"
    }
};
SHINKEN.OBJECT.Param           = function ( key, value_object, parameter, default_value ) {
    this.init( key, value_object, parameter, default_value );
};
SHINKEN.OBJECT.Param.prototype = {
    __class_name__: 'SHINKEN.OBJECT.Param',
    init          : function ( key, value_object, parameter, default_value ) {
        this.initCounterCommon();
        if ( !value_object ) {
            return;
        }
        this.key           = key;
        this.default_value = default_value || value_object.default_value;
        this.initValueObject( value_object );
        if ( parameter && this.user_value === "" && !parameter.is_mandatory ) {
            this.user_value = this.default_value;
        }
    },
    //initCounterCommon       : function () {
    //    this.counters = {};
    //},
    initValueObject: function ( value_object ) {
        if ( value_object.validation_messages ) {
            this.setMessagesSpecific( value_object.validation_messages );
        }
        this.setValue( value_object[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] );
        if ( value_object[ SHINKEN.OBJECT.CONST.PARAM.CFG_VALUE ] !== undefined ) {
            this.cfg_value = value_object[ SHINKEN.OBJECT.CONST.PARAM.CFG_VALUE ];
        }
        this.setUserValueFromInit( value_object );
        this._initial_user_value = value_object._initial_user_value !== undefined ? value_object._initial_user_value : this.getUserValue();
    },
    //********************************************  EVENT LISTENER  *********************************************//
    doActionAfter: function ( event_name, params ) {
        switch ( event_name ) {
            case "value__param__configured__from_form":
                this.addParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                this.setPreviousModificationElement();
                this.initValueObject( params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] );
                this.resetCounterByType( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement() );
                break;
            case "undo_last_modification" :
            case "redo_last_modification":
                this.initValueObject( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getNextOrPrevious( event_name ) );
                break;
            case "default__param__configured__from_form":
                this.addParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                this.setPreviousModificationElement();
                this.setValue( params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ][ SHINKEN.OBJECT.CONST.PARAM.VALUE ] );
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement() );
                break;
        }
    },
    //********************************************  GETTER SETTER  *********************************************//
    setMessagesSpecific     : function ( message ) {
        this.setMessages( message );
    },
    doActionAfterAddMessages: function () {
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.getObjectClassName(), this.messages.getNumberWarnings() );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.getObjectClassName(), this.messages.getNumberErrors() );
    },
    _getObjectToJson        : function ( format_data__20241115 ) {
        switch ( format_data__20241115 ) {
            case SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_ONLY:
                return this.getValue();
            case SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT:
                return { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.getValue(), [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this.getUserValue() };
            case SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT_AND_CFG:
                return { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.getValue(), [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this.getUserValue(), [ SHINKEN.OBJECT.CONST.PARAM.CFG_VALUE ]: this.getCfgValue() };
            case SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT:
                return { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.getValue(), [ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ]: this.default_value };
        }
        return this;
    },
    changeUserValueByValue  : function () {
        this.user_value = this.value;
    },
    setUserValueFromInit    : function ( value_object ) {
        let to_set = "";
        if ( value_object[ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ] !== undefined ) {
            to_set = value_object[ SHINKEN.OBJECT.CONST.PARAM.SOURCE_VALUE ];
        }
        else if ( value_object.user_value !== undefined ) {
            to_set = value_object.user_value;
        }
        this.setUserValue( to_set );
    },
    setUserValue            : function ( to_set ) {
        this.user_value = to_set;
    },
    setUserValueAndValue    : function ( to_set ) {
        this.setValue( to_set );
        this.setUserValue( to_set );
    },
    getUserInitialValue     : function () {
        return this._initial_user_value;
    },
    getUserValue            : function () {
        return this.user_value;
    },
    setValue                : function ( to_set ) {
        this.value = to_set;
    },
    getValue                : function () {
        return this.value;
    },
    getCfgValue             : function () {
        return this.cfg_value;
    },
    getUUID                 : function () {
        return this.uuid;
    },
    clone__20250108         : function () {
        let to_return                 = new SHINKEN.OBJECT.Param( this.key );
        to_return.user_value          = this.user_value;
        to_return.value               = this.value;
        to_return._initial_user_value = this._initial_user_value;
        to_return.cfg_value           = this.cfg_value;
        to_return.default_value       = this.default_value;
        return to_return;
    },
    //********************************************  LAST MODIFICATION  *****************************************************//
    getLastModificationElement: function () {
        let element_modified = this;
        let previous         = this.previous_modication_data;
        let next             = this.getDataForLastModification();
        return new SHINKEN.OBJECT.LastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.PARAM_MODIFICATION, element_modified, previous, next );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave             : function () {
        return this.getValue();
    },
    getDataForLastModification: function () {
        let to_return = this.clone__20250108();
        delete to_return[ "counters" ];
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Param, SHINKEN.OBJECT.EditableElementInterface );
