//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.Refresh = function ( countdown, parent ) {
    this.init( countdown, parent );
};

SHINKEN.OBJECT.Refresh.CONST = {
    UPDATE_AT: "UpdateAt",
    CLOCK    : "Clock"
};

SHINKEN.OBJECT.Refresh.prototype = {
    init: function ( countdown, parent ) {
        this.initPhase();
        this.parent_object     = parent;
        this.countdown         = countdown || 60000;
        this.countdown_tic     = 1000;
        this.current_countdown = this.countdown;
        this.ui_components     = [];
        this.interval_tic_tac  = null;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    addUiComponent       : function ( to_add ) {
        this.ui_components.push( to_add );
    },
    computePercent       : function () {
        this.percent_computed = (1 - this.current_countdown / this.countdown) * 100;
    },
    setLastComputeDate   : function ( to_set ) {
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].setLastComputeDate( to_set );
        }
    },
    getSpecificDomElement: function ( name ) {
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            if ( this.ui_components[ i ].getName() === name ) {
                return this.ui_components[ i ].getDomElement();
            }
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].computeHtml();
        }
    },
    //********************************************  ACTIONS  *****************************************************//
    askParentPhaseUpdated: function () {
        if ( !this.ui_components ) {
            return;
        }
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].phaseUpdated( this.phase.current_phase, this );
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    updateCountdown: function () {
        if ( this.phase.isPhase( SHINKEN.OBJECT.CONST.PHASE.STUCK_TO_STRING ) ) {
            return;
        }
        this.current_countdown -= this.countdown_tic;
        this.current_countdown = Math.max( this.current_countdown, 0 );
        this.computePercent();
        for ( var i = 0, _size_i = this.ui_components.length; i < _size_i; i++ ) {
            this.ui_components[ i ].updateCountdown( this );
        }
    },
    reset          : function () {
        clearInterval( this.interval_tic_tac );
        this.current_countdown = this.countdown;
    },
    tictac         : function () {
        var _phase_value = this.getCurrentPhase();
        this.updateCountdown();
        if ( this.current_countdown <= 0 ) {
            switch ( _phase_value ) {
                case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING_TO_STRING );
                    break;
                case SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING:
                    if ( !SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING_TO_STRING );
                    }
                    break;
            }
        }
    },
    //********************************************  OTHERS  *****************************************************//
    callbackForPhase: function () {
        this.askParentPhaseUpdated();
        switch ( this.phase.current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING :
                if ( !this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.STOPPING ) ) {
                    this.reset();
                }
                this.interval_tic_tac = setInterval( () => {
                    this.tictac();
                }, this.countdown_tic );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RESET :
                this.reset();
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING_TO_STRING :
                if ( SHINKEN.NAVIGATOR.isNavigatorHidden() ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
                }
                else {
                    clearInterval( this.interval_tic_tac );
                    if ( this.parent_object ) {
                        this.parent_object.refresh();
                    }
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.STOPPING :
                clearInterval( this.interval_tic_tac );
                break;
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Refresh, SHINKEN.OBJECT.PhaseInterface );