//__lib__ lib_common
"use strict";

SHINKEN.SERVER.ShinkenServer = function ( data ) {
    this.init( data );
};

SHINKEN.SERVER.ShinkenServer.prototype = {
    init          : function ( data ) {
        this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ] = [];
        if ( data ) {
            this.updateData( data );
        }
    },
    updateData    : function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData       : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.SERVER.CONST.NAME:
                this.setName( value );
                break;
            
            case SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO:
                this.addCartoToList( value );
                break;
        }
    },
    setName       : function ( to_set ) {
        this[ SHINKEN.SERVER.CONST.NAME ] = to_set;
    },
    addCartoToList: function ( data ) {
        var _size = data.length;
        for ( var i = 0; i < _size; i++ ) {
            this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ].push( new SHINKEN.CARTO.ShinkenCarto( data[ i ] ) );
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        var _template         = document.querySelector( '#shinken-architecture-template .shinken-template-architecture-map' ).outerHTML;
        _template             = SHINKEN.TOOLS.STRING.replaceAll( _template, "$$$_architecture_name_$$$", this.name );
        var _temp             = DOM.Service.createElement( "ul", {}, _template );
        this.dom_element      = _temp.firstChild;
        var _container_for_li = this.dom_element.querySelector( "ul.shinken-container" );
        for ( var i = 0, _size_i = this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ].length; i < _size_i; i++ ) {
            this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ][ i ].computeHtml();
            DOM.Service.addElementTo( this[ SHINKEN.SERVER.CONST.LIST_SHINKEN_CARTO ][ i ].dom_element, _container_for_li );
        }
        
    }
};