//priority 20
//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.SLIDE_PANEL = {
    TYPE    : {
        HORIZONTAL_RIGHT: "HORIZONTAL_RIGHT",
        HORIZONTAL_LEFT : "HORIZONTAL_LEFT",
        VERTICAL_TOP    : "VERTICAL_TOP",
        VERTICAL_BOTTOM : "VERTICAL_BOTTOM"
    },
    POSITION: {
        RIGHT : "RIGHT",
        LEFT  : "LEFT",
        TOP   : "TOP",
        BOTTOM: "BOTTOM"
    },
    WIDTH   : {
        SMALL: 450
    },
    ACTION  : {
        PIN_TO_MIN_SIZE_PART_ADDED   : "pin_to_min_size_part_added",
        PIN_TO_MIN_SIZE_PART_EXISTING: "pin_to_min_size_part_existing"
    },
    PARAM   : {
        NAME         : "slide_panel_name",
        OBJECT       : "slide_panel_object",
        DRAG_N_DROP  : "slide_panel_drag_n_drop",
        SIZE_EXISTING: "size_existing_slide_panel",
        SIZE_ADDED   : "size_added_slide_panel"
    }
};

SHINKEN.OBJECT.SlidePanel           = function ( name, dom_element__part_existing ) {
    this.init( name, dom_element__part_existing );
};
SHINKEN.OBJECT.SlidePanel.prototype = {
    init      : function ( name, dom_element__part_existing ) {
        this.initCommon( name, dom_element__part_existing );
    },
    initCommon: function ( name, dom_element__part_existing ) {
        this.type = this.type || SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT;
        this.initPhase();
        this.setName( name );
        this.setExistingDomElement( dom_element__part_existing );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    open__20240925     : function () {
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    close__20240925    : function () {
        this.setPhaseIfDifferent( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
    },
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_MIN_SIZE_PART_ADDED:
                        this.setSize__20240926( this.getMinSize__partAdded() );
                        break;
                    case SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_MIN_SIZE_PART_EXISTING:
                        this.setSize__20240926( this.getMaxSize__partAdded() );
                        break;
                }
                break;
            case "compute_html_done":
                this.size_window = this.getCurrentSize__window();
                this.computeSize__parent();
                this.computeInitialSize();
                this.setSize__20240926( this.getSize__partAdded() );
                break;
            case "on_drag_start":
                this.onDragStart( param[ MANAGER.DragNDropManager.EVENT_PARAM.ORIGIN_X ], param[ MANAGER.DragNDropManager.EVENT_PARAM.ORIGIN_Y ] );
                break;
            case "on_drag_move":
                this.onDragMove( param[ MANAGER.DragNDropManager.EVENT_PARAM.DELTA_X ], param[ MANAGER.DragNDropManager.EVENT_PARAM.DELTA_Y ] );
                break;
            case "on_drag_stop":
                this.onDragStop();
                break;
        }
    },
    //********************************************  SETTER GETTER  *****************************************************//
    setSize__20240926        : function ( size__part_added, is_drag_n_drop ) {
        if ( !this.isActive() ) {
            return;
        }
        size__part_added         = Math.max( size__part_added, this.getMinSize__partAdded() );
        size__part_added         = Math.min( size__part_added, this.getMaxSize__partAdded() );
        let size__part_existing  = this.getSize__parent() - size__part_added - this.getSizeButtons();
        const is_part_size_small = size__part_existing < SHINKEN.OBJECT.SLIDE_PANEL.WIDTH.SMALL;
        DOM.Service.setStyle( this.dom_element__part_added, this.getStyleKey(), size__part_added );
        DOM.Service.setStyle( this.dom_element__part_existing, this.getStyleKey(), size__part_existing );
        if ( !is_drag_n_drop ) {
            this.size__part_added = size__part_added;
        }
        this.computeStatePinButtons();
        this.computeSize__parent();
        this.getController_20241003().doActionAfter( "slide_panel__size__has_changed", {
            [ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ]       : this,
            [ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.DRAG_N_DROP ]  : !!is_drag_n_drop,
            [ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.SIZE_ADDED ]   : size__part_added,
            [ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.SIZE_EXISTING ]: size__part_existing
        } );
    },
    getSizeButtons           : function () {
        return DOM.Service.getBoundingClientRect( this.dom_element__part_buttons, this.getStyleKey() );
    },
    setMinSize               : function ( min_size__part_existing, min_size__part_added ) {
        this.min_size__part_existing = min_size__part_existing || this.min_size__part_existing || 0;
        this.min_size__part_added    = min_size__part_added || this.min_size__part_added || 0;
    },
    setInitialSize           : function ( to_set_ratio, to_set_pixel ) {
        this.initial_ratio = to_set_ratio;
        this.initial_pixel = to_set_pixel;
    },
    getSize__partAdded       : function () {
        return this.size__part_added;
    },
    getMinSize__partExisting : function () {
        return this.min_size__part_existing;
    },
    getMinSize__partAdded    : function () {
        return this.min_size__part_added;
    },
    getMaxSize__partAdded    : function () {
        return this.getSize__parent() - this.getMinSize__partExisting() - this.getSizeButtons();
    },
    getSize__parent          : function () {
        return this.size_parent;
    },
    getSize__window          : function () {
        return this.size_window;
    },
    getCurrentRatio          : function () {
        return this.getSize__partAdded() / this.getSize__parent();
    },
    setLoading               : function ( to_set ) {
        if ( !to_set ) {
            return;
        }
        if ( !this.dom_element_loading ) {
            this.dom_element_loading         = DOM.Service.createElement( "div", { class: "shinken-panel-loading-container" } );
            var _content                     = DOM.Service.createElement( "div", { class: "shinken-panel-loading-content" } );
            this.dom_element_loading_message = DOM.Service.createElement( "div", { class: "shinken-panel-loading-message" } );
            var _icon                        = DOM.Service.createElement( "div", { class: "shinken-panel-loading-icon" }, '<span class="shinkon shinkon-reload"></span>' );
            DOM.Service.addElementTo( this.dom_element_loading_message, _content );
            DOM.Service.addElementTo( _icon, _content );
            DOM.Service.addElementTo( _content, this.dom_element_loading );
        }
        this.dom_element_loading_message.innerHTML = to_set;
        this.setContent__20240925( this.dom_element_loading );
    },
    setContent__20240925     : function ( to_set, is_loading ) {
        this.content_html = to_set;
        if ( this.dom_element__part_added ) {
            DOM.Service.addElementToAfterEmpty( this.content_html, this.dom_element__part_added );
        }
        this.doActionAfter( "slide_panel__set_content__done", {
            [ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ]: this
        } );
        this.addDoActionAfterCallBackPhaseBecome( SHINKEN.OBJECT.CONST.PHASE.RUNNING, "slide_panel__size__has_changed", {} );
    },
    setName                  : function ( to_set ) {
        this.name = to_set;
    },
    getName                  : function () {
        return this.name;
    },
    setType                  : function ( to_set ) {
        this.type = to_set;
    },
    setExistingDomElement    : function ( to_set ) {
        this.dom_element__part_existing   = to_set;
        this.dom_element_parent__20240925 = this.dom_element__part_existing.parentElement;
    },
    getCurrentSize__partAdded: function () {
        return DOM.Service.getBoundingClientRect( this.dom_element__part_added, this.getStyleKey() );
    },
    getStyleKey              : function () {
        switch ( this.type ) {
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT:
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT:
                return DOM.CONST.STYLE.WIDTH;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP:
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM:
                return DOM.CONST.STYLE.HEIGHT;
        }
    },
    getCurrentSize__window   : function () {
        switch ( this.type ) {
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT:
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT:
                return window.innerWidth;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP:
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM:
                return window.innerHeight;
        }
    },
    isActive                 : function () {
        return this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    //********************************************  DRAG AND DROP  *****************************************************//
    onDragStart: function ( origin_x, origin_y ) {
        this.origin_x   = origin_x;
        this.origin_y   = origin_y;
        this.is_drag_on = true;
    },
    onDragMove : function ( delta_x, delta_y ) {
        switch ( this.type ) {
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT:
                this.setSize__20240926( this.getSize__partAdded() + delta_x, true );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT:
                this.setSize__20240926( this.getSize__partAdded() - delta_x, true );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_TOP:
                this.setSize__20240926( this.getSize__partAdded() + delta_y, true );
                break;
            case SHINKEN.OBJECT.SLIDE_PANEL.TYPE.VERTICAL_BOTTOM:
                this.setSize__20240926( this.getSize__partAdded() - delta_y, true );
                break;
        }
    },
    onDragStop : function () {
        this.size__part_added = this.getCurrentSize__partAdded();
        this.is_drag_on       = false;
    },
    //********************************************  COMPUTE  *****************************************************//
    computeSize__parent   : function () {
        this.size_parent = DOM.Service.getBoundingClientRect( this.dom_element_parent__20240925, this.getStyleKey() );
    },
    computeStatePinButtons: function () {
        let size__part_added = this.getCurrentSize__partAdded();
        DOM.Service.addOrRemoveClasses( this.dom_element__part_buttons, this.getMaxSize__partAdded() === size__part_added, "shinken-max-on" );
        DOM.Service.addOrRemoveClasses( this.dom_element__part_buttons, this.getMinSize__partAdded() === size__part_added, "shinken-min-on" );
    },
    computeInitialSize    : function () {
        if ( this.initial_pixel ) {
            this.size__part_added = this.initial_pixel;
        }
        else {
            if ( !this.initial_ratio ) {
                this.setInitialSize( 0.5 );
            }
            this.size__part_added = this.getSize__parent() * this.initial_ratio;
        }
    },
    computeSizes__20240926: function ( force_compute ) {
        if ( !this.isActive() ) {
            return;
        }
        this.getDomElement().classList.add( "shinken-hidden" ); //NEEDED IN ORDER TO IGNORE SIZE HARD SET.
        var new_window_size = this.getCurrentSize__window();
        var ratio_resize    = new_window_size / this.getSize__window();
        this.computeSize__parent();
        this.getDomElement().classList.remove( "shinken-hidden" );
        if ( !force_compute && ratio_resize === 1 ) {
            return;
        }
        this.setSize__20240926( this.getSize__partAdded() * ratio_resize );
        this.size_window = new_window_size;
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase      : function () {
        this.callbackForPhaseCommon();
    },
    callbackForPhaseCommon: function () {
        const _current = this.getCurrentPhase();
        if ( this.getPreviousPhase() === _current ) {
            return;
        }
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.computeHtml();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.restoreStructure();
                break;
        }
    },
    //********************************************  HTML  *****************************************************//
    computeHtml      : function () {
        if ( this.getDomElement() ) {
            return;
        }
        this._computeHtml();
        this.addDomElement( this.dom_element__part_added );
        this.addDomElement( this.dom_element__part_buttons );
        this.addDomElement( this.dom_element__part_existing );
        this.doActionAfter( "compute_html_done" );
    },
    _computeHtml     : function () {
        this.setDomElement( DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-slide-panel-container", "data-type": this.type } ), this.dom_element_parent__20240925 ) );
        this.dom_element__part_added = DOM.Service.createElement( "div", {
            class: "shinken-slide-panel-content"
        } );
        if ( this.content_html ) {
            DOM.Service.addElementTo( this.content_html, this.dom_element__part_added );
        }
        this.dom_element__part_buttons = this.computeButtonHtml();
    },
    computeButtonHtml: function () {
        let _to_return = DOM.Service.createElement( "div", { class: "shinken-slide-panel-buttons-part shinken-user-select-none" } );
        let _div       = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-slide-panel-buttons-containers" } ), _to_return );
        
        let _button_min_added = new COMPONENT.ButtonFromData_V3( SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_MIN_SIZE_PART_ADDED, "<span class='shinken-slide-panel-button shinkon shinkon-double-chevron-up'></span>" );
        _button_min_added.addParamForEvents( SHINKEN.OBJECT.SLIDE_PANEL.PARAM.NAME, this.getName() );
        _button_min_added.computeHtml();
        DOM.Service.addElementTo( _button_min_added.getDomElement(), _div );
        
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class                          : "shinken-slide-panel-button shinkon shinkon-resize-horizontal shinken-draggable",
            "data-drag-is-in-screen"       : true,
            "data-drag-resize-element-name": this.name,
            onmousedown                    : "MANAGER.DragNDropManager.dragStartSingle(event)"
        } ), _div );
        
        let _button_min_existing = new COMPONENT.ButtonFromData_V3( SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_MIN_SIZE_PART_EXISTING, "<span class='shinken-slide-panel-button shinkon shinkon-double-chevron-down'></span>" );
        _button_min_existing.addParamForEvents( SHINKEN.OBJECT.SLIDE_PANEL.PARAM.NAME, this.getName() );
        _button_min_existing.computeHtml();
        DOM.Service.addElementTo( _button_min_existing.getDomElement(), _div );
        
        return _to_return;
    },
    restoreStructure : function () {
        this.initial_pixel = this.getCurrentSize__partAdded();
        DOM.Service.setStyle( this.dom_element__part_existing, this.getStyleKey(), "" );
        DOM.Service.addElementToAfterEmpty( this.dom_element__part_existing, this.dom_element_parent__20240925 );
        DOM.Service.removeElement( this.getDomElement() );
        DOM.Service.removeElement( this.dom_element__part_buttons );
        DOM.Service.removeElement( this.dom_element__part_added );
        this.setDomElement();
        this.doActionAfter( "slide-panel-restore-structure-done" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanel, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanel, SHINKEN.OBJECT.PhaseInterface );
