//__lib__ lib_common
"use strict";
SHINKEN.ELEMENT.UiUserAcl = function ( data ) {
    this.make_downtime                = true;
    this.make_acknowledge             = true;
    this.force_result_check           = true;
    this.show_historic_sla            = true;
    this.show_historic_historic       = true;
    this.show_historic_sla_range      = true;
    this.show_historic_historic_range = true;
    this.init( data );
};

SHINKEN.ELEMENT.UiUserAcl.prototype = {
    init                    : function ( data ) {
        this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ]   = new SHINKEN.ELEMENT.UiUserAclShareExtend();
        this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP ]     = new SHINKEN.ELEMENT.UiUserAclShareExtend();
        this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY ] = new SHINKEN.ELEMENT.UiUserAclShareExtend();
        this.updateData( data );
    },
    updateData              : function ( datas ) {
        var _keys     = Object.keys( datas );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, datas[ _currentKey ] );
        }
        this.setRightToCreateNewShare();
        this.setDisplayFavoritePanel();
    },
    setData                 : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.ELEMENT.USER.PARAM.ACL.MAKE_DOWNTIME:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.MAKE_ACKNOWLEDGE:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.FORCE_RESULT:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.RECHECK_NOW:
                this[ key ] = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW:
                this.setHistoricShow( value );
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.HISTORIC_RANGE:
                this.show_historic_historic_range = value;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SLA_RANGE:
                this.show_historic_sla_range = value;
                break;
            
            case SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP:
            case SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY:
                this[ key ].init( value );
                break;
            default:
                break;
            
        }
    },
    setHistoricShow         : function ( value ) {
        switch ( value ) {
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_BOTH:
                this.show_historic_sla      = true;
                this.show_historic_historic = true;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_HISTORY_ONLY:
                this.show_historic_sla      = false;
                this.show_historic_historic = true;
                break;
            case SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_SLA_ONLY:
                this.show_historic_sla      = true;
                this.show_historic_historic = false;
                break;
        }
    },
    setRightToCreateNewShare: function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ] ) {
            return;
        }
    },
    hasRightToCreateFavoriteInPrivate           : function () {
        return this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ].hasRight( "create" );
    },
    setDisplayFavoritePanel : function () {
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ] ) {
            return;
        }
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP ] ) {
            return;
        }
        if ( !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY ] ) {
            return;
        }
        //$rootScope.is_share_panel_visible     = !(!this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_PRIVATE ].read && !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_GROUP ].read && !this[ SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE_EVERYBODY ].read);
        //$rootScope.panels[ SLIDE_PANEL.NAME.SHARE ].isVisible = $rootScope.is_share_panel_visible;
    },
    getHistoricDisplayMode  : function () {
        if ( this.show_historic_historic && this.show_historic_sla ) {
            return SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_BOTH;
        }
        if ( this.show_historic_historic ) {
            return SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_HISTORY_ONLY;
        }
        if ( this.show_historic_sla ) {
            return SHINKEN.ELEMENT.USER.PARAM.ACL.HISTORIC.SHOW_SLA_ONLY;
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUserAcl, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.ELEMENT.UiUserAclShareExtend = function () {
    this.read     = false;
    this.create   = false;
    this.organize = false;
    this.update   = false;
    this.delete   = false;
};

SHINKEN.ELEMENT.UiUserAclShareExtend.prototype = {
    init    : function ( data ) {
        var _data = data.split( '' );
        var _size = _data.length;
        var _key;
        for ( var i = 0; i < _size; i++ ) {
            _key = SHINKEN.ELEMENT.USER.PARAM.ACL.SHARE[ i ];
            if ( !_key ) {
                console.error( "[UNKNOWN SHARE ACL STRUCTURE]" );
                continue;
            }
            this[ _key ] = !!parseInt( _data[ i ] );
        }
    },
    hasRight: function ( type ) {
        if ( !this.read ) {
            return false;
        }
        return this[ type ];
    }
    
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.ELEMENT.UiUserAclShareExtend, SHINKEN.OBJECT.ShinkenObject );