//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.VIEW_HISTORY = {
    PARAM: {
        NAME: "view_history_name"
    }
};

SHINKEN.OBJECT.ViewHistory           = function ( name, pagination ) {
    this.init( name, pagination );
};
SHINKEN.OBJECT.ViewHistory.prototype = {
    //********************************************  INIT  *****************************************************//
    init                        : function ( name, pagination ) {
        this.initPhase();
        this.name            = name;
        this.pagination_size = pagination;
    },
    initList                    : function () {
        this.list__20240822 = new SHINKEN_LIST.SetFromDataWithPagination( "list_history", this.pagination_size );
        this.list__20240822.setHeaders( new SHINKEN_LIST.HeadersFromData(
            [
                { name: SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.DATE_HISTORY, label: _( "history.title.date", [DICTIONARY_COMMON_UI] ) },
                { name: SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.USER_HISTORY, label: _( "history.title.user", [DICTIONARY_COMMON_UI] ) },
                { name: SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY, label: _( "history.title.action", [DICTIONARY_COMMON_UI] ) }
            ] ) );
        this.list__20240822.getPagination().addChildrenParamForEvents( SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME, this.getName() );
        this.list__20240822.getPagination().addChildrenParamForEvents( SHINKEN_LIST.CONST.PARAM.LINE_UUID, this.getName() );
    },
    getDataFromBackend__20241001: function ( url ) {
        this.addLoading();
        url          = url || this.getBackendUrl();
        var _success = ( _status, data ) => {
            this.formatAndApplyData( data.output );
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
        };
        var _error   = () => {
            SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "communication.no_backend_response", [DICTIONARY_COMMON_UI] ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
            this.doActionAfter( "communication_no_backend_response" );
        };
        SHINKEN.COMUNICATION.requestGet( url, _success, _error );
    },
    formatAndApplyData          : function ( data ) {
        this.list__20240822.computeLines( this.parseBackendData( data ) );
        this.parent.doActionAfter( "history_backend_loaded_done" );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
                this.list__20240822.doActionAfter( event_name, param );
                break;
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case CLIPBOARD_SERVICE.PARAM.EVENT_NAME_COPY:
                        var export_data = SHINKEN.TOOLS.ARRAY.parseForClipboardText( this.getDataToExport(), [20, 30, 0] );
                        CLIPBOARD_SERVICE.setContent( param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, export_data );
                        SHINKEN_TOOLTIP.hideTooltip();
                        break;
                    default:
                        this.list__20240822.doActionAfter( event_name, param );
                }
                break;
            case "communication_no_backend_response":
                DOM.Service.addServerDown( this.dom_element_parent__20240822 );
                break;
        }
    },
    //********************************************  PARSING BACKEND *****************************************************//
    parseBackendData                     : function ( data ) {
        let _to_return = [];
        for ( let i = 0; i < data.length; i++ ) {
            _to_return.push( this.parseBackendDataLine( data[ i ] ) );
        }
        return _to_return;
    },
    initBackendDataLineParser            : function ( data ) {
        let _to_return                                                     = {};
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.DATE_HISTORY ] = DATE_TIME.getDateAndTimeToHtml( data.date );
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.USER_HISTORY ] = data.instigator_user.user_name;
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = "";
        return _to_return;
    },
    parseBackendDataLine                 : function ( data, to_return ) {
        return this.parseBackendDataLineCommon( data, to_return );
    },
    parseBackendDataLineCommon           : function ( data, to_return ) {
        to_return = to_return || this.initBackendDataLineParser( data );
        switch ( data.action.type ) {
            case "SAVE":
                to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.action.update", [DICTIONARY_COMMON_UI] );
                break;
            case "CREATION":
                to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.action.creation", [DICTIONARY_COMMON_UI] );
                break;
            case "CLONE":
                let sanitized_data_string                                         = SHINKEN.TOOLS.STRING.cleanXss( data.action.context.reference_weather.name );
                to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = SHINKEN.TOOLS.STRING.format( _( "history.views.copy", [DICTIONARY_VISU_UI] ), sanitized_data_string );
                break;
            case "NEW_OWNER":
                to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = SHINKEN.TOOLS.STRING.format( _( "history.action.new_owner", [DICTIONARY_COMMON_UI] ), data.action.context.new_owner.user_name );
                break;
            case "UPDATE":
                to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = this.parseBackendDataLineForActionUpdate( data );
                break;
            case "DELETION":
                to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] += _( "history.action.delete", [DICTIONARY_COMMON_UI] );
                //to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] += this.parseBackendDataLineForActionDeletion( data );
                break;
            case "RESTORATION":
                to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.action.restore", [DICTIONARY_COMMON_UI] );
                break;
        }
        return to_return;
    },
    parseBackendDataLineForActionDeletion: function () {
    },
    //********************************************  PARSING LAST MODIFICATIONS  *****************************************************//
    initCurrentChangesDataLineParser   : function ( data ) {
        let _to_return                                                     = {};
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.DATE_HISTORY ] = DATE_TIME.getDateAndTimeToHtml( data.timestamp / 1000 );
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.USER_HISTORY ] = _( "history.user", [DICTIONARY_VISU_UI] );
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = "";
        _to_return.widget_uuid                                             = [];
        data.contents.forEach( content => {
            _to_return.widget_uuid.push( content.element_uuid );
        } );
        _to_return.uuid = data.uuid;
        
        return _to_return;
    },
    parseLastModificationDataLine      : function ( data ) {
        return this.parseLastModificationDataLineCommon( data );
    },
    parseLastModificationDataLineCommon: function ( data ) {
    },
    //*******************************************  GETTER SETTER  ****************************************************//
    getList__20240822: function () {
        return this.list__20240822;
    },
    //****************************²****************  EXPORT DATA  *****************************************************//
    getDataToExport: function () {
        return this.list__20240822.getDataToExport();
    },
    //*******************************************  OTHER  ****************************************************//
    reset: function () {
        this.resetHTML();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.INIT );
    },
    //*******************************************  HTML  ****************************************************//
    computeHtml        : function () {
        this.list__20240822.computeHtml();
        this.setDomElement( DOM.Service.createElement( 'div', { class: "shinken-view-history" } ) );
        this.addDomElement( this.list__20240822.getDomElement() );
        this.computeClipboard();
    },
    addLoading         : function ( text_to_add ) {
        if ( !this.dom_element_parent__20240822 ) {
            return;
        }
        DOM.Service.addLoadingFrameV2( this.dom_element_parent__20240822, text_to_add );
    },
    clickOnItemSelector: function ( event, parent_name, element ) {
        this.list__20240822.clickOnItemSelector( event, parent_name, element );
        this.computeSizes();
    },
    computeClipboard   : function () {
        this.addDomElement( CLIPBOARD_SERVICE.buildHtmlButtons_V3( true, false, { [ SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME ]: this.getName() } ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ViewHistory, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ViewHistory, SHINKEN.OBJECT.PhaseInterface );