//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.View           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.View.prototype = {
    init      : function ( data ) {
        this.shares_uuid                              = [];
        this[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ]   = 0;
        this[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] = 0;
        this.updateData( data );
    },
    updateData: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.VIEW.PARAM.NAME:
                this.setName( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.UUID:
                this.setUUID( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS._KEY:
                this.updateUsers( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.EXTERNAL_LINKS:
                this.setWeatherLinks( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.FOUND:
            case SHINKEN.OBJECT.VIEW.PARAM.NOTIFICATIONS:
            case SHINKEN.OBJECT.VIEW.PARAM.TYPE:
            case SHINKEN.OBJECT.VIEW.PARAM.IS_ROOT_PROBLEM:
            case SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS:
            case SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS:
            case SHINKEN.OBJECT.VIEW.PARAM.NB_SHARED_LINK:
            case SHINKEN.OBJECT.VIEW.PARAM.GROUPS_SHARES_UUID:
            case SHINKEN.OBJECT.VIEW.PARAM.OWNER._KEY:
                this [ key ] = value;
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.VIEW_BEHAVIOUR:
                this.setBehaviourPhase( value );
                break;
            default:
                console.warn( "[SHINKEN.OBJECT.VIEW]", "[IGNORED DATA]", key, value );
                break;
        }
    },
    //addShareInfo: function ( key, value ) {
    //    switch ( key ) {
    //        case SHINKEN.OBJECT.SHARE.PARAM.UUID:
    //            this.shares_uuid.push( value );
    //            break;
    //        default:
    //            //this[ key ] = value;
    //            break;
    //    }
    //},
    updateUsers: function ( data ) {
        if ( !data ) {
            return;
        }
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.addUserInfo( _currentKey, data[ _currentKey ] );
        }
    },
    addUserInfo: function ( key, value ) {
        
        switch ( key ) {
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.OWNER:
                this.setOwner( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.PREVIOUS_OWNER:
                this.setPreviousOwner( value );
                break;
            case SHINKEN.OBJECT.VIEW.PARAM.USERS.CREATOR:
                this.setCreator( value );
                break;
            default:
                console.warn( "[SHINKEN.OBJECT.VIEW]", "[IGNORED USER DATA]", key, value );
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setName                        : function ( to_set ) {
        this[ SHINKEN.OBJECT.VIEW.PARAM.NAME ] = to_set;
    },
    setUUID                        : function ( to_set ) {
        this[ SHINKEN.OBJECT.VIEW.PARAM.UUID ] = to_set;
    },
    getUUID                        : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.UUID ];
    },
    getType                        : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.TYPE ];
    },
    isType                        : function ( to_test ) {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.TYPE ] === to_test;
    },
    getOwnerUUID                   : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.OWNER._KEY ][ SHINKEN.OBJECT.VIEW.PARAM.OWNER.PARAM.UUID._KEY ];
    },
    getOwnerName                   : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.OWNER._KEY ][ SHINKEN.OBJECT.VIEW.PARAM.OWNER.PARAM.NAME._KEY ];
    },
    getName                        : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NAME ];
    },
    getViewName                    : function () {
        return this.getName();
    },
    getCloneName                   : function () {
        return this.getViewName() + _( "common.clone_tag", [DICTIONARY_COMMON_UI] );
    },
    getShareNumber                 : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NB_SHARED_LINK ];
    },
    getNumberOfErrors              : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ];
    },
    getNumberOfWarnings            : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ];
    },
    getOwner                       : function () {
        return this.owner_user;
    },
    getProblems                    : function () {
        var _problems                                      = {};
        _problems[ SHINKEN.OBJECT.VIEW.PARAM.NB_ERRORS ]   = this.getNumberOfErrors();
        _problems[ SHINKEN.OBJECT.VIEW.PARAM.NB_WARNINGS ] = this.getNumberOfWarnings();
        return _problems;
    },
    setOwner                       : function ( value ) {
        this.owner_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    getPreviousOwner               : function () {
        return this.previous_owner_user;
    },
    setPreviousOwner               : function ( value ) {
        this.previous_owner_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    getCreator                     : function () {
        return this.creator_user;
    },
    setCreator                     : function ( value ) {
        this.creator_user = new SHINKEN.ELEMENT.UiUser( value );
    },
    setWeatherLinks               : function ( value ) {
        SHINKEN.TOOLS.DICT.deleteKeyEntries( value, "validation_messages" );
        this.weather_links = new WEATHER.LinksForView( value );
    },
    setBehaviourPhase              : function ( value ) {
        var to_set = value;
        if ( value.__class_name__ !== "SHINKEN.OBJECT.ViewBehaviour" ) {
            to_set = new SHINKEN.OBJECT.ViewBehaviour();
            to_set.updateData( value );
        }
        this[ SHINKEN.OBJECT.VIEW.PARAM.VIEW_BEHAVIOUR ] = to_set;
    },
    getNotifications               : function () {
        return this.notifications;
    },
    setNotifications               : function ( value ) {
        this.notifications = new WEATHER.Notifications( value );
    },
    setDelayBeforeDeletion         : function ( delay_before_deletion ) {
        this.delay_before_deletion = delay_before_deletion;
    },
    getViewBehaviourPhase          : function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.VIEW_BEHAVIOUR ];
    },
    getViewBehaviourPhaseLastUpdate: function () {
        return this[ SHINKEN.OBJECT.VIEW.PARAM.VIEW_BEHAVIOUR ].last_update;
    },
    getViewDeletionTime            : function () {
        return this.getViewBehaviourPhaseLastUpdate() + this.delay_before_deletion;
    }
    
};