//priority 17
//__lib__ lib_common_V02_01
"use strict";
var PROPERTY    = PROPERTY || {};
PROPERTY.COMMON = {
    PARAM: {
        PROPERTY_MESSAGES          : "property__messages",
        PROPERTY_OBJECT            : "property__object",
        PROPERTY_NAME              : "property__name",
        COMPOSED_KEY               : "property__composed_key",
        PROPERTY_LIST__COMPOSED_KEY: "property__list__composed_key",
        PROPERTY_LABEL             : "property__label",
        PROPERTY_VALUE             : "property__value",
        PROPERTY_VISIBILITY        : "property__visibility",
        PARENT_OBJECT              : "parent_object",
        DEFAULT_VALUE              : "property__default_value"
    },
    INPUT: {
        SEARCH_INPUT: "search_input",
        MAIN_INPUT  : "main_input"
    }
};

PROPERTY.AbstractCommon = function () {
};

PROPERTY.AbstractCommon.prototype = {
    //********************************************  VIEW ************************************************//
    ___updateView: function () {
    },
    //********************************************  GETTER AND SETTER ************************************************//
    ___unset    : function () {
    },
    getSelector : function () {
    },
    getValue    : function () {
        console.error( "[Abstract - getValue]", "[NOT IMPLEMENTED]", this.type );
    },
    getFlatValue: function () {
        console.error( "[Abstract - getFlatValue]", "[NOT IMPLEMENTED]", this.type );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___clickOnItemSelector : function ( _target_component, key_name ) {
    },
    ___clickOnCheckboxInput: function ( name ) {
    },
    ___clickOnRadioBtn     : function ( value ) {
    },
    ___onFocusOut          : function ( dom_element ) {
    },
    ___hidePopup           : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.AbstractCommon, SHINKEN.OBJECT.ShinkenObjectHtml );

PROPERTY.InterfaceCommon = function () {
};

PROPERTY.InterfaceCommon.prototype = {
    //********************************************  EVENT LISTENER  **************************************************//
    onFocus                : function () {
    },
    onFocusOut             : function ( dom_element ) {
        this.___onFocusOut( dom_element );
    },
    clickOnItemSelector_end: function ( target_component, key_name, dom_element ) {
        this.___clickOnItemSelector( target_component, key_name, dom_element );
    },
    clickOnInput           : function () {
        this.hidePopup();
    },
    clickOnCheckboxInput   : function ( name ) {
        this.___clickOnCheckboxInput( name );
    },
    clickOnRadioBtn        : function ( value ) {
        if ( this.is_disabled ) {
            return;
        }
        this.___clickOnRadioBtn( value );
    },
    keydown                : function ( event, key_code ) {
    },
    //********************************************  SETTER GETTER   **************************************************//
    getName            : function () {
        return this.name;
    },
    getUUID            : function () {
        return this.getName();
    },
    getLabelViaDom     : function () {
        return this.dom_element.querySelector( '.shinken-property-label .shinken-label' ).innerText;
    },
    getNameOrUUID      : function () {
        return this.getName();
    },
    getParentName      : function () {
        return this.name;
    },
    getState           : function () {
        return this.state;
    },
    setState           : function ( _to_set ) {
        this.state = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'state', this.state );
    },
    setLastItemSelected: function ( _to_set ) {
        this.last_list_element_selected = _to_set;
    },
    addClass           : function ( to_add ) {
        this.class_to_add = to_add;
    },
    getValue           : function () {
        return this.value;
    },
    setValue           : function ( _to_set ) {
        this.value = _to_set;
    },
    isSet              : function () {
        const _to_return = this.getValue();
        return !!_to_return;
    },
    setIsDisable       : function ( to_set ) {
        if ( to_set && !this.is_disabled ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        else if ( !to_set && this.is_disabled ) {
            this.dom_element.classList.remove( 'shinken-disabled' );
        }
        this.is_disabled = to_set;
    },
    setIsRequired      : function ( to_set ) {
        this.is_required = to_set;
    },
    unset              : function () {
        this.___unset();
    },
    setValueFromUser   : function () {
        console.warn( "setValueFromUser", "[TYPE NOT MANAGED]", this.type );
    },
    isDifferentValue   : function ( value1, value2 ) {
        return value1 !== value2 && SHINKEN.TOOLS.STRING.unescape_xss( value1 ) !== SHINKEN.TOOLS.STRING.unescape_xss( value2 );
    },
    //********************************************  COMPUTE  *********************************************************//
    _computeState: function () {
    },
    //********************************************  HTML  *********************************************************//
    computeHtml_common: function () {
    },
    //********************************************  VIEW    **********************************************************//
    hidePopup        : function ( exception ) {
        this.___hidePopup( exception );
    },
    updateView       : function () {
        this.___updateView();
    },
    getFlatValueLabel: function () {
    },
    //********************************************  SAVE    **********************************************************//
    getDataToSave: function () {
        return this.getDataToSaveFinal();
    },
    onClick      : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, PROPERTY.AbstractCommon );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, SHINKEN.OBJECT.CounterInterface );


PROPERTY.InterfaceCommonFromHtml = function () {
};

PROPERTY.InterfaceCommonFromHtml.prototype = {
    initWithDomElement: function ( element ) {
        this.name             = element.dataset.name;
        this.type             = element.dataset.type;
        this.dom_element      = element;
        this.default_value    = element.dataset.defaultValue;
        this.parent_container = null;
        this.is_disabled      = element.classList.contains( 'shinken-disabled' );
        this.initCounters( null, true );
        this.setIsRequired( element.dataset.isRequired );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromHtml, PROPERTY.InterfaceCommon );



PROPERTY.InterfaceCommonFromData = function () {
};

PROPERTY.InterfaceCommonFromData.prototype = {
    //********************************************  HTML  *********************************************************//
    computeHtml_getClassContainer       : function () {
        return "shinken-element-property-line shinken-parent-event-listener " + (this.class_to_add || "");
    },
    computeHtml_getType                 : function () {
        return "";
    },
    computeHtml_getAttribute            : function () {
        const _to_return                      = this.computeHtml_getAttributeSpecific();
        _to_return[ "class" ]                 = this.computeHtml_getClassContainer();
        _to_return[ "onmouseenter" ]          = "MANAGER.EventManager.mouseEnter(event)";
        _to_return[ "onmouseleave" ]          = "MANAGER.EventManager.mouseLeave(event)";
        _to_return[ "onclick" ]               = "MANAGER.EventManager.onClick(event)";
        _to_return[ "data-controller" ]       = this.controller_name || CONTROLLER.CONST.FORM_CONTROLLER.NAME;
        _to_return[ "data-type" ]             = this.computeHtml_getType();
        _to_return[ "data-name" ]             = this.getName();
        _to_return[ "data-visibility-state" ] = this.getVisibilityState();
        return _to_return;
    },
    computeHtml_getAttributeSpecific    : function () {
        return {};
    },
    computeHtml_getCellPropAction       : function () {
        this.dom_cell_action = DOM.Service.createElement( "td", { class: "shinken-prop-cell-action" } );
        this.computeHtml_getCellPropActionContent();
        this.addDomElement( this.dom_cell_action );
    },
    computeHtml_getCellPropActionContent: function () {
    },
    computeHtml_container               : function () {
        this.label_common = new PROPERTY.LabelCommonFromData( this.getName(), this.getLabel() || this.getName() );
        this.label_common.computeHtml();
        this.setDomElement( DOM.Service.createElement( "tr", this.computeHtml_getAttribute() ) );
        this.addDomElement( this.label_common.getDomElement() );
        this.computeHtml_getCellPropAction();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData, PROPERTY.InterfaceCommon );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData, SHINKEN.OBJECT.ShinkenObjectHtml );

PROPERTY.InterfaceCommonFromData_V3 = function () {
};

PROPERTY.InterfaceCommonFromData_V3.prototype = {
    //********************************************  HTML  *********************************************************//
    computeHtml_getClassContainer       : function () {
        return "shinken-element-property-line-V3 shinken-layout-center-v " + (this.class_to_add || "");
    },
    computeHtml_getType                 : function () {
        return "";
    },
    computeHtml_getAttribute            : function () {
        const _to_return                      = this.computeHtml_getAttributeSpecific();
        _to_return[ "class" ]                 = this.computeHtml_getClassContainer();
        _to_return[ "onmouseenter" ]          = "MANAGER.EventManager.mouseEnter(event)";
        _to_return[ "onmouseleave" ]          = "MANAGER.EventManager.mouseLeave(event)";
        _to_return[ "onclick" ]               = "MANAGER.EventManager.onClick(event)";
        _to_return[ "data-type" ]             = this.computeHtml_getType();
        _to_return[ "data-name" ]             = this.getName();
        _to_return[ "data-visibility-state" ] = this.getVisibilityState();
        return _to_return;
    },
    computeHtml_getAttributeSpecific    : function () {
        return {};
    },
    computeHtml_getCellPropAction       : function () {
        this.dom_cell_action = DOM.Service.createElement( "div", { class: "shinken-prop-cell-action-V3" } );
        this.computeHtml_getCellPropActionContent();
        this.addDomElement( this.dom_cell_action );
    },
    computeHtml_getCellPropActionContent: function () {
    },
    computeHtml_container               : function () {
        this.label_common = new PROPERTY.LabelCommonFromData_V3( this.getName(), this.getLabel() || this.getName() );
        this.label_common.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", this.computeHtml_getAttribute() ) );
        this.addDomElement( this.label_common.getDomElement() );
        this.computeHtml_getCellPropAction();
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        switch ( event_name ) {
            case "undo_last_modification":
            case "redo_last_modification":
                const new_value = param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getNextOrPrevious( event_name );
                this.doActionAfter( "property_value__set__by_js", { [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: new_value } );
                this.previous_modication_data = this.getDataForLastModification();
                break;
        }
    },
    getDataForLastModification   : function ( params ) {
        return this.getDataToSave();
    },
    getLastModificationElement   : function () {
        let to_return;
        let element_modified          = this;
        let previous                  = this.previous_modication_data;
        let next                      = this.getDataForLastModification();
        to_return                     = new SHINKEN.OBJECT.LastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.PROPERTY_MODIFICATION, element_modified, previous, next );
        this.previous_modication_data = this.getDataForLastModification();
        
        return to_return;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData_V3, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData_V3, PROPERTY.InterfaceCommon );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData_V3, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData_V3, SHINKEN.OBJECT.EditableElementInterface );


PROPERTY.LabelCommonFromData           = function ( name, label ) {
    this.name  = name;
    this.label = label;
};
PROPERTY.LabelCommonFromData.prototype = {
    //********************************************  HTML  *********************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-prop-cell-label" } ) );
        const _table        = DOM.Service.addElementTo( DOM.Service.createElement( "table", { class: "shinken-width-100" } ), this.getDomElement() );
        const _tr           = DOM.Service.addElementTo( DOM.Service.createElement( "tr", { class: "shinken-width-100" } ), _table );
        const _td_1         = DOM.Service.addElementTo( DOM.Service.createElement( "td", {} ), _tr );
        const _div_1        = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-prop-cell-label-container" } ), _td_1 );
        const _table_1      = DOM.Service.addElementTo( DOM.Service.createElement( "table" ), _div_1 );
        const _tr_1_1       = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table_1 );
        const _td_1_1       = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-property-label" } ), _tr_1_1 );
        const _span_1_1_1   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter shinken-error-counter", "data-number": "" } ), _td_1_1 );
        const _span_1_1_1_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter-label" } ), _span_1_1_1 );
        const _span_1_1_2   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter shinken-warning-counter", "data-number": "" } ), _td_1_1 );
        const _span_1_1_2_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter-label" } ), _span_1_1_2 );
        const _span_1_1_3   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label" }, this.label ), _td_1_1 );
        
        const _tr_1_2       = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table_1 );
        const _td_1_2       = DOM.Service.addElementTo( DOM.Service.createElement( "td" ), _tr_1_2 );
        const _span_1_2_1   = DOM.Service.addElementTo( DOM.Service.createElement( "span", {
            class         : "shinken-information-tag",
            onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
            onMouseLeave  : "SHINKEN_TOOLTIP.hideTooltip()",
            "shi-tip-html": ""
        } ), _td_1_2 );
        const _span_1_2_1_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label-information" } ), _span_1_2_1 );
        const _span_1_2_1_2 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-tag-mark" }, "?" ), _span_1_2_1 );
        
        const _td_2  = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-tag-help-cell" } ), _tr );
        const _div_2 = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-tag-help shinken-user-select-none", onclick: "MANAGER.EventManager.clickOnForcedHelpButton(event,this)" }, "?" ), _td_2 );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelCommonFromData, SHINKEN.OBJECT.ShinkenObjectHtml );


PROPERTY.LabelCommonFromData_V3           = function ( name, label ) {
    this.name  = name;
    this.label = label;
};
PROPERTY.LabelCommonFromData_V3.prototype = {
    //********************************************  HTML  *********************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-prop-cell-label-V3 shinken-layout-center-h-v " } ) );
        const _div_1        = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-prop-cell-label-container" } ), this.getDomElement() );
        const _span_1_1_1   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter shinken-error-counter", "data-number": "" } ), _div_1 );
        const _span_1_1_1_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter-label" } ), _span_1_1_1 );
        const _span_1_1_2   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter shinken-warning-counter", "data-number": "" } ), _div_1 );
        const _span_1_1_2_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter-label" } ), _span_1_1_2 );
        const _span_1_1_3   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label" }, this.label ), _div_1 );
        const _div_2        = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-tag-help shinken-user-select-none", onclick: "MANAGER.EventManager.clickOnForcedHelpButton(event,this)" }, "?" ), this.getDomElement() );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelCommonFromData_V3, SHINKEN.OBJECT.ShinkenObjectHtml );
