//priority 21
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.RadioMode           = function ( name, label ) {
    this.init( name, label );
};
SHINKEN.OBJECT.RadioMode.prototype = {
    init             : function ( name, label ) {
        this.initPhase();
        this.name  = name;
        this.class = "shinken-radio-mode";
        if ( label ) {
            this.setLabel( label );
        }
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "property_value__set__by_js":
            case "property_value__set__by_data":
                this.setPhase( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] === this.getName() ? SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING : SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                break;
            case "change_radio_mode":
            case "change_radio_mode_by_js":
                this.setPhase( param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] === this.getName() ? SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING : SHINKEN.OBJECT.CONST.PHASE.SLEEPING );
                this.countersShowForParent( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING ) );
                break;
            case "add_message_validation":
                this.setMessage( param[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ] );
                return;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID     : function () {
        return this.name;
    },
    getName     : function () {
        return this.getUUID();
    },
    getValue    : function () {
        return this.getName();
    },
    setMessage  : function ( message ) {
        var _status = COMPONENT.CONST.STATUS.NONE;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [0, 0];
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.setTooltipHtml( message.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.setTooltipHtml( message.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.setTooltipHtml( message ? message.buildMessageGeneric() : "", "" );
                break;
        }
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.getUUID(), _counter[ 0 ] );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.getUUID(), _counter[ 1 ] );
    },
    setIsDefault: function ( default_value ) {
        this.addClass( "shinken-is-default" );
        this.default_value = default_value;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml              : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
        this.setPhaseDomElement( this.getDomElement() );
        this.addCountersTargetDomElement( this.getDomElement() );
    },
    computeCommonHtml        : function () {
        this.addParamForEvents( SHINKEN.OBJECT.RADIOMODE.PARAM.NAME, this.getName() );
        this.addParamForEvents( MANAGER.EVENT_MANAGER_V2.PARAM.STOP_PROPAGATION, true );
        this.setDomElement( DOM.Service.createElement( "div", {
            class: this.getClass(), "data-name": this.name, "onclick": "MANAGER.EventManagerV2.doActionAfter(event,'change_radio_mode'," + this.parseParamForEventsToHtml() + ")"
        } ) );
        if ( this.default_value !== undefined ) {
            this.getDomElement().dataset.defaultValue = this.default_value;
        }
        let title_zone        = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-title-zone shinken-layout-center-h-v shinken-layout-justify-between" } ) );
        this.dom_content_zone = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-content-zone" } ) );
        
        let title_left_zone = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-title-zone-left shinken-layout-left-h-center-v" } ), title_zone );
        if ( this.getIconHtml() || this.getIconSrc() ) {
            let title_label = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-title-icon-container" } ), title_left_zone );
            if ( this.getIconHtml() ) {
                DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-radio-icon" }, this.getIconHtml() ), title_label );
            }
            else if ( this.getIconSrc() ) {
                DOM.Service.addElementTo( DOM.Service.createElement( "img", { class: "shinken-radio-icon", src: this.getIconSrc() } ), title_label );
            }
        }
        let tooltipPosition = (typeof this.getTooltipPosition === 'function' && this.getTooltipPosition()) ? this.getTooltipPosition() : SHINKEN_TOOLTIP.PLACEMENT.TOP;
        
        if ( this.getShortCutLetter() ) {
            let title_right_zone = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-title-zone-right" } ), title_zone );
            DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-title-short-cut-container" }, this.getShortCutLetter() ), title_right_zone );
            DOM.Service.addElementTo( DOM.Service.createElement( "div", {
                class                       : "shinken-icon shinkon shinkon-question",
                "onmouseenter"              : "SHINKEN_TOOLTIP.showTooltip(this)",
                "onmouseleave"              : "SHINKEN_TOOLTIP.hideTooltip()",
                "shi-tip-html"              : this.getHelpHtml(),
                "shi-tip-is-forced-position": tooltipPosition,
                "shi-tip-type"              : "help_weather_tooltip"
            } ), title_right_zone );
        }
        DOM.Service.addElementTo( this.getLabelDomElement(), title_left_zone );
        
        this.computeHtmlExtra();
    },
    getLabelDomElement       : function () {
        return DOM.Service.createElement( "div", { class: "shinken-label-container" }, this.label );
    },
    computeSpecificHtml      : function () {
        //this.getDomElement().innerHTML = this.label;
    },
    getIconClass             : function () {
        return "";
    },
    getIconSrc               : function () {
        return "";
    },
    getIconHtml              : function () {
        return "";
    },
    getShortCutLetter        : function () {
        return "";
    },
    getTooltipPosition       : function () {
        return "";
    },
    getHelpHtml              : function () {
        let contents = this.getHelpContents();
        if ( !contents.length ) {
            return "";
        }
        return this.getHelpHtmlFromContents( contents );
    },
    getHelpHtmlFromContents  : function ( contents ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-container", "data-help-parent-name": this.getUUID() } );
        contents.forEach( content => {
            DOM.Service.addElementTo( this.getHelpHtmlLineContent( content ), to_return );
        } );
        return to_return.outerHTML;
    },
    getHelpHtmlLineContent   : function ( content ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-content " + this.getHelpSpecificClass() } );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-title" }, content.label ), to_return );
        let element_content = this.getHelpHtmlElementContent( content );
        if ( element_content ) {
            DOM.Service.addElementTo( element_content, to_return );
        }
        return to_return;
    },
    getHelpSpecificClass     : function ( content ) {
        return "shinken-tooltip-help-action";
    },
    getHelpHtmlElementContent: function ( content ) {
        let type_content = content.type_content;
        let to_return;
        switch ( type_content ) {
            case "label_&_content":
            case "image_&_content":
                to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-elements" } );
                if ( content.elements ) {
                    content.elements.forEach( content_element => {
                        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: content_element.className }, content_element.content ), to_return );
                    } );
                    return to_return;
                }
                break;
            case"full_line_content":
                to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-inline-multiline-elements" } );
                if ( content.elements ) {
                    content.elements.forEach( content_element => {
                        DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: content_element.className }, content_element.content ), to_return );
                    } );
                    return to_return;
                }
                break;
            case "ordered_title":
                to_return = DOM.Service.createElement( "div", { class: "shinken-tooltip-help-action-inline-multiline-elements" } );
                DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: content.elements[ 0 ].className }, `${content.ordered_value} / ${content.elements[ 0 ].content}` ), to_return );
                return to_return;
        }
    },
    getHelpContents          : function () {
        return [];
    }
}
;

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioMode, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioMode, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioMode, SHINKEN.OBJECT.CounterInterfaceV2 );


SHINKEN.OBJECT.CheckBoxRadioMode           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN.OBJECT.CheckBoxRadioMode.prototype = {
    initSpecific: function ( name, label ) {
        this.init( name, label );
        this.addClass( "shinken-radio-with-checkbox" );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  GETTER SETTER  *****************************************************//
    getIconHtml: function () {
        if ( !WEATHER.CONST.COMPONENT.SVG.RADIO_ICON ) {
            WEATHER.CONST.COMPONENT.SVG.RADIO_ICON = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-radio-button-svg" ) ).outerHTML;
        }
        return WEATHER.CONST.COMPONENT.SVG.RADIO_ICON;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CheckBoxRadioMode, SHINKEN.OBJECT.RadioMode );

SHINKEN.OBJECT.CheckBoxRadioMode__WithSelector           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.CheckBoxRadioMode__WithSelector.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
        this.selector__20241122 = new COMPONENT.SingleSelectFromData_V3( name, COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR );
        this.selector__20241122.addParamsForEvents( this.getParamForEvents() );
        this.addClass( "shinken-radio-with-checkbox shinken-radio-with-select" );
    },
    addOption   : function ( to_add ) {
        this.selector__20241122.addOption( to_add );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "set_default_value_in_selector":
            case "add_message_validation":
            case "property_value__set__by_js":
            case "ask_hide_pop_up":
            case "click_done":
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
            case "property_value__set__by_data":
            case "change_selector_default_title":
                this.selector__20241122.doActionAfter( event_name, param );
                return;
            case "change_radio_mode":
                this.selector__20241122.doActionAfter( "ask_hide_pop_up", param );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  GETTER SETTER  **************************************************//
    addParamForEvents: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        this.selector__20241122.addParamForEvents( key, value );
    },
    getValue         : function () {
        return this.selector__20241122.getValue();
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        this.selector__20241122.doActionAfterLastModification( event_name, param );
    },
    getDataForLastModification   : function ( params ) {
        return this.selector__20241122.getDataForLastModification();
    },
    //********************************************  HTML  *****************************************************//
    getLabelDomElement: function () {
        this.selector__20241122.computeHtml();
        var to_return = DOM.Service.createElement( "div", { class: "shinken-label-container" } );
        DOM.Service.addElementTo( this.selector__20241122.getDomElement(), to_return );
        return to_return;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CheckBoxRadioMode__WithSelector, SHINKEN.OBJECT.CheckBoxRadioMode );


SHINKEN.OBJECT.CheckBoxRadioMode__WithStringInput           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.CheckBoxRadioMode__WithStringInput.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
        this.input__20241122 = new COMPONENT.InputFromData_V3( name );
        this.input__20241122.addParamsForEvents( this.getParamForEvents() );
        this.input__20241122.setCountersParent( this );
        this.addClass( "shinken-radio-with-checkbox shinken-radio-with-input" );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_message_validation":
            case "onchange_in_input_V3":
            case "click_on_button_V3":
            case "property_value__set__by_data":
            case "property_value__set__by_js":
            case "set_placeholder_input_V3":
            case "clean_validation_error":
                this.input__20241122.doActionAfter( event_name, param );
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  GETTER SETTER  **************************************************//
    getValue         : function () {
        return this.input__20241122.getValue();
    },
    addParamForEvents: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        this.input__20241122.addParamForEvents( key, value );
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        this.input__20241122.doActionAfterLastModification( event_name, param );
    },
    getDataForLastModification   : function ( params ) {
        return this.input__20241122.getDataForLastModification();
    },
    //********************************************  HTML  *****************************************************//
    getLabelDomElement: function () {
        this.input__20241122.computeHtml();
        var to_return = DOM.Service.createElement( "div", { class: "shinken-label-container" } );
        DOM.Service.addElementTo( this.input__20241122.getDomElement(), to_return );
        return to_return;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CheckBoxRadioMode__WithStringInput, SHINKEN.OBJECT.CheckBoxRadioMode );