//priority 3
//__lib__ lib_common
"use strict";
SHINKEN.TOOLS.DICT = (function ( self ) {
    self.contains                                 = function ( dict, key_to_find ) {
        return dict.hasOwnProperty( key_to_find );
    };
    self.assign                                   = function ( dest, src ) {
        var _keys = Object.keys( src );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key         = _keys[ i ];
            dest[ _current_key ] = src[ _current_key ];
        }
        return dest;
    };
    self.assigns                                  = function ( dest, srcs ) {
        return srcs.reduce( self.assign, dest );
    };
    self.clone                                    = function ( to_clone ) {
        var json = JSON.stringify( to_clone );
        return JSON.parse( json );
    };
    self.deleteEntry                              = function ( dict_object, key_to_delete ) {
        var to_return = dict_object[ key_to_delete ];
        delete dict_object[ key_to_delete ];
        return to_return;
    };
    self.deleteKeyEntries                         = function ( dict_object, key_to_delete ) {
        delete dict_object[ key_to_delete ];
        var _keys = Object.keys( dict_object );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( typeof dict_object[ _keys[ i ] ] === "object" ) {
                self.deleteKeyEntries( dict_object[ _keys[ i ] ], key_to_delete );
            }
        }
    };
    self.parseToHTMLParam                         = function ( dict_object ) {
        let to_return = "{";
        var _keys     = Object.keys( dict_object );
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( i ) {
                to_return += ",";
            }
            to_return += "'" + _keys[ i ] + "':'" + dict_object[ _keys[ i ] ] + "'";
        }
        to_return += "}";
        return to_return;
    };
    self.replaceValuesForGivenKeyInDict           = function ( dict_object, key, value_to_replace, new_value ) {
        if ( typeof dict_object !== 'object' || dict_object === null ) {
            return dict_object;
        }
        const _keys = Object.keys( dict_object );
        let _current_key;
        for ( let i = 0, size = _keys.length; i < size; i++ ) {
            _current_key = _keys[ i ];
            if ( dict_object[ _current_key ] ) {
                if ( _current_key === key && dict_object[ _current_key ] === value_to_replace ) {
                    dict_object[ _current_key ] = new_value;
                }
                else if ( typeof dict_object[ _current_key ] === 'object' && dict_object[ _current_key ] !== null ) {
                    self.replaceValuesForGivenKeyInDict( dict_object[ _current_key ], key, value_to_replace, new_value );
                }
            }
        }
        return dict_object;
    };
    self.updateWithDict                           = function ( dict_dest, dict_src ) {
        if ( typeof dict_src !== 'object' || dict_src === null ) {
            return dict_dest;
        }
        const keys = Object.keys( dict_src );
        let current_key;
        for ( let i = 0, size = keys.length; i < size; i++ ) {
            current_key = keys[ i ];
            if ( typeof dict_src[ current_key ] !== 'object' || dict_dest[ current_key ] === undefined ) {
                dict_dest[ current_key ] = dict_src[ current_key ];
            }
            else {
                self.updateWithDict( dict_dest[ current_key ], dict_src[ current_key ] );
            }
        }
        return dict_dest;
    };
    self.isEquals                                 = function ( dict_object_1, dict_object_2 ) {
        const keys_1 = Object.keys( dict_object_1 );
        const keys_2 = Object.keys( dict_object_2 );
        
        if ( keys_1.length !== keys_2.length ) {
            return false;
        }
        for ( const key of keys_1 ) {
            if ( !keys_2.includes( key ) ) {
                return false;
            }
            const value_1 = dict_object_1[ key ];
            const value_2 = dict_object_2[ key ];
            if ( typeof value_1 === 'object' && value_1 !== null && typeof value_2 === 'object' && value_2 !== null ) {
                if ( !self.isEquals( value_1, value_2 ) ) {
                    return false;
                }
            }
            else if ( value_1 !== value_2 ) {
                return false;
            }
        }
        
        return true;
    };
    //********************************************  COMPOSED KEY   **************************************************//
    self.parseKeyComposedToKey                    = function ( dict_object, key_composed, value ) {
        const key_composed_split = key_composed.split( "." );
        if ( key_composed_split.length === 1 ) {
            dict_object[ key_composed_split ] = value;
            return;
        }
        dict_object[ key_composed_split[ 0 ] ] = dict_object[ key_composed_split[ 0 ] ] || {};
        self.parseKeyComposedToKey( dict_object[ key_composed_split[ 0 ] ], key_composed_split.slice( 1 ).join( "." ), value );
    };
    self.getObjectWithComposedKey                 = function ( dict_object, key_composed ) {
        if ( !key_composed ) {
            return dict_object;
        }
        const key_composed_split = key_composed.split( "." );
        let new_key_composed     = "";
        if ( key_composed_split.length > 1 ) {
            new_key_composed = key_composed_split.slice( 1 ).join( "." );
        }
        return self.getObjectWithComposedKey( dict_object[ key_composed_split[ 0 ] ] || dict_object, new_key_composed );
    };
    self.getObjectWithComposedKey_fromStartKey    = function ( dict_object, key_composed, start_key ) {
        const key_composed_split = key_composed.split( "." );
        const new_key_composed   = key_composed_split.slice( key_composed_split.indexOf( start_key ) + 1 ).join( "." );
        return self.getObjectWithComposedKey( dict_object, new_key_composed );
    };
    self.getValueWithComposedKey                  = function ( dict_object, key ) {
        const split_keys = key.split( "." );
        if ( split_keys.length === 1 ) {
            return dict_object[ key ];
        }
        return self.getValueWithComposedKey( dict_object[ split_keys[ 0 ] ] || dict_object, split_keys.slice( 1 ).join( "." ) );
    };
    self.getValueWithComposedKey_WithValue        = function ( dict_object, key_composed ) {
        const _keys = Object.keys( dict_object );
        if ( _keys.length === 1 && _keys[ 0 ] === SHINKEN.OBJECT.CONST.PARAM.VALUE ) {
            return self.getValueWithComposedKey_WithValue( dict_object[ SHINKEN.OBJECT.CONST.PARAM.VALUE ], key_composed );
        }
        const key_composed_split = key_composed.split( "." );
        if ( key_composed_split.length === 1 ) {
            return dict_object[ key_composed ];
        }
        return self.getValueWithComposedKey_WithValue( dict_object[ key_composed_split[ 0 ] ], key_composed_split.slice( 1 ).join( "." ) );
    };
    return self;
})
( SHINKEN.TOOLS.DICT || {} );
