//priority 10
//__lib__ lib_common
DOM.ServiceEllipsis = (function ( self ) {
    "use strict";
    var __canvas  = document.createElement( "canvas" );
    var __context = __canvas.getContext( "2d" );
    
    var __size_distributor = {};
    
    self.getSizeDistributor   = function () {
        return __size_distributor;
    };
    self.ellipsis             = function ( dom_element, text, font, nb_line ) {
        DOM.Service.empty( dom_element );
        var _to_return = {
            width       : DOM.Service.getBoundingClientRect( dom_element, DOM.CONST.STYLE.WIDTH ),
            height      : DOM.Service.getBoundingClientRect( dom_element.parentElement, DOM.CONST.STYLE.HEIGHT ),
            text        : "",
            has_ellipsis: false,
            line_number : 1
        };
        if ( !_to_return.width || !_to_return.height ) {
            return _to_return;
        }
        var _text_to_split     = self.splitByWidth_toArray( text, _to_return.width, font );
        _to_return.line_number = _text_to_split.length;
        
        for ( var i = 0; i < nb_line; i++ ) {
            if ( _to_return.line_number <= i ) {
                break;
            }
            _to_return.text += _text_to_split[ i ];
        }
        if ( _to_return.line_number > nb_line ) {
            _to_return.text         = _to_return.text.substring( 0, _to_return.text.length - 3 );
            _to_return.text += "...";
            _to_return.has_ellipsis = true;
            _to_return.line_number  = nb_line;
        }
        dom_element.innerText = _to_return.text;
        if ( _to_return.height < DOM.Service.getBoundingClientRect( dom_element, DOM.CONST.STYLE.HEIGHT ) && nb_line > 1 ) {
            return self.ellipsis( dom_element, text, font, nb_line - 1 );
        }
        return _to_return;
    };
    self.splitByWidth_toArray = function ( text, width, font ) {
        var _to_return = [];
        var _temp_text = text;
        while ( _temp_text ) {
            var _split = self.splitByWidth_toLine( _temp_text, width, font );
            if ( !_split ) {
                return _to_return;
            }
            _to_return.push( _split );
            if ( _split === _temp_text ) {
                _temp_text = "";
            }
            else {
                _temp_text = _temp_text.substring( _split.length );
            }
        }
        return _to_return;
    };
    self.splitByWidth_toLine  = function ( text, width, font ) {
        var _to_return     = "";
        var _current_width = 0;
        var _split_text    = text.split( "" );
        for ( var i = 0, _size_i = _split_text.length; i < _size_i; i++ ) {
            _current_width += self.getCharMeasure( _split_text[ i ], font );
            if ( _current_width > width ) {
                return _to_return;
            }
            else {
                _to_return = _to_return + _split_text[ i ];
            }
        }
        return _to_return;
    };
    self.getTextMeasure       = function ( text, font ) {
        var _to_return  = 0;
        var _split_text = text.split( "" );
        for ( var i = 0, _size_i = _split_text.length; i < _size_i; i++ ) {
            _to_return += self.getCharMeasure( _split_text[ i ], font );
        }
        return _to_return;
    };
    self.getTextMeasureHeight = function ( text, font ) {
        __context.font = font;
        return (__context.measureText( text )).fontBoundingBoxAscent;
    };
    self.getCharMeasure       = function ( char, font ) {
        if ( !__size_distributor[ font ] ) {
            __size_distributor[ font ] = {};
        }
        if ( !__size_distributor[ font ][ char ] ) {
            __size_distributor[ font ][ char ] = self._measureChar( char, font );
        }
        return __size_distributor[ font ][ char ];
    };
    self._measureChar         = function ( letter, font ) {
        __context.font = font;
        return __context.measureText( letter ).width;
        
    };
    return self;
})( DOM.ServiceEllipsis || {} );
