//__lib__ lib_common
"use strict";

SHINKEN_GRID.ViewHistory           = function () {
};
SHINKEN_GRID.ViewHistory.prototype = {
    //********************************************  INIT  *****************************************************//
    
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  BACKEND  *****************************************************//
    
    //********************************************  PARSING BACKEND  *****************************************************//
    parseBackendDataLine                 : function ( data ) {
        return this.parseBackendDataLineGrid( data );
    },
    parseBackendDataLineGrid             : function ( data ) {
        switch ( data.action.type ) {
            case "UPDATE":
                return this.parseBackendDataLineForActionUpdate( data );
            case "DELETE":
                return this.parseBackendDataLineForActionDeletion( data );
            default:
                return this.parseBackendDataLineCommon( data );
        }
    },
    parseBackendDataLineForActionDeletion: function ( data ) {
        let to_return = this.initBackendDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] += _( "history.action.delete", [DICTIONARY_COMMON_UI] );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.shared_links_removed_from_groups", [DICTIONARY_VISU_UI] ) ) + "</div>";
        
        return to_return;
    },
    parseBackendDataLineForActionUpdate  : function ( data ) {
        let to_return           = this.initBackendDataLineParser( data );
        let text_history_update = "";
        if ( data.action.context.published.new && !data.action.context.published.old ) {
            text_history_update += "<div class='shinken-history-action'>" + _( "history.views.weather.update_publish", [DICTIONARY_VISU_UI] ) + "</div>";
        }
        if ( data.action.context.nb_widgets.old > data.action.context.nb_widgets.new ) {
            let nb_widgets = data.action.context.nb_widgets.old - data.action.context.nb_widgets.new;
            if ( nb_widgets === 1 ) {
                text_history_update += "<div class='shinken-history-action'>" + _( "history.views.weather.update_remove_widget", [DICTIONARY_VISU_UI] ) + "</div>";
            }
            else {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.update_remove_widgets", [DICTIONARY_VISU_UI] ), nb_widgets ) + "</div>";
            }
        }
        if ( data.action.context.nb_widgets.old < data.action.context.nb_widgets.new ) {
            let nb_widgets = data.action.context.nb_widgets.new - data.action.context.nb_widgets.old;
            if ( nb_widgets === 1 ) {
                text_history_update += "<div class='shinken-history-action'>" + _( "history.views.weather.update_add_widget", [DICTIONARY_VISU_UI] ) + "</div>";
            }
            else {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.update_add_widgets", [DICTIONARY_VISU_UI] ), nb_widgets ) + "</div>";
            }
        }
        if ( data.action.context.new_links.length > 0 ) {
            for ( let i = 0; i < data.action.context.new_links.length; i++ ) {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.new_link", [DICTIONARY_VISU_UI] ), data.action.context.new_links[ i ].link_name ) + "</div>";
            }
        }
        if ( data.action.context.removed_links.length > 0 ) {
            for ( let j = 0; j < data.action.context.removed_links.length; j++ ) {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.remove_link", [DICTIONARY_VISU_UI] ), data.action.context.removed_links[ j ].link_name ) + "</div>";
            }
        }
        
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = text_history_update;
        return to_return;
    },
    //********************************************  PARSING LAST MODIFICATIONS  *****************************************************//
    parseLastModificationDataLine                : function ( data ) {
        return this.parseLastModificationDataLineGrid( data );
    },
    parseLastModificationDataLineGrid            : function ( data ) {
        switch ( data.type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.MOVE:
                return this.parseLastModificationDataLineMove( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.RESIZE:
                return this.parseLastModificationDataLineResize( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.CREATE:
                return this.parseLastModificationDataLineAddChild( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_WIDGET_VALUE_MODIFICATION:
                return this.parseLastModificationDataLineEdit( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_DEFAULT_VALUE_MODIFICATION:
                return this.parseLastModificationDataLineDefaultEdit( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.DELETE:
                return this.parseLastModificationDataLineDelete( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_LINK_VALUE_MODIFICATION:
                return this.parseLastModificationDataLineExternalLinkEdit( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_ADD_LINK:
                return this.parseLastModificationDataLineAddExternalLink( data );
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.FORM_EXTERNAL_REMOVE_LINK:
                return this.parseLastModificationDataLineRemoveExternalLink( data );
            default:
                this.parseLastModificationDataLineCommon( data );
                return;
        }
    },
    parseLastModificationDataLineResize          : function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = SHINKEN.TOOLS.STRING.format( _( "history.views.weather.widget_resized", [DICTIONARY_VISU_UI] ), data.contents[ 0 ].next.width.getUserValue(), data.contents[ 0 ].next.height.getUserValue() );
        return to_return;
    },
    parseLastModificationDataLineMove            : function ( data ) {
        let to_return    = this.initCurrentChangesDataLineParser( data );
        let y_prev       = data.contents[ 0 ].previous.position_y.value;
        let y_next       = data.contents[ 0 ].next.position_y.value;
        let x_prev       = data.contents[ 0 ].previous.position_x.value;
        let x_next       = data.contents[ 0 ].next.position_x.value;
        let nb_of_widget = 0;
        for ( let i = 0; i < data.contents.length; i++ ) {
            if ( data.contents[ i ].type_modification === SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE ) {
                nb_of_widget++;
            }
        }
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = SHINKEN.TOOLS.STRING.format( _( "history.views.weather.widget_moved", [DICTIONARY_VISU_UI] ), nb_of_widget, `x:${x_prev} , y:${y_prev}`, `x:${x_next} , y:${y_next}` );
        return to_return;
    },
    parseLastModificationDataLineAddChild        : function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.widget_created", [DICTIONARY_VISU_UI] );
        return to_return;
    },
    parseLastModificationDataLineEdit            : function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.widget_edited", [DICTIONARY_VISU_UI] );
        return to_return;
    },
    parseLastModificationDataLineDefaultEdit     : function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.default_value_edited", [DICTIONARY_VISU_UI] );
        return to_return;
    },
    parseLastModificationDataLineExternalLinkEdit: function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.external_link_edited", [DICTIONARY_VISU_UI] );
        return to_return;
    },
    parseLastModificationDataLineAddExternalLink : function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.add_new_link", [DICTIONARY_VISU_UI] );
        return to_return;
    },
    parseLastModificationDataLineRemoveExternalLink : function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.delete_external_link", [DICTIONARY_VISU_UI] );
        return to_return;
    },
    parseLastModificationDataLineDelete          : function ( data ) {
        const nb_of_widget_deleted = data.contents.length;
        let to_return              = this.initCurrentChangesDataLineParser( data );
        if ( nb_of_widget_deleted > 1 ) {
            to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = SHINKEN.TOOLS.STRING.format( _( "history.views.weather.update_remove_widgets", [DICTIONARY_VISU_UI] ), nb_of_widget_deleted );
        }
        else {
            to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.update_remove_widget", [DICTIONARY_VISU_UI] );
        }
        return to_return;
    },
    parseLastModificationDataLineConfig          : function ( data ) {
        let to_return                                                     = this.initCurrentChangesDataLineParser( data );
        to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.views.weather.widget_edited", [DICTIONARY_VISU_UI] );
        return to_return;
    }
};



SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.ViewHistory, SHINKEN.OBJECT.ViewHistory );