//__lib__ lib_common_V02_01
"use strict";

SHINKEN_GRID.Cell           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cell.prototype = {
    init             : function ( data ) {
        this.initInternal();
        this.initPhase();
        this.class = "shinken-grid-cell shinken-no-opacity";
        this.updateData( data );
        this.setUUID();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        if ( __has_edit_mode__ ) {
            this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
            this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED );
        }
    },
    //********************************************  EVENT LISTENER  *********************************************//
    doActionAfter      : function ( event_name, params ) {
        return this.doActionAfterCommon( event_name, params );
    },
    doActionAfterCommon: function ( event_name, params ) {
        switch ( event_name ) {
            case "click_on_button_V3":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "toggle_remove_grid_cell_from_delete_list":
                        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.getUUID(), this.getCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED ) ? 0 : 1 );
                        break;
                }
                break;
            case "focus_on_dom_element":
                if ( !this.getDomElement() ) {
                    return;
                }
                DOM.Service.askAddClass( this.getDomElement(), 'shinken-pulsate', 1600 );
                if ( !DOM.Service.isElementOnScreen( this.getDomElement() ) ) {
                    DOM.Service.focusOnAnchor_withDom( this.getDomElement(), this.dom_parent_with_scroll, false, 200 );
                }
                break;
            case "mouse_down_on_grid_cell":
                if ( !params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].isPhase( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT ) ) {
                    break;
                }
                if ( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey ) {
                    break;
                }
                switch ( this.getCurrentPhase() ) {
                    case SHINKEN.OBJECT.CONST.PHASE.SELECTED:
                        this.selection_event_in_progress = true;
                        break;
                    default:
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                        break;
                }
                break;
            case "mouse_up_on_grid_cell":
                if ( this.selection_event_in_progress ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                    this.selection_event_in_progress = false;
                    this.updateSize();
                }
                break;
            case "move_selected_grid_cell":
                this.selection_event_in_progress = false;
                if ( !this.starting_clone ) {
                    this.initStartingZone();
                    this.initEndingZone();
                }
                this.setDomElementStyle( "left", this.tile_pixel_size * this.starting_clone.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ) + params[ SHINKEN.OBJECT.OVERLAYFRAME.CONST.EVENT.DELTA_X ] );
                this.setDomElementStyle( "top", this.tile_pixel_size * this.starting_clone.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ) + params[ SHINKEN.OBJECT.OVERLAYFRAME.CONST.EVENT.DELTA_Y ] );
                
                this.updateEndingClone( params[ SHINKEN.OBJECT.OVERLAYFRAME.CONST.EVENT.DELTA_X ], params[ SHINKEN.OBJECT.OVERLAYFRAME.CONST.EVENT.DELTA_Y ] );
                this.computeSquare();
                if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
                    this.synchronizeJsonEditableValue( [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y] );
                }
                break;
            case "add_space__selected_grid_cell":
                this.setPreviousModificationElement( { [ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_LIST_KEY ]: [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y, SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X] } );
                let _new_value = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].getValue() + params[ SHINKEN.OBJECT.OVERLAYFRAME.CONST.EVENT.DELTA_Y ];
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setUserValueAndValue( _new_value );
                this.updateSize();
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE ) );
                if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
                    this.synchronizeJsonEditableValue( [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y] );
                }
                break;
            case "remove_space__selected_grid_cell":
                this.updateSize();
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE, params ) );
                if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
                    this.synchronizeJsonEditableValue( [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y] );
                }
                break;
            case "mouse_resize_selected_grid_cell":
                if ( !this.starting_clone ) {
                    this.initStartingZone();
                    this.initEndingZone();
                }
                this.ending_clone.makeMoveInProgress__fromResize( params );
                if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
                    this.synchronizeJsonEditableValue();
                }
                break;
            case "apply_move_reset__manually":
                if ( !this.starting_clone ) { // NO MOVE INITIATE
                    return;
                }
                this.updateData( this.starting_clone.getDataForMoveLastModification() );
                this.resetMoveObjects();
                this.updateSize();
                if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
                    this.synchronizeJsonEditableValue();
                }
                break;
            case "apply_move__manually":
                if ( !this.starting_clone ) { // NO MOVE INITIATE
                    return;
                }
                this.updateData( this.ending_clone.getDataForMoveLastModification() );
                this.resetMoveObjects();
                this.updateSize();
                if ( !this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING ) && !this.isOutsideOfDisplay() ) {
                    this.updateData( { validation_messages: null } );
                }
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE, true ) );
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MESSAGES ) );
                break;
            case "on_scroll":
                if ( this.isInPhase( [SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.EDITING] ) && params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ].isInPhase( [SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.EDITING] ) ) {
                    this.computeHtml( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], "", true );
                }
                return;
            case "adding_new_widget_manually":
                this.content.doActionAfter( event_name, params );
                this.resetHTML();
                this.computeHtml( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ].dom_parent_with_scroll, params[ SHINKEN_GRID.CONST.PARAM.EVENT.ADD_DIRECTLY_TO_GRID ] );
                break;
            case "mouseover_on_deleting_pop_up":
                if ( this.uuid === params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] ) {
                    DOM.Service.focusOnAnchor_withDom( this.dom_element, this.dom_parent_with_scroll, new DOM.Service.Animation( "shinken-pulsate", 1600 ), 5 );
                }
                else {
                    this.dom_element.classList.remove( "shinken-pulsate" );
                }
                break;
            case "change__shinken_element__from_form":
                this.resetCounters();
                this.resetHTML();
                this.computeHtml( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], null, true );
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].doActionAfter( event_name, params );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                CONTROLLER.PageController.doActionAfter( "clean_widget_with_problem", {
                    [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]               : this.getUUID(),
                    [ SHINKEN.OBJECT.FORMSET.PARAM.FORM_ANIMATION_STOP_PROPAGATION ]: params[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_ANIMATION_STOP_PROPAGATION ]
                } );
                break;
            case "value__param__configured__from_form":
                for ( let i = 0, _size_i = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ].length; i < _size_i; i++ ) {
                    params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ]                = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ][ i ];
                    let param_object                                            = SHINKEN.TOOLS.DICT.getValueWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                    params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_DATA ] = params[ SHINKEN.OBJECT.FORMSET.PARAM.DATA ][ params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] ];
                    param_object.addParamsForEvents( this.getParamForEvents() );
                    param_object.doActionAfter( event_name, params );
                }
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].updateDomElement();
                break;
            case "default__param__configured__from_form":
                if ( params[ WIDGET.CONST.PARAM_EVENT.WIDGET_TYPE ] !== this.content.getTypeValue() ) {
                    return;
                }
                const param_to_update = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] );
                if ( param_to_update.user_value !== param_to_update.default_value ) {
                    return;
                }
                param_to_update.addParamsForEvents( this.getParamForEvents() );
                param_to_update.doActionAfter( event_name, params );
                if ( SHINKEN_GRID.CONST.PARAM.isSizesProperty( params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ] ) ) {
                    this.updateSize( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ] );
                    params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_OBJECT ].add( this );
                }
                else {
                    this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].updateDomElement();
                }
                return;
            case "default__param__configured__from_form__done":
                let messages = { "validation_messages": {} };
                const errors = [];
                if ( this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING ) ) {
                    errors.push( this.getSingleOverlapMessageError() );
                }
                if ( this.isOutsideOfDisplay() ) {
                    errors.push( this.getOutsideOfDisplayMessageError() );
                }
                if ( errors.length ) {
                    messages[ "validation_messages" ][ "errors" ] = errors;
                }
                this.setPreviousModificationElement();
                this.updateData( messages );
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MESSAGES ) );
                params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].doActionAfter( "window_problem__update__grid_cell__after__manual_action", {
                    [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ]: this, [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]: this.getUUID()
                } );
                return;
            case "undo_last_modification":
            case "redo_last_modification":
                if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( WIDGET.CONST.PARAM_EVENT.WIDGET_CONTAINER_KEY ) ) {
                    this.doActionAfter__lastModification_onChildren( event_name, params );
                    this.updateJsonIfNeeded( params );
                    return;
                }
                this.doActionAfter__lastModification( event_name, params );
                break;
            case "update_nb_tiles_in_height":
                this.nb_tiles_in_height = params.new_nb_tiles_in_height;
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setUUID                        : function ( to_set ) {
        if ( !to_set && !this.uuid ) {
            to_set = SHINKEN.TOOLS.STRING.buildUUID();
        }
        this.uuid = to_set || this.uuid;
        this.addParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID, this.getUUID() );
        this.addJsonAnchor( this.getUUID() );
    },
    addParamForEvents              : function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ] ) {
            this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].addParamForEvents( key, value );
        }
    },
    getUUID                        : function () {
        return this.uuid;
    },
    getContentNameForDeletePopup   : function () {
        return this.content.getNameToDisplay();
    },
    getContentUUID                 : function () {
        if ( this.content ) {
            return this.content.getUUID();
        }
    },
    getShinkenElement              : function () {
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getShinkenElement ) {
            return this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getShinkenElement();
        }
    },
    getController                  : function () {
        console.shinken.debug( "TO BE OVERRIDE" );
        return null;
    },
    getWidgetType                  : function () {
        return this.content.type.getValue();
    },
    setIndexLabel                  : function ( index_value ) {
        this.index_label = "<span class='shinken-cell-label-index'>Widget " + index_value + "</span>";
    },
    getNameToDisplay               : function () {
        return this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].getNameToDisplay();
    },
    getPointBottomLeft             : function () {
        const current_grid_cell = this.ending_clone || this;
        return new SHINKEN.OBJECT.Point(
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ),
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ) + current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ),
            "bottom_left",
            current_grid_cell.nb_tiles_in_width - current_grid_cell.getComputedWidth()
        );
    },
    getPointTopRight               : function () {
        const current_grid_cell = this.ending_clone || this;
        return new SHINKEN.OBJECT.Point(
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ) + current_grid_cell.getComputedWidth(),
            current_grid_cell.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ),
            "top_right",
            current_grid_cell.nb_tiles_in_width
        );
    },
    getSquare                      : function () {
        if ( !this.square ) {
            this.computeSquare();
        }
        return this.square;
    },
    getJsonEditorInstance          : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.JsonEditor( dom_element, json, default_tag );
    },
    getSingleOverlapMessageError   : function () {
        return {
            "text"     : _( "validation.business.grid.widget_overlapping" ),
            "list_keys": [
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X,
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y,
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH,
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT
            ]
        };
    },
    getOutsideOfDisplayMessageError: function () {
        return {
            "text"     : _( "validation.business.grid.widget_out_of_grid" ),
            "list_keys": [
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X,
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y,
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH,
                SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT
            ]
        };
    },
    //********************************************  JSON  *****************************************************//
    _getValidOwnChildren        : function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty"]
        ] );
    },
    _getValidOwnProperty        : function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    },
    setJsonDomElementValue      : function ( property_name ) {
        let to_set = this.ending_clone ? this.ending_clone[ property_name ].getValue() : this[ property_name ].getUserValue();
        this[ property_name ].setJsonDomElementValue( to_set );
    },
    synchronizeJsonEditableValue: function ( property_list ) {
        property_list = property_list || this.parseValidOwnPropertyToKey();
        this.linkJsonDomElement( property_list );
        for ( let i = 0, _size_i = property_list.length; i < _size_i; i++ ) {
            this.setJsonDomElementValue( property_list[ i ] );
        }
    },
    //********************************************  OTHERS  *****************************************************//
    resetSquare : function () {
        this.square = null;
    },
    isVisible   : function () {
        let _box      = this.getDisplayBox();
        let _rect     = DOM.Service.getBoundingClientRect( this.dom_parent_with_scroll );
        let _box_cell = { top: _box.top + _rect.top, bottom: _box.top + _box.height + _rect.top };
        let _box_grid = { top: _rect.top + this.dom_parent_with_scroll.scrollTop, bottom: _rect.bottom + this.dom_parent_with_scroll.scrollTop };
        
        return DOM.Service.isPartiallyVisibleIntoScrollingVerticalParent_Box( _box_cell, _box_grid );
    },
    remove      : function ( params ) {
        this.resetCounters();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.DELETED );
        this.resetHTML( params );
        if ( !params[ SHINKEN.CONST.PARAM.EVENT_PARAM.AVOID_DO_ACTION_AFTER ] ) {
            this.getController().doActionAfter( "grid_cell_has_been_deleted", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]: this.getUUID() } );
        }
    },
    canBeDeleted: function () {
        return this.content.canBeDeleted();
    },
    //********************************************  COMPUTE  *****************************************************//
    computeMapping          : function ( mapping ) {
        if ( this.content && this.content.computeMapping ) {
            this.content.computeMapping( mapping );
        }
    },
    computeSizes            : function ( shinken_grid ) {
        this.updateSize( shinken_grid );
    },
    updateSize              : function ( shinken_grid ) {
        if ( !this.dom_element ) {
            this.computeSquare();
            return;
        }
        if ( shinken_grid ) {
            this.tile_pixel_size = shinken_grid.tile_pixel_size;
            this.font_size       = shinken_grid.font_size;
        }
        DOM.Service.setStyles( this.dom_element, this.getStyle() );
        DOM.Service.setStyle( this.dom_element_border_select_parent, DOM.CONST.STYLE.PADDING, this.padding_value );
        this._updateSize();
        if ( this.content ) {
            if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.ADDING ) ) {
                this.content.updateSize();
            }
        }
        this.removeClass( "shinken-no-opacity" );
        this.computeSquare();
    },
    _updateSize             : function () {
        DOM.Service.setStyle( this.content_container, DOM.CONST.STYLE.HEIGHT, "" );
        if ( __has_edit_mode__ && this.hasCounterProblems() ) {
            var _rect  = DOM.Service.getBoundingClientRect( this.dom_element );
            var _ratio = _rect[ DOM.CONST.STYLE.WIDTH ] / _rect[ DOM.CONST.STYLE.HEIGHT ];
            
            if ( _ratio > WIDGET.CONST.COMMON.PERFECT_RATIO ) {
                this.optimal_height = _rect[ DOM.CONST.STYLE.HEIGHT ];
            }
            else {
                this.optimal_height               = parseInt( _rect[ DOM.CONST.STYLE.WIDTH ] / WIDGET.CONST.COMMON.PERFECT_RATIO );
                this.padding_to_have_optimal_zone = parseInt( (_rect[ DOM.CONST.STYLE.HEIGHT ] - this.optimal_height) / 2 );
                
            }
            this.content_padding = parseInt( this.optimal_height * WIDGET.CONST.WEATHER.STYLE.PADDING_CONTENT );
            this.border_radius   = Math.ceil( 0.06 * this.optimal_height );
            
            if ( this.dom_element_error_container_secondary_content ) {
                DOM.Service.setStyles( this.dom_element_error_container_secondary_content, { "border-radius": this.border_radius / 2 } );
            }
            DOM.Service.setStyles( this.dom_element_error_container, { "padding": this.content_padding, "border-radius": this.border_radius } );
            DOM.Service.setStyle( this.content_container, DOM.CONST.STYLE.HEIGHT, "calc(100% - " + this.font_size + "px)" );
            
            DOM.Service.setStyles( this.dom_element_error_container.querySelector( '.shinken-widget' ), { "border-radius": this.border_radius } );
            
            DOM.Service.setStyle( this.dom_element_error_container_primary_content, "line-height", this.font_size + this.content_padding );
            
        }
    },
    computeContentWithChange: function () {
        let _to_return = 0;
        if ( this.content ) {
            _to_return = this.content.computeContentWithChange();
        }
        return _to_return;
    },
    computeOverlapping      : function ( grid_cell ) {
        if ( this.getUUID() === grid_cell.getUUID() ) {
            return;
        }
        grid_cell.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING, this.getUUID(), this.getSquare().isOverlapping( grid_cell.getSquare() ) ? 1 : 0 );
    },
    isOutsideOfDisplay      : function () {
        return this.getSquare().isOutsideOfDisplay( this.nb_tiles_in_width, this.nb_tiles_in_height );
    },
    confirmDoComputeHtml    : function () {
        return true;
    },
    computeSquare           : function () {
        if ( !__has_edit_mode__ || this.is_starting_clone || this.is_ending_clone ) {
            return;
        }
        const bottom_left_point = this.getPointBottomLeft();
        const top_right_point   = this.getPointTopRight();
        this.square             = new SHINKEN.OBJECT.Square( bottom_left_point, top_right_point, this.getUUID() );
    },
    //********************************************  DRAG N DROP  *****************************************************//
    initStartingZone              : function () {
        this.setPreviousModificationElement( { [ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_LIST_KEY ]: this.parseValidOwnPropertyToKey() } );
        this.starting_clone                   = this.clone__20241010();
        this.starting_clone.is_starting_clone = true;
        this.starting_clone.addClass( "shinken-cell-position-start" );
        this.starting_clone.computeHtml();
        DOM.Service.insertElementBefore( this.getDomElement(), this.starting_clone.getDomElement() );
        this.starting_clone.computeSizes();
    },
    initEndingZone                : function () {
        this.ending_clone                 = this.clone__20241010();
        this.ending_clone.is_ending_clone = true;
        this.ending_clone.addClass( "shinken-cell-position-end" );
        this.ending_clone.computeHtml();
        DOM.Service.insertElementBefore( this.getDomElement(), this.ending_clone.getDomElement() );
        this.ending_clone.computeSizes();
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING, this.ending_clone.getDomElement() );
    },
    resetMoveObjects              : function () {
        if ( this.starting_clone ) {
            this.starting_clone.remove( { [ SHINKEN.CONST.PARAM.EVENT_PARAM.AVOID_DO_ACTION_AFTER ]: true } );
            this.starting_clone = null;
        }
        if ( this.ending_clone ) {
            this.ending_clone.remove( { [ SHINKEN.CONST.PARAM.EVENT_PARAM.AVOID_DO_ACTION_AFTER ]: true } );
            this.ending_clone = null;
        }
    },
    makeMoveInProgress__fromResize: function ( params ) {
        let positions    = params[ SHINKEN.OBJECT.OVERLAYFRAME.CONST.EVENT.POSITION_IN_FRAME ];
        let height       = Math.max( Math.abs( positions.start_y - positions.end_y ), SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_HEIGHT );
        let width        = Math.max( Math.abs( positions.start_x - positions.end_x ), SHINKEN_GRID.CONST.PARAM.GRID_CELL.MIN_WIDTH );
        const position_x = Math.min( positions.start_x, positions.end_x );
        const position_y = Math.min( positions.start_y, positions.end_y );
        if ( position_x + width > this.nb_tiles_in_width ) {
            width = this.nb_tiles_in_width - position_x;
        }
        if ( position_y + height > this.nb_tiles_in_height ) {
            height = this.nb_tiles_in_height - position_y;
        }
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].setUserValueAndValue( position_x );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setUserValueAndValue( position_y );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].setUserValueAndValue( width );
        this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].setUserValueAndValue( height );
        this.computeSizes();
    },
    applyResize                   : function ( params ) {
        if ( this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING ) ) {
            this.updateData( this.starting_clone.getDataForMoveLastModification() );
            this.resetMoveObjects();
            this.updateSize();
            if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
                this.synchronizeJsonEditableValue();
            }
            return false;
        }
        this.makeMoveInProgress__fromResize( params );
        this.resetMoveObjects();
        this.updateSize();
        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.RESIZE ) );
        return true;
    },
    updateEndingClone             : function ( delta_x, delta_y ) {
        let _pos_x = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].value + Math.round( delta_x / this.tile_pixel_size );
        _pos_x     = Math.max( 0, _pos_x );
        _pos_x     = Math.min( this.nb_tiles_in_width - this.getComputedWidth(), _pos_x );
        this.ending_clone.position_x.setUserValueAndValue( _pos_x );
        
        let _pos_y = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].value + Math.round( delta_y / this.tile_pixel_size );
        _pos_y     = Math.max( 0, _pos_y );
        _pos_y     = Math.min( this.nb_tiles_in_height - this.getComputedHeight(), _pos_y );
        
        this.ending_clone.position_y.setUserValueAndValue( _pos_y );
        this.ending_clone.updateSize();
    },
    //********************************************  UPDATE DATA   **************************************************//
    setData                          : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
                this.setDataKey( key, value );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT:
                this[ key ] = this.getChildConstructor( value );
                this[ key ].setCountersParent( this );
                this[ key ].addParamsForEvents( this.getParamForEvents() );
                this.own_children_keys.push( key );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID_CELL.UUID:
                this.setUUID( value );
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    getChildConstructor              : function ( data ) {
        return new SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty( data );
    },
    doActionAfterSetMessageValidation: function ( value ) {
        if ( value ) {
            CONTROLLER.PageController.doActionAfter( "add_object_with_problems__to__window_problem", { [ SHINKEN.OBJECT.CONST.VALIDATION.PARAM.CURRENT_OBJECT ]: this } );
        }
        else {
            CONTROLLER.PageController.doActionAfter( "clean_widget_with_problem", { [ [SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID] ]: this.getUUID() } );
        }
        this.computeSizes();
    },
    //********************************************  FORM  *****************************************************//
    clone__20241010    : function () {
        const to_return                                                            = this.getCloneConstructor();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ]                 = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].clone__20250108();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ]                 = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].clone__20250108();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ]                      = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].clone__20250108();
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].clone__20250108();
        to_return.tile_pixel_size                                                  = this.tile_pixel_size;
        to_return.font_size                                                        = this.font_size;
        to_return.dom_parent_with_scroll                                           = this.dom_parent_with_scroll;
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ]                     = this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ];
        to_return[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ];
        return to_return;
    },
    getCloneConstructor: function ( data ) {
        return new SHINKEN_GRID.Cell( data );
    },
    //********************************************  HTML   **************************************************//
    computeHtml           : function ( shinken_grid, dom_parent_with_scroll, add_directly_to_grid ) {
        this.dom_parent_with_scroll = dom_parent_with_scroll || this.dom_parent_with_scroll;
        if ( this.getDomElement() ) {
            return false;
        }
        if ( !__has_edit_mode__ && this.hasCounterProblems() ) {
            return false;
        }
        if ( shinken_grid ) {
            this.tile_pixel_size                                                  = shinken_grid.tile_pixel_size;
            this.font_size                                                        = shinken_grid.font_size;
            this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ]                     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX );
            this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT );
        }
        if ( !this.confirmDoComputeHtml( shinken_grid ) ) {
            return false;
        }
        if ( !add_directly_to_grid && !this.isVisible() ) {
            return false;
        }
        this.setDomElement( DOM.Service.createElement( "div", this.getAttribute() ) );
        
        this.content_container = DOM.Service.createElement( "div", { class: "shinken-grid-cell-container shinken-height-100" } );
        this.wrapHtmlContainer();
        this.addDomElement( this.dom_element_content );
        if ( this.content ) {
            this.content.setDomElementParent( this.content_container );
            this.content.computeHtml( this.tile_pixel_size * this.getComputedWidth(), this.tile_pixel_size * this.height );
        }
        
        this.setPhaseDomElement( this.getDomElement() );
        if ( add_directly_to_grid ) {
            DOM.Service.addElementTo( this.getDomElement(), shinken_grid.getDomElement() );
            this.updateSize();
        }
        return true;
    },
    computeCellMask       : function () {
        if ( this.dom_element_edition_mask ) {
            return;
        }
        this.dom_element_edition_mask               = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-grid-cell-mask-container" } ) );
        this.dom_element_border_select_parent       = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-grid-cell-border-container" } ), this.dom_element_edition_mask );
        this.dom_element_edition_mask_cursor_parent = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-grid-cell-resize-container shinken-layout-justify-between" } ), this.dom_element_edition_mask );
        DOM.Service.addResizeCursorsTo( this.dom_element_edition_mask_cursor_parent );
        
        let _delete_button_container   = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-layout-center-h-v shinken-button-container" } ), this.dom_element_edition_mask_cursor_parent );
        let _config_button_container   = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-layout-center-h-v shinken-button-container" } ), this.dom_element_edition_mask_cursor_parent );
        let _dom_element_border_select = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-grid-cell-border" } ), this.dom_element_border_select_parent );
        
        let container_bin = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-bin-container" } ), _delete_button_container );
        let bin_icon_svg  = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-bin-svg" ) );
        bin_icon_svg.classList.add( "shinken-delete-button" );
        DOM.Service.addElementTo( bin_icon_svg, container_bin );
        
        let container_cog = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-cog-container" } ), _config_button_container );
        let cog_icon_svg  = DOM.Service.cloneElement( document.querySelector( "#id-shinken-template-view .shinken-cog-svg" ) );
        cog_icon_svg.classList.add( "shinken-config-button" );
        DOM.Service.addElementTo( cog_icon_svg, container_cog );
    },
    wrapHtmlContainer     : function () {
        this.dom_element_content = this.dom_element_content || DOM.Service.createElement( "div", { class: "shinken-grid-cell-content" } );
        if ( !__has_edit_mode__ ) {
            DOM.Service.addElementToAfterEmpty( this.content_container, this.dom_element_content );
            return;
        }
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.getDomElement() );
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.getDomElement() );
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING, this.getDomElement() );
        
        this.dom_element_error_container                 = DOM.Service.createElement( "div", { class: "shinken-grid-cell-container-edit-mode" } );
        this.dom_element_error_container_primary_content = DOM.Service.createElement( "div", { class: "shinken-grid-cell-container-error-primary-content" } );
        let _text_dom                                    = DOM.Service.createElement( "span", { class: "shinken-grid-cell-error-primary-text" } );
        let _primary_icon                                = DOM.Service.createElement( "span", { class: "shinkon-warning" } );
        
        DOM.Service.addElementTo( _primary_icon, this.dom_element_error_container_primary_content );
        
        //if ( this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) ) {
        _text_dom.innerHTML = _( "common.error", [DICTIONARY_COMMON_UI] );
        DOM.Service.addElementTo( _text_dom, this.dom_element_error_container_primary_content );
        let message = this.buildMessage();
        if ( message ) {
            message = "<div class='shinken-weather-error-message'>" + message + "<\div>";
        }
        DOM.Service.addTooltip( this.dom_element, { "shi-tip-html": message, "shi-tip-type": "shinken-error-message-weather" }, 'CONTROLLER.PageController.doActionAfter("show-tooltip-on-grid-cell", this)' );
        this.dom_element_error_separator_between_container = DOM.Service.createElement( "div", { class: "shinken-grid-cell-container-error-separator-between-container" } );
        this.dom_element_error_container_secondary_content = DOM.Service.createElement( "span", { class: "shinken-grid-cell-container-error-secondary-content" } );
        this.dom_element_error_secondary_text              = DOM.Service.createElement( "span", { class: "shinken-grid-cell-error-secondary-text" } );
        this.dom_element_error_secondary_text.innerHTML    = _( "common.warning", [DICTIONARY_COMMON_UI] );
        this.dom_element_error_secondary_icon              = DOM.Service.createElement( "span", { class: "shinkon-warning" } );
        DOM.Service.addElementTo( this.dom_element_error_secondary_icon, this.dom_element_error_container_secondary_content );
        DOM.Service.addElementTo( this.dom_element_error_secondary_text, this.dom_element_error_container_secondary_content );
        DOM.Service.addElementTo( this.dom_element_error_separator_between_container, this.dom_element_error_container_primary_content );
        DOM.Service.addElementTo( this.dom_element_error_container_secondary_content, this.dom_element_error_container_primary_content );
        DOM.Service.addElementTo( this.content_container, this.dom_element_error_container );
        DOM.Service.addElementTo( this.dom_element_error_container_primary_content, this.dom_element_error_container );
        DOM.Service.addElementToAfterEmpty( this.dom_element_error_container, this.dom_element_content );
    },
    buildMessage          : function () {
        var _to_write  = this.getAllObjectWithMessages();
        var _to_return = new SHINKEN_PAGE.Messages();
        for ( var i = 0, _size_i = _to_write.length; i < _size_i; i++ ) {
            _to_return.addMessages( _to_write[ i ].messages.getAllMessages() );
        }
        return _to_return.buildMessage();
    },
    computeHtmlDeletePopup: function () {
        this.dom_element_delete_popup = DOM.Service.createElement( "div", {
            "onmouseover": "MANAGER.EventManagerV2.doActionAfter( event, 'mouseover_on_deleting_pop_up', " + this.parseParamForEventsToHtml() + ")",
            "class"      : "shinken-deleting shinken-layout-justify-between"
        } );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED );
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.dom_element_delete_popup, "deletedActive" );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.getUUID(), 1 );
        
        let type_element_to_delete = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-type-cell shinken-layout-center-v" } ), this.dom_element_delete_popup );
        DOM.Service.addElementTo( this.content.getIconTypeDom(), type_element_to_delete );
        DOM.Service.addElementTo( DOM.Service.createElement( "span", {}, this.content.getTypeLabel() ), type_element_to_delete );
        
        let title_cell_label = this.getContentNameForDeletePopup();
        if ( !this.canBeDeleted() ) {
            title_cell_label += _( 'edit_mode.windows.tooltips.not_deletable_title' );
            this.dom_element_delete_popup.classList.add( "shinken-not-deletable-title" );
            this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED, this.getUUID(), 0 );
        }
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-title-cell shinken-layout-expand-1" }, title_cell_label ), this.dom_element_delete_popup );
        
        let shinken_action_cell = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-action-cell" } ), this.dom_element_delete_popup );
        
        let button_toggle_delete = new COMPONENT.ButtonFromData_V3( "toggle_remove_grid_cell_from_delete_list", "<span class='shinken-view-button-delete shinken-2023-broom'></span><span class='shinken-view-button-delete shinken-2023-back'></span>" );
        button_toggle_delete.addParamsForEvents( this.getParamForEvents() );
        button_toggle_delete.computeHtml();
        DOM.Service.addElementTo( button_toggle_delete.getDomElement(), shinken_action_cell );
        
        return this.dom_element_delete_popup;
    },
    getAttribute          : function () {
        const _to_return = {
            class: this.getClass(),
            style: DOM.Service.styleToHtml( this.getStyle() )
        };
        this.getUserInteraction( _to_return );
        return _to_return;
    },
    getUserInteraction    : function ( attributes ) {
        const params                = "{'" + SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID + "' : '" + this.getUUID() + "','" + MANAGER.EVENT_MANAGER_V2.PARAM.EVENT + "' :  event}";
        attributes[ "onmousedown" ] = "MANAGER.EventManagerV2.doActionAfter(event, 'mouse_down_on_grid_cell'," + params + ")";
        attributes[ "onmouseup" ]   = "MANAGER.EventManagerV2.doActionAfter(event, 'mouse_up_on_grid_cell'," + params + ")";
    },
    getComputedWidth      : function () {
        return this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ) === SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] : this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH );
    },
    getComputedHeight     : function () {
        return this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ) === SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ] : this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT );
    },
    getStyle              : function () {
        const _to_return = this.getDisplayBox();
        let _padding     = parseInt( DOM.BodyService.getWidth() * this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] / 100 );
        if ( !_to_return[ DOM.CONST.STYLE.WIDTH ] || !_to_return[ DOM.CONST.STYLE.HEIGHT ] ) {
            _padding = 0;
        }
        else {
            if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] !== SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED ) {
                _padding = Math.min( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] );
            }
            _padding = Math.max( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ] );
            
        }
        this.padding_value                    = _padding / 2;
        _to_return[ DOM.CONST.STYLE.PADDING ] = this.padding_value;
        return _to_return;
    },
    getDisplayBox         : function () {
        const _to_return                     = {};
        _to_return[ DOM.CONST.STYLE.WIDTH ]  = this.tile_pixel_size * this.getComputedWidth();
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT );
        _to_return[ DOM.CONST.STYLE.TOP ]    = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y );
        _to_return[ DOM.CONST.STYLE.LEFT ]   = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X );
        return _to_return;
    },
    resetHTML             : function () {
        this.dom_element_edition_mask = null;
        this.resetHTMLCommon();
    },
    //********************************************  PHASE   **************************************************//
    callbackForPhase: function () {
        let current_phase = this.getCurrentPhase();
        switch ( current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.EDITING:
                this.computeCellMask();
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getUUID(), this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ? 1 : 0 );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SELECTED:
                this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getUUID(), this.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ? 1 : 0 );
                break;
        }
        this.updateSize();
    },
    //*****************************************  LAST MODIFICATION  *********************************************//
    getLastModificationElement                : function ( type_modification, avoid_delete_previous ) {
        let to_return;
        let data_last_modification;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                previous = this.getDataForLastModification();
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.DELETE:
                data_last_modification                                            = this.getDataForLastModification();
                data_last_modification[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.UUID ] = this.getUUID();
                previous                                                          = data_last_modification;
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.RESIZE:
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MOVE:
                previous = this.previous_modication_data;
                next     = this.getDataForMoveLastModification();
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MESSAGES:
                previous = { validation_messages: this.previous_modication_data.validation_messages };
                next     = { validation_messages: this.getDataForLastModification().validation_messages };
                break;
            default:
                console.error( "[Cell - getLastModificationElement]", "[NOT MANAGED]", type_modification );
                break;
        }
        to_return = new SHINKEN.OBJECT.LastModificationElement( type_modification, element_modified, previous, next );
        if ( !avoid_delete_previous ) {
            this.previous_modication_data = null;
        }
        return to_return;
    },
    getDataForMoveLastModification            : function () {
        let to_return = {};
        let _keys     = this.parseValidOwnPropertyToKey();
        for ( let i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            to_return[ _keys[ i ] ] = this[ _keys[ i ] ].getDataForLastModification();
        }
        return to_return;
    },
    doActionAfter__lastModification_onChildren: function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        switch ( modification_element.getTypeModification() ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.CONFIGURE:
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].doActionAfter( event_name, params );
                this.resetHTML();
                this.computeHtml( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ], null, true );
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].updateDomElement();
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ] = this;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]   = this.getUUID();
                params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].doActionAfter( this.hasCounterProblems() ? "add_object__with_problems__from_user_action" : "clean_widget_with_problem", params );
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.PARAM_MODIFICATION:
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].doActionAfter( event_name, params );
                break;
        }
    },
    doActionAfter__lastModification           : function ( event_name, params ) {
        const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
        switch ( modification_element.getTypeModification() ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.PARAM_MODIFICATION:
                let param_object = SHINKEN.TOOLS.DICT.getObjectWithComposedKey( this, modification_element.getParamForEvents( PROPERTY.COMMON.PARAM.COMPOSED_KEY ) );
                param_object.doActionAfter( event_name, { [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ]: modification_element } );
                this[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT ].updateDomElement();
                this.computeSizes();
                break;
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.MESSAGES:
                let messages = modification_element.getNextOrPrevious( event_name );
                this.updateData( messages );
                if ( !messages.validation_messages ) {
                    params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].doActionAfter( "clean_widget_with_problem", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]: this.getUUID() } );
                }
                else {
                    params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ].doActionAfter( "add_object__with_problems__from_user_action", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ]: this } );
                }
                this.computeSizes();
                break;
            default:
                this.updateData( modification_element.getNextOrPrevious( event_name ) );
                this.updateSize();
                break;
        }
        if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
            this.synchronizeJsonEditableValue();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN_GRID.BelongGridCell );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.EditableElementInterface );
