//priority 1048
//__lib__ lib_common_V02_01
"use strict";


SHINKEN.OBJECT.ExternalLinkFormInterface = function () {
};

SHINKEN.OBJECT.ExternalLinkFormInterface.prototype = {
    initCounterCommon      : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
    },
    initExternalLinkDefault: function ( user_prefs ) {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData_V3( SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.EXTERNAL_LINK._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.EXTERNAL_LINK._KEY ) ), true );
        if ( !user_prefs || !user_prefs.getValueByKey( [widget_cf.getUUID(), SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN] ) ) {
            widget_cf.addClass( "shinken-close" );
        }
        let current_cf = this.addSpecificToChild( this.getCollapseFolder__external_links__URLArea(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__external_links__info_barArea(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__external_links__notificationArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
    },
    // ************************************* COLLAPSE FOLDERS *******************************************//
    getCollapseFolder__external_links__NameArea        : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( WEATHER.CONST.EXTERNAL_LINKS.PARAM.CONFIGURATION, _( "form.external_links.collapse_folder.cf_name" ) );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID, to_return ), to_return );
        to_return.setCounterParent( this, SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        return to_return;
    },
    getCollapseFolder__external_links__URLArea         : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( WEATHER.CONST.EXTERNAL_LINKS.PARAM.URL_CF, _( "form.external_links.collapse_folder.cf_url" ) );
        this.computeExternalLinksPreviewUrl( to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL, to_return ), to_return );
        to_return.setCounterParent( this, SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        return to_return;
    },
    getCollapseFolder__external_links__info_barArea    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR._KEY, _( "form.external_links.collapse_folder.cf_information_bar_display" ) );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.POSITION, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.LOGO_DISPLAYED, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.CHRONO_DISPLAYED, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.GENERATION_TIME_DISPLAYED, to_return ), to_return );
        to_return.setCountersParent( this );
        
        return to_return;
    },
    getCollapseFolder__external_links__notificationArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.EXTERNALLINK.COLLAPSE_FOLDER.NOTIFICATION._KEY, _( "form.external_links.collapse_folder.cf_notifications" ) );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED, to_return ), to_return );
        this.addSpecificToChild( this.factoryProperty( WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED, to_return ), to_return );
        to_return.setCounterParent( this, SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        
        return to_return;
    },
    // ******************************************** PROPERTIES ***********************************************//
    factoryProperty               : function ( property_structure, cf_parent ) {
        let to_return;
        const mandatory_class = this.getMandatoryClass( property_structure );
        
        switch ( property_structure ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PREVIEW_URL:
                to_return = new PROPERTY.LabelFromData_V3_ForViewOnly( WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PREVIEW_URL, '<span class="shinkon shinkon-globe shinken-external-link-tooltip-info-bar-external-link-icon"></span>', this.getExternalLinkUrlForPreview() );
                to_return.setPreviousModificationElement();
                return to_return;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_NAME:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_UUID:
                to_return = new PROPERTY.StringInputFromData_V3(
                    property_structure.COMPOSED_KEY,
                    SHINKEN.TOOLS.DICT.getValueWithComposedKey( this.main_external_link, property_structure.COMPOSED_KEY ).getUserValue(),
                    _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".label" )
                );
                to_return.addClass( mandatory_class );
                to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".input.placeholder" ) } );
                to_return.setPreviousModificationElement();
                to_return.setCounterParent( cf_parent, SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
                return to_return;
        }
        let radios = this.parseConfigurationToArray( property_structure.OPTIONS, "form.external_links.properties." + property_structure.COMPOSED_KEY, property_structure, WIDGET.CONST.TYPE.EXTERNAL_LINKS );
        switch ( property_structure ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_PROTOCOL:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.AUTHENTICATION_NEEDED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.POSITION:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.LOGO_DISPLAYED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.CHRONO_DISPLAYED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.REFRESH.GENERATION_TIME_DISPLAYED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.SOUND.ENABLED:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.NOTIFICATIONS.VISUAL.BLINK.ENABLED:
                to_return = new PROPERTY.CheckBoxRadioPropFromData_V3( property_structure.COMPOSED_KEY, radios, _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".label" ) );
                break;
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_EXTERNAL_PART_URL:
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.INFO_BAR.BACKGROUND_COLOR:
                to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( property_structure.COMPOSED_KEY, radios, _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".label" ) );
                to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "form.external_links.properties." + property_structure.COMPOSED_KEY + ".input.placeholder" ) } );
                break;
        }
        to_return.addClass( mandatory_class );
        to_return.setCountersParent( cf_parent );
        this.setValueForProperty( property_structure, to_return, WEATHER.CONST.EXTERNAL_LINKS._KEY );
        
        to_return.setPreviousModificationElement();
        return to_return;
    },
    getDefaultValueExternalLinks  : function ( type, composed_key ) {
        let to_return;
        switch ( composed_key ) {
            case WEATHER.CONST.EXTERNAL_LINKS.PARAM.LINK_BASE_URL.COMPOSED_KEY :
                to_return = SHINKEN.HIGHWAY.getHost();
                break;
            default:
                to_return = this.page_object.getDefaultValueFor( type, composed_key );
                break;
        }
        return to_return;
    },
    setValueForProperty           : function ( property_structure, property, type ) {
    },
    computeExternalLinksPreviewUrl: function ( collapse_folder ) {
    },
    // ************************************* GETTER *****************************************************
    getMandatoryClass: function ( property_structure ) {
        return "";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ExternalLinkFormInterface, SHINKEN.OBJECT.CounterInterfaceV2 );

SHINKEN_PAGE.VISUALFORM.EXTERNALLINK = {
    COLLAPSE_FOLDER: {
        NAME        : {
            _KEY: "cf_weather_edit_external_link_name_part"
        },
        URL         : {
            _KEY: "cf_weather_edit_external_link_url_part"
        },
        INFO_BAR    : {
            _KEY: "cf_weather_edit_external_link_information_bar_display_part"
        },
        NOTIFICATION: {
            _KEY: "cf_weather_edit_external_link_notification_part"
        }
        
    }
};