//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.RadioWidgetModeAdd           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.RadioWidgetModeAdd.prototype = {
    initSpecific: function ( name, label ) {
        this.init( name );
        this.setLabel( _( "form.radio_widget_mode.label." + name ) );
        this.radios = null;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "change_radio_mode":
                if ( param[ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ] === SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.RADIOS._KEY ) {
                    this.radios.doActionAfter( event_name, param );
                    return;
                }
                break;
            case "change_radio_mode_to_next":
                this.radios.doActionAfter( event_name, param );
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    add                      : function ( radios_mode ) {
        this.radios = radios_mode;
        return this.radios;
    },
    //********************************************  HTML  *****************************************************//
    getIconSrc        : function () {
        return "/static/" + __SHINKEN_HTTP_START_TIME__ + "/service_weather/img/form/add.png";
    },
    getShortCutLetter : function () {
        return "A";
    },
    getTooltipPosition: function () {
        return SHINKEN_TOOLTIP.PLACEMENT.TOP_LEFT;
    },
    //********************************************  HELP  *****************************************************//
    
    getHelpContents     : function () {
        return [
            {
                type_content : "ordered_title",
                ordered_value: 1,
                elements     : [
                    { type: "span", className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.select_widget_type" ) }
                ]
            },
            {
                type_content: "full_line_content",
                elements    : [
                    { type: "span", className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) },
                    { type: "span", className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.on" ) },
                    { type: "span", className: "shinken-tooltip-help-button-type-widget", content: _( "edit_mode.windows.tooltips.labels_help.type_widget" ) }
                ]
            },
            {
                type_content : "ordered_title",
                ordered_value: 2,
                elements     : [
                    { type: "span", className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.add_widget" ) }
                ]
            },
            {
                type_content: "full_line_content",
                elements    : [
                    { type: "span", className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.move_mouse" ) }
                ]
            },
            {
                type_content: "full_line_content",
                elements    : [
                    { type: "span", className: "shinken-tooltip-help-label", content: _( "edit_mode.windows.tooltips.labels_help.empty_area" ) },
                    { type: "span", className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.add_widget_button" ) },
                    { type: "span", className: "shinken-tooltip-help-label", content: "+" },
                    { type: "span", className: "shinken-tooltip-help-button", content: _( "edit_mode.windows.tooltips.labels_help.click" ) }
                ]
            }
        
        ]
            ;
    },
    getHelpSpecificClass: function ( content ) {
        return "shinken-tooltip-add-widget";
    },
    computeHtmlExtra    : function () {
        this.radios.computeHtml();
        DOM.Service.addElementTo( this.radios.getDomElement(), this.dom_content_zone );
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
        if ( this.getCurrentPhase() === this.getPreviousPhase() ) {
            return;
        }
        switch ( this.getCurrentPhase()  ){
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING:
                this.radios.doActionAfter( "change_radio_mode_if_not_set" );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SLEEPING:
                 CONTROLLER.PageController.doActionAfter( "reset_grid_cell_to_add" );
                break;
        }
    }
}
;

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioWidgetModeAdd, SHINKEN.OBJECT.RadioMode );