//priority 1048
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.TitleWidgetFormInterface = function () {
};

SHINKEN.OBJECT.TitleWidgetFormInterface.prototype = {
    initTitleWidgetDefault: function ( user_prefs ) {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData_V3( SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.TITLE._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.TITLE._KEY ) ), true );
        if ( !user_prefs || !user_prefs.getValueByKey( [widget_cf.getUUID(), SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN] ) ) {
            widget_cf.addClass( "shinken-close" );
        }
        let current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetTitle__sizes(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetTitle__titleArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
    },
    // ************************************* COLLAPSE FOLDERS *******************************************//
    getCollapseFolder__widgetTitle__sizes    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.DEFAULTFORM.WIDGET.COLLAPSE_FOLDER.DIMENSION_AREA._KEY, _( "grid.mode_edition.form_widget.title_widget.collapse_folder.cf_dimensions", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.WIDTH ), to_return );
        this.addSpecificToChild( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.HEIGHT ), to_return );
        
        return to_return;
    },
    getCollapseFolder__widgetTitle__titleArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TITLE_AREA._KEY, _( "grid.mode_edition.form_widget.title_widget.collapse_folder.cf_title_area", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN ), to_return );
        this.addSpecificToChild( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR ), to_return );
        this.addSpecificToChild( this.factoryProperty__title( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT ), to_return );
        
        return to_return;
    },
    // ******************************************** PROPERTIES ***********************************************//
    factoryProperty__title: function ( property_structure ) {
        let to_return;
        const mandatory_class = this.getMandatoryClass( property_structure );
        const radios = this.parseConfigurationToArray( property_structure.OPTIONS, "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY, property_structure, WIDGET.CONST.PARAM.LAYOUTS.TITLE._KEY );
        
        switch ( property_structure ) {
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN:
                to_return = new PROPERTY.CheckBoxRadioPropFromData_V3( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL:
                to_return = new PROPERTY.StringInputFromData_V3( property_structure.COMPOSED_KEY, "", _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.WIDTH:
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.HEIGHT:
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR:
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT:
                to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".input.placeholder", [DICTIONARY_COMMON_UI] ) } );
                break;
        }
        to_return.addClass( mandatory_class );
        this.setValueForProperty( property_structure, to_return, WEATHER.CONST.WIDGET_TYPE.TITLE );
        
        to_return.setPreviousModificationElement();
        return to_return;
    },
    setValueForProperty   : function ( property_structure, property, type ) {
    }
};
