//priority 1048
//__lib__ lib_common_V02_01
"use strict";


SHINKEN.OBJECT.WeatherWidgetFormInterface = function () {
};

SHINKEN.OBJECT.WeatherWidgetFormInterface.prototype = {
    initWeatherWidgetDefault: function ( user_prefs ) {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData_V3( SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.WEATHER._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.WEATHER._KEY ) ), true );
        if ( !user_prefs || !user_prefs.getValueByKey( [widget_cf.getUUID(), SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN] ) ) {
            widget_cf.addClass( "shinken-close" );
        }
        
        let current_cf = this.addSpecificToChild( new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.DEFAULTFORM.WIDGET.COLLAPSE_FOLDER.DIMENSION_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_dimensions", [DICTIONARY_COMMON_UI] ) ), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.WIDTH ), current_cf );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.HEIGHT ), current_cf );
        
        
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetWeather__display(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetWeather__areas(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        
        this.grid_for_preview = this.addSpecificToChild( new SHINKEN_GRID.GridForPreview( this.getInitialDataForPreviewWidget( true ) ), widget_cf, true );
        this.grid_for_preview.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
        this.grid_cell_for_preview = this.grid_for_preview.grid_elements.getContent( 0 );
        this.grid_cell_for_preview.computeHtml();
        
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__leftArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__topRightArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__slaArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        this.addSpecificToChild( this.getCollapseFolder__widgetWeather__nameArea(), widget_cf, true, SHINKEN.CONST.VISIBILITY_STATE.HIDDEN );
        
    },
    // ************************************* COLLAPSE FOLDERS *******************************************//
    getCollapseFolder__widgetWeather__display     : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.DISPLAY._KEY, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_display", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME ), to_return );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND ), to_return );
        
        return to_return;
    },
    getCollapseFolder__widgetWeather__areas       : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_area", [DICTIONARY_COMMON_UI] ) );
        
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED, SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY ), to_return );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED, SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY ), to_return );
        
        return to_return;
    },
    getCollapseFolder__widgetWeather__leftArea    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_left_area", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE ), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__topRightArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_top_right_area", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE ), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__slaArea     : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.SLA_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_sla_area", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON ), to_return );
        return to_return;
    },
    getCollapseFolder__widgetWeather__nameArea    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForPropertiesWithPreview( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.NAME_AREA._KEY, _( "grid.mode_edition.form_widget.weather_widget.collapse_folder.cf_name_area", [DICTIONARY_COMMON_UI] ), this.grid_cell_for_preview );
        to_return.addClass( "shinken-collapse-disabled" );
        
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN ), to_return );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT ), to_return );
        this.addSpecificToChild( this.factoryProperty__weather( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX ), to_return );
        
        return to_return;
    },
    // ******************************************** PROPERTIES ***********************************************//
    factoryProperty__weather: function ( property_structure, param_for_event ) {
        let to_return;
        const mandatory_class = this.getMandatoryClass( property_structure );
        const radios          = this.parseConfigurationToArray( property_structure.OPTIONS, "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY, property_structure, WIDGET.CONST.PARAM.LAYOUTS.WEATHER._KEY );
        
        switch ( property_structure ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.DISPLAYED :
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.DISPLAYED :
                to_return = new PROPERTY.CheckBoxRadioPropFromData_V3( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                to_return.addParamForEvents( SHINKEN.OBJECT.COLLAPSE.PARAM.NAME_FOR_HIDDEN_PREVIEW, param_for_event );
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.VERTICAL_ALIGN:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.PROPERTY_USED_AS_NAME:
                to_return = new PROPERTY.CheckBoxRadioPropFromData_V3( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.BACKGROUND:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE:
                to_return = new PROPERTY.CheckBoxRadioProp__WithSelector__FromData( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.WIDTH:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.HEIGHT:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.NB_LINES_MAX:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA.FONT_ZOOM_PERCENT:
                to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( property_structure.COMPOSED_KEY, radios, _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".label", [DICTIONARY_COMMON_UI] ) );
                to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget." + property_structure.COMPOSED_KEY + ".input.placeholder", [DICTIONARY_COMMON_UI] ) } );
                break;
        }
        to_return.addClass( mandatory_class );
        this.setValueForProperty( property_structure, to_return, WEATHER.CONST.WIDGET_TYPE.WEATHER );
        
        to_return.setPreviousModificationElement();
        return to_return;
    },
    setValueForProperty     : function ( property_structure, property ) {
    },
    // ************************************* COMPUTE  *****************************************************
    synchronizationProperty             : function ( param, avoid_notification ) {
        switch ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY:
            case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY:
                let property_left  = this.property_set.getContentByUUID( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY );
                let property_right = this.property_set.getContentByUUID( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY );
                let value_left     = property_left.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                let value_tp_r     = property_right.getDataToSave__20241127( SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID );
                if ( WIDGET.CONST.isSameIconType( value_left, value_tp_r ) ) {
                    if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY ) {
                        if ( value_left[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS );
                        }
                        else {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON );
                        }
                        this._notificationSynchronizationProperty(avoid_notification, property_right, property_left);
                    }
                    if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.COMPOSED_KEY ) {
                        if ( value_tp_r[ SHINKEN.OBJECT.CONST.PARAM.VALUE ] === WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON ) {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS );
                        }
                        else {
                            this.setPropertyValue( WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.COMPOSED_KEY, WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON );
                        }
                        this._notificationSynchronizationProperty(avoid_notification, property_right, property_left);
                    }
                }
                break;
        }
    },
    _notificationSynchronizationProperty: function (avoid_notification, property_right , property_left) {
        if ( !avoid_notification ) {
            SHINKEN.TOOLS.NOTIFICATION.addNotification( SHINKEN.TOOLS.STRING.format( _( "validation.errors.change_auto__duplicate_value_on_property" ),
                '<span class="shinken-data-user">' + property_right.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TOP_RIGHT_AREA._KEY )
                                                                                                                                    .getLabel() + '&nbsp;)</span>',
                '<span class="shinken-data-user">' + property_left.getLabel() + '</span>&nbsp;<span "shinken-note"> (&nbsp;' + this.getContentByUUID( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY )
                                                                                                                                   .getLabel() + '&nbsp;)</span>'
            ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.INFO, null, 10000 );
        }
    },
    // ************************************* GETTER *****************************************************
    getInitialDataForPreviewWidget: function ( is_default_form ) {
        const layout = is_default_form ?
                       this.getDefaultPreviewWidgetLayout() :
                       SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseDictToDict_withValueKey( this.main_grid_cell.content.layout.getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT ) );
        return {
            "width"  : {
                "value": 15
            },
            "height" : {
                "value": 4
            },
            "content": {
                "type"  : {
                    "value": "weather_widget"
                },
                "layout": {
                    "value": layout
                },
                "item"  : {
                    "value": {
                        "item_uuid": {
                            "value": "010010010"
                        },
                        "item_name": {
                            "value": "Preview_Widget"
                        },
                        "item_type": {
                            "value": "host"
                        }
                    }
                }
            }
        };
    }
};