//__lib__ lib_common_V02_01
"use strict";

CONTROLLER.PageController = (function ( self ) {
    self.controller_name = CONTROLLER.CONST.PAGE_CONTROLLER.NAME;
    
    //********************************************  EVENT LISTENER  **************************************************//
    self.clickOnButton = function ( event, event_name, params ) {
        SHINKEN_TOOLTIP.hideTooltip();
        switch ( event_name ) {
            case "cancel_edit_mode_grid_page":
                if ( self.current_page.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
                    self.askShowLoadingPage();
                    self.current_page.clickOnButton( event, event_name, params );
                    SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.askLeaveEditMode();
                    self.askComputeSizes();
                }
                break;
            case "back_to_previous_preview":
                self.doActionAfter( event_name );
                break;
            default :
                self.current_page.clickOnButton( event, event_name, params );
        }
        if ( event_name && event ) {
            event.stopPropagation();
        }
    };
    
    self.doActionAfter = function ( event_name, params ) {
        switch ( event_name ) {
            case "current_page_set_phase_to_running":
                this.askCloseLoadingPage();
                this.selectors_once          = null;
                this.list_element_from_webui = null;
                let current_owner            = this.current_page.getCurrentOwner();
                if ( current_owner ) {
                    SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAngular( "update_current_screen_owner", { current_screen_owner_user: {"name" : current_owner["user_name"], "uuid" : current_owner["user_uuid"]} } );
                }
                return;
            case "click_on_button_V3":
                if ( params[ SHINKEN.OBJECT.CONFIRMATIONPOPUP.PARAM.NAME ] ) {
                    SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().doActionAfter( event_name, params );
                    return;
                }
                break;
            case "current_view_is_being_deleted":
                self.current_page.doActionAfterSpecific( event_name, params );
                return;
            case "mouse_up":
                if ( params.button === 1 ) {
                    return;
                }
                break;
            case "mouse_down":
            case "mouse_down_on_grid_cell":
            case "mouse_up_on_grid_cell":
                if ( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].button === 1 ) {
                    return;
                }
                break;
        }
        self.current_page.doActionAfter( event_name, params );
    };
    
    self.onDragStart             = function ( element_name, origin_x, origin_y ) {
        self.current_page.doActionAfter( "on_drag_start", {
            [ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ]: element_name, [ MANAGER.DragNDropManager.EVENT_PARAM.ORIGIN_X ]: origin_x, [ MANAGER.DragNDropManager.EVENT_PARAM.ORIGIN_Y ]: origin_y
        } );
    };
    self.onDragMove              = function ( element_name, delta_x, delta_y ) {
        self.current_page.doActionAfter( "on_drag_move", {
            [ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ]: element_name, [ MANAGER.DragNDropManager.EVENT_PARAM.DELTA_X ]: delta_x, [ MANAGER.DragNDropManager.EVENT_PARAM.DELTA_Y ]: delta_y
        } );
    };
    self.onDragStop              = function ( element_name ) {
        self.current_page.doActionAfter( "on_drag_stop", {
            [ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ]: element_name
        } );
    };
    self.askComputeSizes         = function () {
        self.current_page.askComputeSizes();
    };
    self.mouseLeave              = function ( event ) {
        this.current_page.doActionAfter( "mouse_leave", event );
    };
    self.onclick                 = function () {
        if ( self.current_page ) {
            self.current_page.onclick();
        }
    };
    self.onScroll                = function ( event, param ) {
        switch ( param ) {
            case "current_page":
                this.current_page.doActionAfter( "on_scroll", { [ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]: event } );
                break;
            case "json_editor":
                break;
        }
        SHINKEN_TOOLTIP.hideTooltip();
    };
    self.mouseWheel              = function ( event ) {
        this.current_page.doActionAfter( "mouse_wheel", event );
    };
    self.onPaste                 = function ( event ) {
        var _text_pasted = CLIPBOARD_SERVICE.doPaste( event );
        var self         = this;
        setTimeout( function () {
            self.current_page.onPasteAfterAction( _text_pasted );
        }, 200 );
    };
    self.mouseDown               = function ( event ) {
        self.current_page.doActionAfter( "mouse_down", { [ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]: event } );
    };
    self.mouseUp                 = function ( event ) {
    };
    self.askNavigateGroupEdition = function ( event, param ) {
        param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] = event;
        this.doActionAfter( "navigate_on_window_edition_group", param );
    };
    //********************************************  GETTER SETTER  **************************************************//
    self.setCurrentPage          = function ( to_set ) {
        self.current_page = to_set;
    };
    //********************************************  ACTION  **************************************************//
    self.doActionWhenNotFound    = function () {
        self.current_page.doActionWhenWeatherNotFound();
    };
    self.requestGet              = function ( url, saveSuccess ) {
        SHINKEN.COMUNICATION.requestGet( url, saveSuccess, self.onTimeoutError, "", self.doActionAfter401 );
    };
    self.requestPost             = function ( url, json, saveSuccess ) {
        SHINKEN.COMUNICATION.requestPost( url, json, saveSuccess, self.onTimeoutError, "", self.doActionAfter401 );
    };
    self.onTimeoutError          = function () {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "common.broker_unreachable" ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
        self.current_page.onTimeoutError();
    };
    self.doActionAfter401        = function () {
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "raise-error-401" );
    };
    self.doActionAfter403        = function () {
        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "raise-error-403" );
    };
    self.doActionAfter400        = function ( data ) {
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _( "common.raise_error_400" ), SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
        self.current_page.onTimeoutError();
    };
    self.askShowLoadingPage      = function () {
        document.querySelector( ".shinken-grid-page-container" ).classList.remove( "shinken-hidden" );
        document.querySelector( '.shinken-grid-page-container .shinken-loading-after-reset' ).classList.remove( "shinken-hidden" );
        DOM.Service.setStyle( self.current_page.content.dom_element, "opacity", 0 );
    };
    self.askCloseLoadingPage     = function () {
        DOM.Service.setStyle( self.current_page.content.dom_element, "opacity", 1 );
        document.querySelector( '.shinken-grid-page-container .shinken-loading-after-reset' ).classList.add( "shinken-hidden" );
    };
    return self;
})
( CONTROLLER.PageController || {} );
